/*
 *  These are the WWW - Midas Interface routines
 */ 
#ifdef UCX
#include <types.h>
#include <socket.h>
#include <ioctl.h>
#include <errno.h>
#include <in.h>
#define bcopy(a, b, c) (void) memmove ((void *) (b), (void *) (a), (size_t) (c))
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <netinet/in.h>
#endif /* UCX */
#include <netdb.h>
#include <stdio.h>
#ifndef VAX
#include <unistd.h>
#include <fcntl.h>
#endif

#ifndef hpux
#include <signal.h>
#endif

#ifdef sun
#define atexit(x) on_exit(x,NULL)
extern int sys_nerr;
extern char *sys_errlist[];
#define strerror(n) (n<sys_nerr ? sys_errlist[n] : "Unknown error code")
#endif

#ifdef VAX
#define NO_NBIO
#define unlink(a) delete(a)
#define CADDR_T
#define __TYPES_LOADED
#include ctype
#endif

#include "midaswww.h"
/* 
#include "SGMLHyper.h"
#include "SGMLCompositeText.h"
#include "SGMLListText.h"
#include "SGMLAnchorText.h"
#include "SGMLContainerText.h"
#include "SGMLMarkerText.h"
#include "SGMLFormattedText.h"
#include "SGMLPlainText.h"
*/

#include <Xm/MessageB.h>
#include <string.h>

extern XrmQuark fileDestination;

/*
 * Fetch the document using TCP/IP and HTTP
 * ----------------------------------------
 */
Widget WWWFetchDocumentHTTP(w,file,mb)
Widget w;
WWWFile *file;
MessageBlock *mb;
{
  char *command; 
  Widget result = NULL;
  DataSource data;
  int s;
  char *ext;
  WWWFiletype *filetype;  
  char buffer[8096];

  if (file->port == 0) file->port = appResources.default_HTTP_port;

  filetype = WWWGetFiletype(XrmQuarkToString(file->file),appResources.httpDefaultFiletype);
  if (filetype->Destination == fileDestination)
    {
      /* First we need to ask the user where he wants to save this thing?? 
       */  
      if (!WWWAskForFileDestination(w,mb,filetype,FALSE)) goto cleanup;
    }

  s = TCPIPConnect(file,mb);
  if (s == 0) goto cleanup;
  
  command = XtMalloc(20 + (file->file ? strlen(XrmQuarkToString(file->file)) : 0));
  strcpy(command,"GET ");
  strcat(command,file->file ? XrmQuarkToString(file->file): "/");
  strcat(command,"\r\n");

  if (!TCPIPWriteAndWaitForResponse(s,file,mb,command)) goto cleanup;
  XtFree(command);

  WWWInitDataSource(&data,mb,buffer,sizeof(buffer),socket_read,s);

  mb->flag = -1;

  result = WWWLoadByFiletype(w,mb,filetype,GetCharacter,&data);

cleanup:
  
  WWWFreeFiletype(filetype);
  if (s) socket_close(s);
  return result;
}  

