
#ifndef LYSTRINGS_H
#define LYSTRINGS_H

#include <string.h>

extern char * LYstrncpy PARAMS((char *dst, char *src, int n));
extern int LYgetch NOPARAMS;
extern int LYgetstr PARAMS((char *inputline, int hidden));
extern char * LYstrstr PARAMS((char *chptr, char *tarptr));

extern char * SNACopy PARAMS((char **dest, CONST char *src, int n));
extern char * SNACat PARAMS((char **dest, CONST char *src, int n));

#define StrnAllocCopy(dest, src, n)  SNACopy (&(dest), src, n)
#define StrnAllocCat(dest, src, n)   SNACat  (&(dest), src, n)

#define printable(c) (((c)>31 && (c)<=255) || (c)==9 || (c)==10 || (c)<0 )

/* values for LYgetch */
#define UPARROW 201
#define DNARROW 202
#define RTARROW 203
#define LTARROW 204
#define PGDOWN  205
#define PGUP    206
#define HOME    207
#define END     208
#define F1      209
#define DO_NOTHING 210

#define VISIBLE 0
#define HIDDEN  1

#endif /* LYSTRINGS_H */
