#include "LYCurses.h"
#include "HTUtils.h"
#include "LYUtils.h"
#include "LYStrings.h"
#include "LYGlobalDefs.h"
#include "LYOptions.h"

#define ACCEPT_DATA "Hit return to accept entered data"

PUBLIC void options ()
{
    int response=0;
    int itmp;
    /* if the user changes the display I need memory to put it in */
    char display_option[128]; 
    static char putenv_command[138];

    clear(); 
    move(0,5);  addstr("                     Options Menu");

    move(L_EDITOR,5);  
    printw("E)ditor                    : %s",(*editor=='\0'?"NONE":editor));
    move(L_DISPLAY,5);  
#ifndef VMS
    printw("D)ISPLAY variable          : %s",(display==NULL? "NONE":display));
#else
    printw("D)ISPLAY variable          : Not available on VMS");
#endif VMS

    move(L_MAIL_ADDRESS,5);  
    printw("P)ersonal mail address     : %s",
		(*personal_mail_address=='\0'?"NONE": personal_mail_address));
    
    move(L_HOME,5);  
    printw("B)ookmark file             : %s",(*bookmark_page=='\0'?"NONE": 
							      bookmark_page));
    move(L_SSEARCH,5); 
    printw("S)earching type            : %s",(case_sensitive ?
				        "CASE SENSITIVE" : "CASE INSENSITIVE"));
    move(L_EXEC,5); 
    printw("L)ocal execution links     : %s",
		    (local_exec ? "ALWAYS ON" : 
		    (local_exec_on_local_files ? "FOR LOCAL FILES ONLY" :
				    "ALWAYS OFF")));
    
    move(L_VIKEYS,5); 
    printw("V)I keys                   : %s", (vi_keys ? "ON" : "OFF"));
    
    move(L_EMACSKEYS,5); 
    printw("e(M)acs keys               : %s", (emacs_keys ? "ON" : "OFF"));
    
    move(L_KEYPAD,5); 
    addstr("K)eypad as arrows\n");
    addstr("     "); /* five spaces */
    printw("     or Numbered links     : %s", 
			   		(keypad_mode == NUMBERS_AS_ARROWS ? 
					"Numbers act as arrows" : 
				        "Links are numbered"));
    move(L_USER_MODE,5);
    printw("U)ser mode                 : %s",
			(user_mode == NOVICE_MODE ? "Novice" : 
			(user_mode == INTERMEDIATE_MODE ? "Intermediate" :
							     "Advanced")));
        
    move(20,2); addstr("Select first letter of option line, '>' to save, or 'r' to return to Lynx.");


    while(toupper(response) != 'R' && response != LTARROW && response != '>') {

           move(21,1); addstr("Command: ");

	   refresh();
           response = LYgetch();
	   switch(response) {
	 	case 'e':  /* change the editor */
		case 'E':
			if(*editor=='\0') {  /* clear the NONE */
			   move(L_EDITOR,34);
			   addstr("    ");
			}
			statusline(ACCEPT_DATA);
			move(L_EDITOR,34);  
			standout();
			LYgetstr(editor, VISIBLE);
			standend();
			move(L_EDITOR,34);
			addstr(editor);
			break;
#ifndef VMS
		case 'd':  /* change the display */
		case 'D':
			if(display == NULL) {  /* clear the NONE */
			   move(L_DISPLAY,34);
			   addstr("    ");
			} else
			    strcpy(display_option,display);
			statusline(ACCEPT_DATA);
			move(L_DISPLAY,34);
			standout();
			LYgetstr(display_option, VISIBLE);
			standend();
			move(L_DISPLAY,34);
			addstr(display_option);

#ifdef UNIX
			sprintf(putenv_command,"DISPLAY=%s",display_option);
			putenv(putenv_command);
		        display = getenv("DISPLAY");
#endif UNIX
			break;
#endif VMS
		case 'b':  /* change the bookmark page location */
		case 'B':
			/* anonymous users should not be allowed to
			 * change the bookmark page
			 */
			if(!anonymous) {
			    if(*editor=='\0') {  /* clear the NONE */
			       move(L_HOME,34);
			       addstr("    ");
			    }
			    statusline(ACCEPT_DATA);
			    move(L_HOME,34); 
			    standout();
			    LYgetstr(bookmark_page, VISIBLE);
			    standend();
			    move(L_HOME,34);
			    addstr(bookmark_page);
			} else { /* anonymous */
			   statusline("anonymous users cannot change the bookmark file!");
			}
			    break;
    
		case 'p':  /* change the bookmark page location */
		case 'P':
		 	if(*personal_mail_address=='\0') {/* clear the NONE */
			   move(L_MAIL_ADDRESS,34);
			   addstr("    ");
			}
			statusline(ACCEPT_DATA);
			move(L_MAIL_ADDRESS,34);
			standout();
			LYgetstr(personal_mail_address, VISIBLE);
			standend();
			move(L_MAIL_ADDRESS,34);
			addstr(personal_mail_address);
			break;

		case 's':
		case 'S':
			 case_sensitive = boolean_choice(case_sensitive,
			     L_SSEARCH,"CASE INSENSITIVE","CASE SENSITIVE  ","");
			break;
		case 'l':  /* local exec */
		case 'L':
			 if(local_exec) {
				itmp=2;
			 } else {
			  	if(local_exec_on_local_files)
				    	itmp=1;
				else
					itmp=0;
			 }
			 itmp = boolean_choice(itmp, L_EXEC,
        "ALWAYS OFF          ", "FOR LOCAL FILES ONLY","ALWAYS ON           ");

			 switch(itmp) {
			    case 0:
				local_exec=FALSE;
				local_exec_on_local_files=FALSE;
				break;
			    case 1:
				local_exec=FALSE;
				local_exec_on_local_files=TRUE;
				break;
			    case 2:
				local_exec=TRUE;
				local_exec_on_local_files=FALSE;
				break;
			} /* end switch */
			break;
		case 'v':
		case 'V':
			vi_keys = boolean_choice(vi_keys,
			       L_VIKEYS,"OFF","ON ","");
			break;
		case 'M':
		case 'm':
			emacs_keys = boolean_choice(emacs_keys,
			       L_EMACSKEYS,"OFF","ON ","");
			break;
		case 'k':
		case 'K':
			keypad_mode = boolean_choice(keypad_mode,
			       L_KEYPAD+1,"Numbers act as arrows",
					"Links are numbered   ","");
			break;
		case 'u':
		case 'U':
			user_mode = boolean_choice(user_mode,
				L_USER_MODE, "Novice      ","Intermediate",
							    "Advanced    ");
			if(user_mode == NOVICE_MODE)
			   display_lines = LINES-4;
			else
			   display_lines = LINES-2;
			break;
		case '>':
			statusline("Saving...");
			save_rc();
			statusline("Saved!");
			sleep(1);
			break;
		case 'r':
		case 'R':
			break;
		default:
			statusline("'R' to return to lynx");
	    }  /* end switch */
     }  /* end while */
}


/* take a boolean status and prompt the user for a new status
 * and return it
 */
PUBLIC int boolean_choice ARGS5(int,status, int,line, char *,string0, 
				char *,string1, char *,string2)
{
	int response=0;
	BOOLEAN only_two=FALSE;

	if(*string2 == '\0')
	    only_two=TRUE;

	statusline(ACCEPT_DATA);
	/* highlight the current selection */
	move(line,34);
	standout();
	if(status == 0)
	    addstr(string0);
	else if(status == 1)
	    addstr(string1);
	else 
	    addstr(string2);

	statusline("Hit any key to change value; RETURN to accept");

	standout();  /* statusline might turn it off */

	while(1) {
	   move(line,34);
	   response = LYgetch();
	   if(response != '\n' && response != '\r') {
		if(status) {
		    if(only_two || status == 2) {
		        status = 0;
		        addstr(string0);
		    } else {
			status = 2;
		        addstr(string2);
		    }
		} else {
		    status = 1;
		    addstr(string1);
		}
	        refresh();
	    } else {
		statusline("Value accepted");

		/* unhighlight selection */
	        move(line,34);
	        standend();
	        if(status == 0)
	            addstr(string0);
	        else if(status == 1)
	            addstr(string1);
	        else 
	            addstr(string2);

	 	return(status);
	    }
	}
}





