#include "LYCurses.h"
#include "HTUtils.h"
#include "LYSignal.h"
#include "LYUtils.h"
#include "LYClean.h"
#include "LYStrings.h"

#include "userdefs.h"
#include "LYGlobalDefs.h"

/*
 * mailmsg sends a message to the owner of the
 * file if one is defined telling of errors. (ie link not available)
 */

PUBLIC void mailmsg ARGS4(int,cur, char *,owner_address, 
		char *,filename, char *,linkname)
{
#ifndef MSDOS
	FILE *fd, *ofp;
	char cmd[256], *tmptr;
	char tmpfile[80];
	char *address_ptr1, *address_ptr2;
	BOOLEAN first=TRUE;

	if((tmptr = (char *)strchr(owner_address,'\n')) != NULL)
		*tmptr = '\0';

#ifdef UNIX
	/* mail -s "subject line" [owner's_address,] Alertmail */
	sprintf(cmd, "%s -t", SYSTEM_MAIL);

	if ((fd = popen(cmd, "w")) == NULL) 
			return;

	fprintf(fd,"To:%s\n", owner_address);
	fprintf(fd,"Subject:Lynx Error in %s\n\n",filename);
	fprintf(fd,"X-URL:%s\n",filename);
	fprintf(fd,"X-Mailer:Lynx, Version %s\n",LYNX_VERSION);
#endif UNIX
#ifdef VMS
	sprintf(tmpfile,"%s%s",TEMP_SPACE, "temp_mail.");
	if((fd = fopen(tmpfile,"w")) == NULL)
	    return;

#endif VMS

	fprintf(fd,"The link   %s :?: %s \n",
                links[cur].lname, links[cur].target);
	fprintf(fd,"called \"%s\"\n",links[cur].hightext);
	fprintf(fd,"in the file \"%s\" called \"%s\"",filename,linkname);

	fputs("\nwas requested but was not available.",fd);
	fputs("\n\nThought you might want to know.",fd);

	fputs("\n\nThis message was automatically generated by\n",fd);
	fprintf(fd,"Lynx ver. %s",LYNX_VERSION);
#ifdef UNIX
	pclose(fd);
#endif UNIX
#ifdef VMS
	fclose(fd);
	sprintf(cmd, "%s /subject=\"Lynx Error in %s\" %s ",SYSTEM_MAIL,
							filename,tmpfile);


	address_ptr1 = owner_address;
	do {
	    if((tmptr = strchr(address_ptr1,",")) != NULL) {
	        address_ptr2=tmptr+1;
	        *tmptr = '\0';
	    } else
		address_ptr2=NULL;
	
	    if(strlen(owner_address) > 3) {
		if(!first)
		    strcat(cmd, ", ");  /* add a comma and a space */
	        sprintf( &cmd[strlen(cmd)], MAIL_ADRS, address_ptr1);
		first = FALSE;
	    }

	    address_ptr1=address_ptr2;
	} while(address_ptr1!=NULL);

	signal(SIGINT, SIG_IGN);
	system(cmd);
	signal(SIGINT, cleanup_sig);
	remove(tmpfile);
#endif VMS

#ifdef TRAVERSAL
	if((ofp = fopen(TRAVERSE_ERRORS,"a+")) == NULL) {
		perror("unable to open traversal errors output file");
		exit(1);
	}

	fprintf(ofp,"%s	%s 	in %s\n",links[cur].lname, links[cur].target,
		filename);
	fclose(ofp);
#endif TRAVERSAL

#endif MSDOS

	return;
}

/*
 * this procedure only works on unix & VMS 
 * reply by mail invokes sendmail or mail on VMS to send a comment 
 * from the users to the owner 
 */

/* global variable for async i/o */
BOOLEAN term_letter;
void terminate_letter  PARAMS((int sig));
void remove_tildes PARAMS((char *string));

PUBLIC void reply_by_mail ARGS2(char *,mail_address, char *,filename)
{
	char command[100];
	char subject[256];
	char user_input[1000];
	FILE *fd;
	char c;  /* user input */
	char cmd[256], *tmptr, *address_ptr1, *address_ptr2;
	char tmpfile[100];
	BOOLEAN first=TRUE;

	term_letter=FALSE;

	clear();
	move(2,0);

	tempname(tmpfile,NEW_FILE);
	if((fd = fopen(tmpfile,"w")) == NULL)
	    return;

	if(*mail_address != '\0') {
	    addstr("You are now sending a comment to:");
	    addstr("\n	");
	    addstr(mail_address);
	    addch('\n');
	}

#ifdef UNIX /* Use ^G to cancel mailing of comment */
	/* don't let sigints exit lynx */
        signal(SIGINT, terminate_letter); /* */   /* NEW */

	/* put the to: line in the temp file */
	fprintf(fd,"To:%s\n", mail_address);
	fprintf(fd,"X-URL:%s\n",filename);
	fprintf(fd,"X-Mailer:Lynx, Version %s\n",LYNX_VERSION);
#endif UNIX


	addstr(" Please enter your name, or leave it blank if you wish to remain anonymous\n");
	strcpy(user_input,"Personal_Name: ");
	if (LYgetstr(user_input, VISIBLE) < 0 || term_letter) {
	    statusline("Comment request cancelled!!!");
	    fclose(fd);  /* close the temp file */
	    sleep(1);
	    goto cleanup;
	}

	remove_tildes(user_input);

	term_letter=FALSE;
	fprintf(fd,"%s\n",user_input);

	addstr("\n\n Please enter a mail address or some other\n");
	addstr(" means to contact you, if you desire a response.\n");
	strcpy(user_input,"From: ");
	/* add the mail address if there is one */
	if(*personal_mail_address != '\0')
	    strcat(user_input,personal_mail_address);

	if (LYgetstr(user_input, VISIBLE) < 0 || term_letter) {
	    statusline("Comment request cancelled!!!");
	    sleep(1);
	    fclose(fd);  /* close the temp file */
	    goto cleanup;
	}
	remove_tildes(user_input);

	fprintf(fd,"%s\n",user_input);

	addstr("\n\n Please enter a subject line\n");
	strcpy(user_input,"Subject: ");
	if (LYgetstr(user_input, VISIBLE) < 0 || term_letter) {
	    statusline("Comment request cancelled!!!");
	    sleep(1);
	    fclose(fd);  /* close the temp file */
	    goto cleanup;
	}
	if(*filename == '\0')
	    strncpy(subject, user_input,255);

	remove_tildes(user_input);

	fprintf(fd,"%s\n",user_input);

	if(!anonymous && *editor != '\0') {
	    fclose(fd);

	    /* spawn the users editor on the mail file */
	    sprintf(user_input,"%s %s",editor,tmpfile);
	    statusline("Spawning your selected editor to edit mail message");
	    stop_curses();
	    if(system(user_input)) {
	        start_curses();
		statusline("Error spawning editor, check your editor definition in the options menu");
	  	sleep(1);
	    } else {
	        start_curses();
	    }

	} else {
	
	    addstr("\n\n Please enter your message below.");
	    addstr("\n When you are done, press enter and put a single period (.)");
	    addstr("\n on a line and press enter again.");
	    addstr("\n\n");
	    scrollok(stdscr,TRUE);
	    refresh();
    	    *user_input = '\0';
	    if (LYgetstr(user_input, VISIBLE) < 0 || term_letter) {
	        statusline("Comment request cancelled!!!");
	        sleep(1);
	        fclose(fd);  /* close the temp file */
	        goto cleanup;
	    }


	    while(!STREQ(user_input,".") && !term_letter) { 
	       addch('\n');
	       remove_tildes(user_input);
	       fprintf(fd,"%s\n",user_input);
	       *user_input = '\0';
	       if (LYgetstr(user_input, VISIBLE) < 0) {
	          statusline("Comment request cancelled!!!");
	          sleep(1);
	          fclose(fd);  /* close the temp file */
	          goto cleanup;
	       }
	    }

	    fprintf(fd,".\n");
	    fprintf(fd,"\n");

	    fclose(fd);  /* close the temp file */
	    scrollok(stdscr,FALSE);  /* stop scrolling */
	}

	statusline("Send this comment? (y/n) ");
	while((c = toupper(LYgetch())) != 'Y' && c != 'N')
	    ; /* null body */

	clear();  /* clear the screen */

	if(c == 'N') {
	   goto cleanup;
	}

#ifdef VMS
	sprintf( cmd, "%s /subject=\"Commenting from file %s\" %s ",
		  SYSTEM_MAIL, filename, tmpfile);

	/* now add all the people in the mail_address field */
	address_ptr1 = mail_address;
	do {
	    if((tmptr = strchr(address_ptr1,",")) != NULL) {
	        address_ptr2= (tmptr+1);
	        *tmptr = '\0';
	    } else
		address_ptr2=NULL;
	    
	    /* 4 letters is arbitrarily the smallest posible mail address,
	     * at least for lynx.  That way extra spaces won't
	     * confuse the mailer and give a blank address
	     */
	    if(strlen(address_ptr1) > 3) {	
	        if(!first)
		    strcat(cmd, ", ");  /* add a comma and a space */
	        sprintf( &cmd[strlen(cmd)], MAIL_ADRS, address_ptr1);
		first=FALSE;
	    }

	    address_ptr1=address_ptr2;
	} while(address_ptr1!=NULL);

        stop_curses();
	printf("Sending your comment.  Please wait...");
	signal(SIGINT, SIG_IGN);
	system(cmd);
	signal(SIGINT, cleanup_sig);
	start_curses();
#else
	/* send the tmpfile into sendmail.  
	 */
	sprintf(cmd,"%s -t < %s", SYSTEM_MAIL, tmpfile);

	signal(SIGINT, SIG_IGN);
	system(cmd);

	if(TRACE)
	    printf("%s\n",cmd);

#endif VMS

	/* come here to cleanup and exit */
cleanup:
#ifdef UNIX
	signal(SIGINT, cleanup_sig);
#endif UNIX

	scrollok(stdscr,FALSE);  /* stop scrolling */
	remove(tmpfile);
}

PRIVATE void terminate_letter ARGS1(int,sig)
{
	term_letter=TRUE;
#ifdef NOTDEFINED /* Can't get vsignal to work during LYgetstr() calls  */
		  /* Problem appears to be due to the recurring timed reads */
#ifdef VMS
	signal(SIGINT, terminate_letter);
#endif
#endif NOTDEFINED
}

PRIVATE void remove_tildes ARGS1(char *,string)
{
       /* change the first character to a space if
	* it is a '~'
	*/
    if(*string == '~')
	*string = ' ';
}
