#include "HTUtils.h"
#include "HTAnchor.h"       /* Anchor class */
#include "HTAccess.h"
#include "LYGlobalDefs.h"
#include "LYUtils.h"
#include "LYSignal.h"
#include "LYGetFile.h"
#include "LYPrint.h"
#include "LYHistory.h"
#include "LYStrings.h"
#include "LYClean.h"

#ifndef VMS
#include <sys/types.h>
#include <sys/file.h>
#if SVR4
#include <sys/fcntl.h>
#endif
#endif

extern char * HTLoadedDocumentURL();

PUBLIC BOOLEAN getfile ARGS1(document *,doc)
{
	register int itmp;
        int url_type;
	char *tmptr;

	if(TRACE) {
	    fprintf(stderr,"getfile: getting %s\n",doc->address);
	}

	/* make sure the interupt is not set before we attempt
	 * the transfer
	 */
	InteruptTransfer = FALSE;
	
	/* check to see if this is a universal document ID
	 * that lib WWW wants to handle
 	 *
	 * some special URL's we handle ourselves :)
	 */
	 if((url_type = is_url(doc->address)) != 0) {
#ifdef TRAVERSAL
		/* only done for traversals IGNORE! */
		if(url_type == HTTP_URL_TYPE) {
		    if(!HTLoadAbsolute(doc->address))
		        return(NOT_FOUND);
		} else {
		    return(NULLFILE);
		}
#else
		if(url_type == LYNXPRINT_URL_TYPE) {
		    return(printfile(doc));

		} else if(url_type == LYNXHIST_URL_TYPE) {
			/* doc will change to the new file */
		    historytarget(doc);
		    if(!HTLoadAbsolute(doc->address))
		        return(NOT_FOUND);
		    return(NORMAL);

		  /* disable www telnet access if not telnet_ok */
		} else if((url_type == TELNET_URL_TYPE || 
				url_type == TN3270_URL_TYPE) ) {

		    if(!telnet_ok) {
		    	statusline("Telnet access is disabled!");
		    	sleep(1);
		    } else {
			stop_curses();
                        HTLoadAbsolute(doc->address);
			start_curses();
                        fflush(stdout);

		    }

		    return(NULLFILE);

		} else if(url_type == RLOGIN_URL_TYPE) {

		    stop_curses();
                    HTLoadAbsolute(doc->address);
                    fflush(stdout);
		    start_curses();
		    return(NULLFILE);

		} else if(url_type == MAILTO_URL_TYPE) {
		    tmptr = (char *)strchr(doc->address,':')+1;
		    reply_by_mail(tmptr,"");
		    return(NULLFILE);
		
		} else {
		    user_message(WWW_WAIT_MESSAGE,doc->address);

		   /* set up a way of asyncronously aborting the
		    * the transfer in mid-stream.
		    */
#ifdef HAVE_SIGIO
     		    fcntl (0, F_SETOWN, getpid() );
     		    fcntl ( 0, F_SETFL, FASYNC );
     		    signal(SIGIO, async_interupt); /* */
#else
     		    signal(SIGINT, async_interupt); /* */
#endif HAVE_SIGIO
		    if(!HTLoadAbsolute(doc->address)) {
		    /* return the interupts to the way they were */
#ifdef HAVE_SIGIO
                        signal(SIGIO, SIG_IGN);
#else
                        signal(SIGINT, cleanup_sig);
#endif HAVE_SIGIO
		        return(NOT_FOUND);
		    }

		    lynx_mode = NORMAL_LYNX_MODE;

		    /* return the interupts to the way they were */
#ifdef HAVE_SIGIO
                    signal(SIGIO, SIG_IGN);
#else
                    signal(SIGINT, cleanup_sig);
#endif HAVE_SIGIO

		    /* some URL's don't actually return a document
		     * compare doc->address with the document that is 
		     * acctually loaded and return NULL if not
		     * loaded.  If www_search_result is not -1
		     * then this is a reference to a named anchor
		     * within the same document.  Do NOT return
		     * NULL
		     */
                    {
                        char *pound;
                        /* check for #selector */
                        pound = (char *)strchr(doc->address, '#');

                        if(pound == NULL &&
                                strcmp(doc->address, HTLoadedDocumentURL()) ) {
                            return(NULLFILE);

                        } else {
                        /* may set www_search_result */
                            if(pound != NULL)
                                HTFindPoundSelector(pound+1);
                            return(NORMAL);
                        }
                    }
		}
#endif TRAVERSAL
	  } else {
	      statusline("Badly formed address");
	      sleep(1);
	  }
}

/* the user wants to select a link by number
 * if follow_link_number returns DO_LINK_STUFF do_link will be
 * run immeditely following its execution.
 * if follow_link_number returns PRINT_ERROR an error message will
 * be given to the user, if follow_link_number returns DO_FORMS_STUFF
 * some forms stuff will be done, and if follow_link_number returns
 * DO_NOTHING nothing special will run after it.
 */

PUBLIC int follow_link_number ARGS2(int,c, int *,cur)
{
    char temp[120];
    int link_number;

    temp[0] = c;
    temp[1] = '\0';
    statusline("follow link number: ");
    /* get the number from the user */
    if (LYgetstr(temp, VISIBLE) <0 || strlen(temp) == 0) {
        statusline("Cancelled!!!");
        sleep(1);
        return(DO_NOTHING);
    }

    link_number = atoi(temp);

    if (link_number > 0)  {
              /* get the lname, and hightext,
               * direct from
               * www structures and add it to the cur link
               * so that we can pass it transparently on to
               * get_file()
               * this is done so that you may select a link
               * anywhere in the document, whether it is displayed
               * on the screen or not!
               */
	       if(HTGetLinkInfo(link_number, &links[*cur].hightext, 
					 &links[*cur].lname)) {
                   links[*cur].type = WWW_LINK_TYPE;

		   return(DO_LINK_STUFF);
       		} else {
		   return(PRINT_ERROR);
		}
    } else {
            return(PRINT_ERROR);
    }

}
