#include "LYCurses.h"
#include "HTUtils.h"
#include "LYSignal.h"
#include "LYUtils.h"
#include "LYClean.h"
#include "LYGlobalDefs.h"
#include "LYEdit.h"
#include "LYStrings.h"

/*
 *  in edit mode invoke either emacs or vi or the default editor
 *  to display and edit the current file
 *  Both vi and emacs will open the file to the same line that the
 *  screen cursor is on when editing is invoked
 *  returns FALSE if file uneditable
 */

PUBLIC int edit_current_file ARGS3(char *,newfile, int,cur, int,lineno)
{

	char command[90];
        char *filename;
	char *colon, *localhost_ptr;
	FILE *fp;
	int url_type = is_url(newfile);

	/* if its a remote file then we can't edit it */
	if(url_type != FILE_URL_TYPE) {
	    statusline("Lynx cannot currently edit remote WWW files");
	    sleep(1);
	    return FALSE;
	}

	 /* try and open it as a completely referenced file */
	colon = strchr(newfile,':');
	if((fp = fopen(colon+1,"r")) == NULL) {

	    localhost_ptr = strstr(newfile,"localhost");
	    if(localhost_ptr==NULL || 
#ifdef VMS
				(fp = fopen(localhost_ptr+10,"r"))==NULL) {
#else
				(fp = fopen(localhost_ptr+9,"r"))==NULL) {
		    
#endif /* VMS */
	        statusline("Lynx cannot currently edit remote WWW files");
	        sleep(1);
	        return FALSE;
	    } else {
#ifdef VMS
		filename = localhost_ptr+10;
#else
		filename = localhost_ptr+9;
#endif /* VMS */
	        fclose(fp);
	    }
	} else {
	    filename = colon+1;
	    fclose(fp);
	}
		

#ifndef VMS
	if(strstr(editor,"emacs") || strstr(editor,"vi")) 
	    sprintf(command,"%s +%d \"%s\"",editor, lineno+links[cur].ly, 
                                                                filename);
	else
	       sprintf(command,"%s \"%s\"",editor, filename);

#else /* VMS */
        sprintf(command,"%s %s",editor, filename);
#endif /* VMS */

	stop_curses();
	signal(SIGINT, SIG_IGN);
	system(command);
	signal(SIGINT, cleanup_sig);
	start_curses();
	return TRUE;
}
