#!/bin/sh

INSTDIR=$1
USERINST=$2
MODDIR=/lib/modules/`uname -r`
DISTDIR=`uname -r | sed -e's/-.*$//g'`


if [ ! -d $DISTDIR ]; then
    echo "The modules matching the installalled OS version $DISTDIR"
    echo "Could not be found.  The  version closest to your"
    echo "installed version may work."
    echo "cp <closest match>/plconf /sbin"
    echo "cp <closest match>/*.o $MODDIR"
    echo "You may need to use insmod -f to get the modules to load."
    echo "This script will now install the non OS dependent files."
fi

if [ ! -z "$INSTDIR" ]; then
	cd $INSTDIR
elif [ -f plink_config ] && [ -f $DISTDIR/plconf ]; then
	INSTDIR=`pwd`
elif [ -d /mnt/cdrom/phobos/Linux ]; then
	INSTDIR="/mnt/cdrom/phobos/Linux"
	cd $INSTDIR
else
	echo "Usage: install_phoboslink <installation_directory> [module_directory]"
	echo "Could not find the PhobosLink files!"
	echo "Please check the installation directory.  This scripts checks"
	echo "the current directory and \"/mnt/cdrom/phobos/Linux\" for the"
	echo "installation files."
	exit 1
fi

if [ -f phoboslink ] && [ -f plink_config ]; then
	# copy in the PhobosLink startup files
	if [ -f $DISTDIR/plconf ]; then
	    cp $DISTDIR/plconf /sbin/plconf
	fi
	cp phoboslink /etc/rc.d/init.d/phoboslink
	cp plink_config /usr/bin/plink_config
	cp pge_control /usr/bin/pge_control
	cp PGEControl /usr/bin/PGEControl

# Make sure that PhobosLink has started before we
# try to configure the interfaces associated with it.
# In RedHat the network starts with rc2.d/S10network
	ln -fs /etc/rc.d/init.d/phoboslink /etc/rc.d/rc2.d/S9phoboslink
else 
	echo "We could not find all the appropriate installation files!"
	echo "Please check your Phobos Distribution for the following files:"
	echo ""
	echo "	plconf"
	echo "	phoboslink"
	echo "	plink_config"
	echo "	pge_control"
	echo "	PGEControl"
	exit 1
fi

DIRSUP=*
cwd=`pwd`
FOUND=""
SMP="NOSMP"
		
if [ -d $DISTDIR ] && [ ! -z "$MODDIR" ]  && [ -d "$MODDIR" ]; then
	cp $DISTDIR/plink.o $MODDIR/net/plink.o
	cp $DISTDIR/p1000.o $MODDIR/net/p1000.o
	MODDIR=""
	DIRS=""
	FOUND="TRUE"
fi
		
if [ -z $FOUND ]; then
	echo "We did not find a modules directory!!"
	echo "You need to copy the \"p1000.o\" and \"plink.o\" files into your"
	echo "appropriate modules directory."
	echo "The appropriate initialization startup scripts have been installed into the"
	echo "current \"etc/rc.d/init.d\", \"/sbin\" and \"/usr/bin\" directorys.  Should"
	echo "you have a different disk or partition for your module you will also"
	echo "need to copy the \"plconf\" file to \"/sbin\", \"phoboslink\" to the init.d"
	echo "directory and \"pge_control\" and \"PGEControl\" to \"/usr/bin\"."
	echo "A symbolic link is also necessary in in \"/etc/rc.d/rc2.d/\" to"
	echo "\"/etc/rc.d/init.d/phoboslink\" to start PhobosLink BEFORE trying to configure"
	echo "the plink# interfaces.  We use \"S9phoboslink\"."
fi
