"""
    project............: Fuchsschwanz
    description........: ICB server
    date...............: 05/2019
    copyright..........: Sebastian Fedrau

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.
"""
import json
from io import StringIO

def to_key(k):
    builder = StringIO()

    was_upper = False

    for c in k:
        if c.isupper() and not was_upper:
            builder.write("_%s" % c.lower())
            was_upper = True
        else:
            builder.write(c.lower())
            was_upper = c.isupper()

    return builder.getvalue()

def add_kv(m, k, v):
    if isinstance(v, dict):
        for kx, vx in v.items():
            add_kv(m, "%s_%s" % (k, to_key(kx)), vx)
    else:
        m[to_key(k)] = v

def load(filename):
    with open(filename) as f:
        m = {}

        for k, v in json.load(f).items():
            add_kv(m, k, v)

        return m
