/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#include "itemset.h"

#include <stdlib.h>

#include "util.h"
#include "unittest.h"

static int test_duplication(struct util_ctx *ctx, intptr_t opaque)
{
    struct itemset *itemset = NULL;
    int e = -1;
    void *allocated_key = NULL;

    itemset = itemset_new();
    EXPECT_OR_EXIT(itemset);

    allocated_key = strdup("zeppola");

    EXPECT_OR_EXIT(
        itemset_add(itemset, (const uint8_t *)"zeppola", strlen("zeppola"))
        == itemset_eok
    );

    EXPECT_OR_EXIT(
        itemset_add(itemset, allocated_key, strlen(allocated_key))
        == itemset_edup
    );

    const void *aux = NULL;
    const uint8_t *data;
    uint16_t data_len;
    while (itemset_iter(itemset, &aux, &data, &data_len)) {
        EXPECT_OR_EXIT(data_len == strlen("zeppola"));
        EXPECT_OR_EXIT(memcmp(data, "zeppola", data_len) == 0);
    }

    e = 0;
exit:
    free(allocated_key);
    itemset_del(itemset);
    return e;
}

const struct test * list_test(void)
{
    static struct test tests[] = {
        TEST(1, test_duplication, NULL),
        END_TESTS
    };
    return tests;
}
