#!/bin/sh

set -e

. "$(dirname "$0")/common.sh"
: "${tarball:?}"

# Making sure that the system time is correct.
# This is needed for TLS to work properly
if [ "$sync_nntp" ]; then
	rdate pool.ntp.org
fi

export LD_LIBRARY_PATH="/usr/local/lib:$LD_LIBRARY_PATH"
export CPPFLAGS="-I/usr/local/include"
export LDFLAGS="-L/usr/local/lib"

add_dep() {
	local dep_name="${1:?}"
	set -x

	shift
	"$@" && echo "$dep_name: OK" || pkg_add "$dep_name"

	# pkg_add exits 0 on failure.  Testing dependency again
	"$@" && echo "$dep_name: OK" || exit 1
} >&2

add_dep uthash  test -e /usr/local/include/uthash.h
add_dep curl    pkg-config --exists libcurl
add_dep libnxml pkg-config --exists nxml
add_dep cmake   command -v cmake

src_install_configure \
	-n libmrss \
	-u https://github.com/dacav/libmrss/releases/download/0.19.2/libmrss-0.19.2.tar.gz \
	-t /usr/local/lib/libmrss.a

CC=clang src_install_cmake -T -f "$tarball" -n crossbow -D UT_SAN=OFF
