/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#pragma once

#include <stdbool.h>

struct download;
struct filemap;

enum download_status {
    dl_complete,
    dl_aborted,
    dl_fetch_failure,
    dl_sys_failure,
};

/* download_callback - download callback.
 *
 * Expected to return 0 on success.  If the return value is not 0 all
 * downloading processes will be interrupted.
 */
typedef int (*download_callback)(
    void *opaque,
    enum download_status,
    const char *errmsg,
    const struct filemap *filemap
);

struct download *download_new(bool global_init, unsigned maxjobs);

int download_schedule(
    struct download *,
    const char *url,
    download_callback,
    void *opaque
);

int download_perform(struct download *);

void download_abort(struct download *);

void download_del(struct download *);
