/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */
#pragma once

#include <stdint.h>
#include <stddef.h>

struct digest;

enum {
    digest_buflen = 20,
};

struct digest *digest_new(void);

int digest_add(struct digest *, const uint8_t *bytes, size_t len);

int digest_add_cstr(struct digest *, const char *s);

int digest_finish(struct digest *, uint8_t *bytes, size_t len);

int digest_reset(struct digest *d);

void digest_del(struct digest *);
