function(load_crossbow_version OutVersion OutVersionStr)
    set(VersionFile ${CMAKE_SOURCE_DIR}/.versionstr)

    if (EXISTS ${VersionFile})
        file(STRINGS ${VersionFile} VersionStr)
    else()
        execute_process(
            COMMAND git;describe;--always;--dirty
            WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
            OUTPUT_VARIABLE VersionStr
            ECHO_ERROR_VARIABLE
            OUTPUT_STRIP_TRAILING_WHITESPACE
        )
    endif()
    set(${OutVersionStr} ${VersionStr} PARENT_SCOPE)

    string(REGEX REPLACE "^v([0-9\.]*).*" "\\1" Version ${VersionStr})
    set(${OutVersion} ${Version} PARENT_SCOPE)
endfunction()

