# Crossbow - the minimalist feed aggregator

Crossbow is a simple but powerful RSS/Atom feed
aggregator

 * Designed to be invoked from cron(8) to fetch updates
   periodically.

 * It can easily convert feeds to email.

 * Entries can be handled with an external program,
   allowing for example, to automatically download
   and parse content, without user interaction.

 * Minimal set of dependencies.

 * Documented thoroughly.

## How to install:

1. Configure

```
	cmake [opts] -S . -B ./build
```

Supported build options:

 * `-D STRICT=ON`: enable strict build (`-Werror`, etc...)
 * `-D UT_SAN=ON`: enable compiler sanitisers for unit tests.

Please refer to the CMake documentation to learn about additional options.

2. Build

```
	cmake --build ./build
```

3. Run unit tests

```
	(cd ./build && ctest)
```

4. Install:

```
    cmake --install ./build
```

Tips:

 * Use the `DESTDIR` environment variable and `--prefix` command line options
   for software distribution packaging.
