/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#pragma once

#include <stdbool.h>
#include <stddef.h>

typedef struct rc rc_t;

typedef struct {
    unsigned short jobs;
    const char *persist_dir;
} rc_global_t;

typedef enum {
    rc_hdl_print,
    rc_hdl_exec,
    rc_hdl_pipe,
} rc_handler_t;

typedef struct {
    const char *name;
    const char *url;
    struct {
        const char *spec;
        size_t len;
    } ofmt;
    const char *chdir;
    rc_handler_t handler;
} rc_feed_t;

rc_t *rc_new(void);

int rc_parse_buffer(rc_t *, const char *str, size_t len);

int rc_load(rc_t *);

const rc_global_t * rc_get_global(const rc_t *);

const rc_feed_t * rc_get_feed(const rc_t *, unsigned idx);

unsigned rc_n_feeds(const rc_t *);

void rc_dump(const rc_t *);

void rc_free(rc_t *);
