/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */
#pragma once

typedef struct persist_item {
    void *data;
    unsigned short len;
} persist_item_t;

typedef struct persist_items persist_items_t;

persist_items_t * persist_items_new(unsigned size);

int persist_items_add(persist_items_t *, const persist_item_t *item);

void persist_items_set_store(
    persist_items_t *,
    void *store,
    void (*store_dtor)(void *store)
);

const persist_item_t * persist_items_get(const persist_items_t *, unsigned idx);

unsigned persist_items_size(const persist_items_t *);

void persist_items_del(persist_items_t *);
