/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */
#pragma once

#include <stdbool.h>

#include "persist_dir.h"

typedef struct persist_file persist_file_t;
typedef struct persist_items persist_items_t;

persist_file_t *persist_file_new(persist_dir_t *pd, const char *filename);

const char * persist_file_name(const persist_file_t *);

typedef enum
{
    pfs_unknown = 0,
    pfs_noent,         /* file does not exist yet */
    pfs_regular,       /* file exists */
    pfs_unrecognized,  /* file exists, format not recognized */
    pfs_incompat,      /* file exists, recognized, different version */
    pfs_corrupt,       /* file exists, recognized, same version, corrupt */
} persist_file_status_t;

bool persist_file_is_writeable(const persist_file_t *);

int persist_file_write(const persist_file_t *);

int persist_file_unlink(const persist_file_t *);

int persist_file_load(persist_file_t *);

persist_file_status_t persist_file_status(persist_file_t *);

unsigned persist_file_get_incrid(const persist_file_t *);

void persist_file_set_incrid(persist_file_t *, unsigned v);

const persist_items_t *persist_file_get_items(const persist_file_t *);

persist_items_t *persist_file_swap_items(persist_file_t *, persist_items_t *);

void persist_file_del(persist_file_t *);
