#pragma once

#include <stddef.h>

typedef struct filemap
{
    void *memory;
    size_t size;
} filemap_t;

filemap_t *filemap_new(void);
int filemap_load_fd(filemap_t *, int fd);
int filemap_load_path(filemap_t *, const char *fname);
void filemap_unload(filemap_t *);
void filemap_del(filemap_t *);
