/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#pragma once

#include <stdbool.h>

typedef struct download download_t;

typedef enum {
    dl_complete,
    dl_aborted,
    dl_fetch_failure,
    dl_sys_failure,
} download_status_t;

typedef struct filemap filemap_t;

/* download_cb_t - download callback.
 *
 * Expected to return 0 on success.  If the return value is not 0 all
 * downloading processes will be interrupted.
 */
typedef int (*download_cb_t)(
    void *opaque,
    download_status_t,
    const char *errmsg,
    const filemap_t *filemap
);

download_t *download_new(bool global_init, unsigned maxjobs);

int download_schedule(
    download_t *,
    const char *url,
    download_cb_t,
    void *opaque
);

int download_perform(download_t *);

void download_del(download_t *);
