/*
 * This file is part of Crossbow.
 *
 * Crossbow is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Crossbow is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Crossbow.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#pragma once

struct help_flag {
    const char *optname;
    const char *argname;
    const char *description;
};

typedef enum {
    help_usage,
    help_full,
} help_type_t;

struct help {
    const char *progname;
    const char *args;
    const struct help_flag *flags;
};

void show_help(help_type_t type, const struct help *, const char *warning);
