#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-method.h>
#include <libgnomevfs/gnome-vfs-mime.h>

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "gnopher-location.h"

#ifdef DEBUG
GMutex * mutex;
guint logcount;
#define GNOPHER_LOG(message)			\
do {						\
	FILE * file;				\
	if (logcount == 0)			\
		unlink ("/tmp/gnopher-log");	\
	g_mutex_lock (mutex);			\
	file = fopen ("/tmp/gnopher-log", "a");	\
	message;				\
	fflush (file);				\
/*	if (logcount == 9)			\
		exit(-1);*/			\
	logcount++;				\
	fclose (file);				\
	g_mutex_unlock (mutex);			\
} while (0)
#else
#define GNOPHER_LOG(message)
#endif /*DEBUG*/

GSList * gnopher_clicked_list = NULL;

/* Module entry points. */
GnomeVFSMethod *vfs_module_init     (const char     *method_name,
				        const char     *args);
void            vfs_module_shutdown  (GnomeVFSMethod *method);


static GnomeVFSResult
do_open (GnomeVFSMethod *method,
	 GnomeVFSMethodHandle **method_handle,
	 GnomeVFSURI *uri,
	 GnomeVFSOpenMode mode,
	 GnomeVFSContext *context)
{
	GnopherLocation * location;

	GNOPHER_LOG(fprintf (file, "[%u] Opening file: %s\n",
		logcount,
		gnome_vfs_uri_get_path (uri)));

	location = GNOPHER_LOCATION(gnopher_location_new ());

	gnopher_location_set_url (location, gnome_vfs_uri_to_string (uri, GNOME_VFS_URI_HIDE_NONE));

	if (gnopher_location_get_raw_data (location, 1) != GNOME_VFS_OK)
		g_printerr ("error reading data\n");

	g_printerr ("datasize: %d\n", location->datasize);

	location->wherewasi = 0;

	*method_handle = (GnomeVFSMethodHandle *) location;
g_printerr ("Location: %u\n", location);
	return GNOME_VFS_OK;
}

static GnomeVFSResult
do_close (GnomeVFSMethod *method,
	  GnomeVFSMethodHandle *method_handle,
	  GnomeVFSContext *context)
{
	GNOPHER_LOG(fprintf (file, "[%u] Closing file\n", logcount));

	gtk_object_unref (GTK_OBJECT(method_handle));

	return GNOME_VFS_OK;
}

static GnomeVFSResult
do_read (GnomeVFSMethod *method,
	 GnomeVFSMethodHandle *method_handle,
	 gpointer buffer,
	 GnomeVFSFileSize num_bytes,
	 GnomeVFSFileSize *bytes_read,
	 GnomeVFSContext *context)
{
	int i;
	GnopherLocation * location;
	char * buffer2;

	g_printerr ("read, location: %u\n", method_handle);
	g_assert (IS_GNOPHER_LOCATION(method_handle));

	location = (GnopherLocation *) method_handle;
	GNOPHER_LOG(fprintf (file, "[%u] do_read", logcount));
	g_printerr (" - datasize: %d\n", location->datasize);

	buffer2 = (char *) buffer;

	g_printerr ("voor for, listing inhoud\n");
	for (
		i = location->wherewasi;
		location->wherewasi < location->datasize && location->wherewasi - i < num_bytes;
		location->wherewasi++
	)
	{
		buffer2[location->wherewasi - i] = location->data[location->wherewasi];
	}

	*bytes_read = location->wherewasi - i;

	return GNOME_VFS_OK;
}

static GnomeVFSResult
do_seek (GnomeVFSMethod *method,
	 GnomeVFSMethodHandle *method_handle,
	 GnomeVFSSeekPosition whence,
	 GnomeVFSFileOffset offset,
	 GnomeVFSContext *context)
{
	GNOPHER_LOG(fprintf (file, "[%u] do_seek\n", logcount));

	return GNOME_VFS_ERROR_INTERNAL;
}

static GnomeVFSResult
do_tell (GnomeVFSMethod *method,
	 GnomeVFSMethodHandle *method_handle,
	 GnomeVFSFileOffset *offset_return)
{
	GNOPHER_LOG(fprintf (file, "[%u] Got tell\n", logcount));

	return GNOME_VFS_ERROR_INTERNAL;
}


static GnomeVFSResult
do_get_file_info (GnomeVFSMethod *method,
		  GnomeVFSURI *uri,
		  GnomeVFSFileInfo *file_info,
		  GnomeVFSFileInfoOptions options,
		  GnomeVFSContext *context)
{
	GSList * list;
	char * url;

	url = gnome_vfs_uri_to_string (uri, GNOME_VFS_URI_HIDE_NONE);
#ifdef DEBUG
	GNOPHER_LOG(fprintf (file, "[%u] Get file info: %s\n", logcount, url));
	GNOPHER_LOG(fprintf (file, "[%u] File info name: %s\n", logcount, file_info->name));
	GNOPHER_LOG(fprintf (file, "[%u] File info options: %d\n", logcount, options));
#endif

	/* handle the special gnopher: link-clicked notification events */
	if (!strncmp (url, "gnopher:", 8))
	{
		/* yay, we got file information for a clicked gopher URI!
		 * let's store it.
		 */

		GNOPHER_LOG(fprintf (file, "vfs heeft gnopher: url gekregen:%s\n", url));

		gnopher_clicked_list = g_slist_prepend (gnopher_clicked_list, url);


		file_info->mime_type = strdup ("application/x-gnopher-filetype-hack");
	}
	else
	{
		list = gnopher_clicked_list;

		while
		(
			list && list->data &&
			strcmp (((char *)(list->data)) + 9, url + 8)
		)
		{
			g_printerr ("Vergeleken: .%s. en .%s.\n", ((char *)(list->data)) + 9, url + 8);
			list = g_slist_next (list);
		}

		if (list)
		{
			g_printerr ("Gelijk: %s en %s\n", ((char *)(list->data)) + 9, url + 8);
			g_printerr ("Onderzoek filetype: %c\n", (*((char *)(list->data) + 8)));

			switch (*((char *)(list->data) + 8))
			{
				case '1':
					file_info->mime_type = strdup ("application/x-gopher-directory");
					break;
				case '0':
					file_info->mime_type = strdup ("text/plain");
					break;
				/* are the file types below official??? */
				case 'h':
					file_info->mime_type = strdup ("text/html");
					break;
				default:
					file_info->mime_type = strdup (gnome_vfs_get_mime_type_from_file_data (uri));
			}
		}
		else
		{
			g_printerr ("path is: .%s.\n", gnome_vfs_uri_get_path(uri));

			if (!strlen(gnome_vfs_uri_get_path(uri)))
				file_info->mime_type = strdup ("application/x-gopher-directory");
			else
				gnome_vfs_get_mime_type_from_file_data (url);
		}
	}

	file_info->type = GNOME_VFS_FILE_TYPE_REGULAR;

	file_info->valid_fields = file_info->valid_fields | GNOME_VFS_FILE_INFO_FIELDS_TYPE | GNOME_VFS_FILE_INFO_FIELDS_MIME_TYPE;

	return GNOME_VFS_OK;
}

static GnomeVFSResult
do_get_file_info_from_handle (GnomeVFSMethod *method,
			      GnomeVFSMethodHandle *method_handle,
			      GnomeVFSFileInfo *file_info,
			      GnomeVFSFileInfoOptions options,
			      GnomeVFSContext *context)
{
#ifdef DEBUG
	GNOPHER_LOG(fprintf (file, "[%u] Got fileinfofromh\n", logcount));
#endif

	file_info->mime_type = g_strdup ("application/x-gopher-directory");
	file_info->type = GNOME_VFS_FILE_TYPE_REGULAR;
	file_info->valid_fields = file_info->valid_fields | GNOME_VFS_FILE_INFO_FIELDS_TYPE;

	return GNOME_VFS_OK;
}

static gboolean
do_is_local (GnomeVFSMethod *method,
	     const GnomeVFSURI *uri)
{
#ifdef DEBUG
	GNOPHER_LOG(fprintf (file,
		"[%u] Local check, path: %s, host: %s, basename: %s\n",
		logcount,
		gnome_vfs_uri_get_path(uri),
		gnome_vfs_uri_get_host_name(uri),
  		gnome_vfs_uri_get_basename(uri)));
#endif

	return FALSE;
}

static GnomeVFSResult
do_check_same_fs (GnomeVFSMethod *method,
		  GnomeVFSURI *a,
		  GnomeVFSURI *b,
		  gboolean *same_fs_return,
		  GnomeVFSContext *context)
{
#ifdef DEBUG
	GNOPHER_LOG(fprintf (file, "[%u] Got samefs check\n", logcount));
#endif

	return GNOME_VFS_ERROR_INTERNAL;
}

static GnomeVFSResult
do_truncate (GnomeVFSMethod *method,
	     GnomeVFSURI *uri,
	     GnomeVFSFileSize where,
	     GnomeVFSContext *context)
{
#ifdef DEBUG
	GNOPHER_LOG(fprintf (file, "[%u] do_truncate\n", logcount));
#endif
	return GNOME_VFS_ERROR_INTERNAL;
}

static GnomeVFSResult
do_truncate_handle (GnomeVFSMethod *method,
		    GnomeVFSMethodHandle *method_handle,
		    GnomeVFSFileSize where,
		    GnomeVFSContext *context)
{
#ifdef DEBUG
	GNOPHER_LOG(fprintf (file, "[%u] do_truncate_handle\n", logcount));
#endif
	return GNOME_VFS_ERROR_INTERNAL;
}


static GnomeVFSMethod method = {
	sizeof (GnomeVFSMethod),
	do_open,
	NULL,			//do_create,
	do_close,
	do_read,
	NULL,			//do_write,
	do_seek,
	do_tell,
	do_truncate_handle,
	NULL,			//do_open_directory,
	NULL,			//do_close_directory,
	NULL,			//do_read_directory,
	do_get_file_info,
	do_get_file_info_from_handle,
	do_is_local,
	NULL,			//do_make_directory,
	NULL,			//do_remove_directory,
	NULL,			//do_move,
	NULL,			//do_unlink,
	do_check_same_fs,
        NULL,			//do_set_file_info,
	do_truncate,
	NULL,
	NULL,			//do_create_symbolic_link
};


GnomeVFSMethod *
vfs_module_init (const char *method_name, const char *args)
{
#ifdef DEBUG
	mutex = g_mutex_new ();
	g_mutex_lock (mutex);
	stderr = freopen ("/tmp/gnopher-stderr", "w+", stderr);
	g_printerr ("starting...\n");
	g_mutex_unlock (mutex);
#endif
	return &method;
}

void
vfs_module_shutdown (GnomeVFSMethod *method)
{
#ifdef DEBUG
	g_mutex_free (mutex);
#endif
}
