#ifndef gnopher_location_H
#define gnopher_location_H

#include <gtk/gtk.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

/*
 * gnopher_location.h
 */

#define GNOPHER_LOCATION(obj)	GTK_CHECK_CAST(obj, gnopher_location_get_type (), GnopherLocation)
#define GNOPHER_LOCATION_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, gnopher_location_get_type (), GnopherLocationClass)
#define IS_GNOPHER_LOCATION(obj)	GTK_CHECK_TYPE(obj, gnopher_location_get_type())

typedef struct _GnopherLocation GnopherLocation;
typedef struct _GnopherLocationClass GnopherLocationClass;

struct _GnopherLocation {
	GtkObject parent;
	
	/* "traditional" Gopher URL representation */
	gchar filetype;
	gchar * description;
	gchar * selector;
	gchar * server;
	guint port;
	gchar * query;

	/* "modern" URL representation like "gopher://foo.org/bar" */
	gchar * modern_url;
	
	/* raw data */
	gchar * data;
	guint datasize;

	GList * directory;
	/* index in dirlist for the gnomevfs stuff */
	guint wherewasi;
};

struct _GnopherLocationClass {
	GtkObjectClass parent_class;
	void (* changed) (GnopherLocation self);
};

guint gnopher_location_get_type (void);
GtkObject * gnopher_location_new ();
static void gnopher_location_class_init (GnopherLocationClass * class);
static void gnopher_location_init (GnopherLocation * child);

/* This function could be a whole lot nicer if I figure out
   how you can simply set and copy only the relevant stuff.
   This should be either GtkArg based or just a copy function. */
GnomeVFSResult gnopher_location_set_location (GnopherLocation * self,
	const gchar filetype,
	const gchar * description,
	const gchar * selector,
	const gchar * server,
	guint port,
	const gchar * query);
GnomeVFSResult gnopher_location_get_raw_data (GnopherLocation * self, gboolean force_reload);
gboolean gnopher_location_set_raw_data (GnopherLocation * self, gchar * data, guint datasize);
GnomeVFSResult gnopher_location_get_directory (GnopherLocation * self);
void gnopher_location_set_url (GnopherLocation * self, const gchar * url);
void gnopher_location_dump_to_file (GnopherLocation * self, const char * filename);
gboolean gnopher_location_set_directory (GnopherLocation * self, GList * dirlist);

/*
 * End gnopher_location.h
 */

#endif
