#include "STRstrin.h"
#include <stddef.h>
#include <string.h>
#if !defined(NeXT) || !defined(IS_MESS_DOS)
#include <malloc.h>
#endif

#ifdef IS_MESS_DOS
#include "dosmem.h"
#else
#define s_malloc malloc
#define s_free free
#define s_realloc realloc
#endif
/*
 * Make a new string, should reuse destroyed strings....
 */

String *
STRnew()
{
     String *temp;

     temp = (String *) s_malloc(sizeof(String));
     STRinit(temp);


     return(temp);
}

/*
 * Destroy a string
 */

void
STRdestroy(st)
  String *st;
{
     if(st == NULL)
       return;
     if (st->data != NULL)
	  s_free(st->data);

     s_free(st);
     return;
}


/*
 * Clear out all the crud...
 */

void 
STRinit(st) 
  String *st;
{
     if(st != NULL) {
         st->len  = 0;
         st->data = NULL;
     }
     return;
}

/*
 * Set a string value
 */

void
STRset(st, str)
  String *st;
  char   *str;
{
     register int len;

     if (st == NULL || str == NULL)
	  return;

     if (*str == '\0')
	  len = 1;
     else
	  len = strlen(str) + 1;

     /* Uninitialized data... */

     if (st->data == NULL) {
	  st->data = (char *) s_malloc(len);
	  strcpy(st->data, str);
	  st->len = len+1;
     }

     /** Something's already there... **/

     else {
	  if (st->len > len)
	       strcpy(st->data, str);
	  else {
	       char *temp;

	       temp = realloc(st->data, len);
	       if (temp != st->data) {
		    s_free(st->data);
		    st->data = temp;
	       }
	       strcpy(st->data, str);
	  }
     }
     
    return;
}

