/* ourutils.c
 * 
 * Part of the Internet Gopher program, copyright (C) 1991
 * University of Minnesota Microcomputer Workstation and Networks Center
 *
 */

#include "gopher.h"

void Ourpager(char *filename);

#if defined(SYSVCURSES) && !defined(IS_MESS_DOS)
#include <termio.h>
#include <conio.h>

#define       STDOUT  1


/* this is some modified elm source  (Raw) */
static int inraw = 0;

struct termio raw_tty,
	       original_tty;

#define OFF 0
#define ON 1
#define	ttgetattr(fd,where)	ioctl((fd),TCGETA,(where))
#define	ttsetattr(fd,where)	ioctl((fd),TCSETAW,(where))


Raw(state)
int state;
{
     /** state is either ON or OFF, as indicated by call **/
     
     if (state == OFF && inraw) {
          (void) ttsetattr(STDOUT,&original_tty);
          inraw = 0;
     }
     else if (state == ON && ! inraw) {
	  
          (void) ttgetattr(STDOUT, &original_tty);
          (void) ttgetattr(STDOUT, &raw_tty);    /** again! **/
	  
          raw_tty.c_lflag &= ~(ICANON | ECHO); /* noecho raw mode        */
	  
          raw_tty.c_cc[VMIN] = '\01';  /* minimum # of chars to queue    */
          raw_tty.c_cc[VTIME] = '\0';  /* minimum time to wait for input */
	  
          (void) ttsetattr(STDOUT, &raw_tty);
          inraw = 1;
     }
}

#endif /* SYSVCURSES && !IS_MESS_DOS */


outchar(c)
char c;
{
	/** output the given character.  From tputs... **/
        /** Note: this CANNOT be a macro!              **/

        putc(c, stdout);
}


/*
** display_mime() exits curses and displays the file using
** the MIMECommand.
**
*/

void
display_mime(Filename, Realname)
  char *Filename, *Realname;
{

  char metamailcmd[MAXSTR];

  strcpy(metamailcmd, MIMECommand);
  strcat(metamailcmd, " ");
  strcat(metamailcmd, Filename);

  exit_curses();
  system(metamailcmd);
  init_curses();
  return;

}

/*
** This procedure exits out of the curses environment and
** displays the file indicated by pathname to the screen
** using a pager command of some sort 
*/

void
display_file(Filename, Realname)
  char *Filename, *Realname;
{
     FILE *tmpfile, *fNew;
     static char command[MAXSTR];
     static char SaveName[MAXSTR];
     char ch;
     int c;

     strcpy(command, PagerCommand);

     exit_curses();

     /** Execute the PAGER command **/
     strcat(command, " ");
     strcat(command, Filename);

     
     if (strcmp(PagerCommand, "builtin") != 0)
	  system(command);
     else
	  Ourpager(Filename);

     printf("Press <RETURN> to continue");
     if (strlen(MailCommand))
     	printf(", <m> to mail");
     	
     if (!SecureMode)
#ifdef IS_MESS_DOS
	  printf(", <s> to save:");
#else
	  printf(", <s> to save, or <p> to print:");
#endif
     else
	  printf(":");

     fflush(stdout);

     init_curses();
#if defined(SYSVCURSES) && !defined(IS_MESS_DOS)
     /** System V systems don't want to go back into cbreak mode, so we
       force it into cbreak, canonical, etc mode. ***/

     Raw(ON);
#endif

     ch = '\0';
     while (ch == '\0') {
#ifdef IS_MESS_DOS
	  ch=getch();
#else
	  ch=getchar();
#endif
	  if (ch=='m' && strlen(MailCommand)) {
	       
	       sprintf(command, "Mail document to: ");
	       GetOneOption(command, SaveName);

	       Draw_Status("Mailing File...");
	       refresh();

	       if (strlen(SaveName) == 0)
		    break;
	       
	       sprintf(command, "%s -s \"%s\" %s < %s", MailCommand, Realname, SaveName, Filename);
	       system(command);
	       ch = '\n';
	  }


	  if (SecureMode) {
	       switch (ch) {
	       case '\n':
	       case '\r':
	       case ' ':
		    break;

	       default:
		    printf("%s",sGAudibleBell);
		    fflush(stdout);
		    ch='\0';
		    break;
	       }
	  }
	  else {

	       switch(ch) {
	       case '\n':
	       case '\r':
	       case ' ' :
		    break;
	       case 's':
		    Draw_Status("Saving File...");
		    refresh();

		    sprintf(command, "Enter save file name: ");
                    bzero(SaveName, MAXSTR);
		    GetOneOption(command, SaveName);
		    if (strlen(SaveName) == 0)
			 break;
		    while ((fNew = fopen(SaveName, "wt")) == NULL) {
			 sprintf(command, "Error opening %s:  Enter new name or <Enter> to cancel: ", SaveName);
			 bzero(SaveName, MAXSTR);
			 GetOneOption(command, SaveName);
			 if (SaveName[0] == 0)
			      break;
		    }
              
		    if (fNew == NULL)
			 break;
		    
		    if ((tmpfile = fopen(Filename, "rt")) == NULL) {
			 fprintf(stderr, "%s cannot be opened.\n", Filename), exit(-1);
			 fclose(fNew);
	                 bzero(SaveName, MAXSTR);
			 break;
		    }

		    while ((c=getc(tmpfile)) != EOF) {
			 putc(c, fNew);
		    }
		    
		    fclose(tmpfile);
		    fclose(fNew);
		    bzero(SaveName, MAXSTR);
		    
		    break;
	       default:
		    printf("%s",sGAudibleBell);
		    fflush(stdout);
		    ch='\0';
		    break;
	       }
	  }
     }

#ifndef IS_MESS_DOS
     tputs(sGClearscreen,1,outchar);
#endif

     fflush(stdout);

#if defined(SYSVCURSES) && !defined(IS_MESS_DOS)
     raw(OFF);
#endif
}

#ifdef IS_MESS_DOS
void
view_file(Filename, Realname)
    char *Filename, *Realname;
{
     FILE *tmpfile, *fNew;
     static char command[MAXSTR];
     static char SaveName[MAXSTR];
     char ch;
     int c;

     sprintf(command, "%s %s", GifCommand, Filename);

     exit_curses();
     system(command);

     printf("\nPress <RETURN> to continue");


     if (!SecureMode)
	  printf(", <s> to save:");
     else
	  printf(":");

     fflush(stdout);

     init_curses();
     ch = '\0';
     while (ch == '\0') {
	  ch=getchar();
	  if (SecureMode) {
	       switch (ch) {
	       case '\n':
	       case '\r':
	       case ' ':
		    break;

	       default:
		    printf("%s",sGAudibleBell);
		    fflush(stdout);
		    ch='\0';
		    break;
	       }
	  }
	  else {

	       switch(ch) {
	       case '\n':
	       case '\r':
	       case ' ' :
		    break;
	       case 's':
		    Draw_Status("Saving File...");
		    refresh();

		    sprintf(command, "Enter save file name: ");
                    bzero(SaveName, MAXSTR);
		    GetOneOption(command, SaveName);
		    if (strlen(SaveName) == 0)
			 break;
		    while ((fNew = fopen(SaveName, "wb")) == NULL) {
			 sprintf(command, "Error opening %s:  Enter new name or <Enter> to cancel: ", SaveName);
			 bzero(SaveName, MAXSTR);
			 GetOneOption(command, SaveName);
			 if (SaveName[0] == 0)
			      break;
		    }
              
		    if (fNew == NULL)
			 break;
		    
		    if ((tmpfile = fopen(Filename, "rb")) == NULL) {
			 fprintf(stderr, "%s cannot be opened.\n", Filename), exit(-1);
			 fclose(fNew);
			 break;
		    }

		    while ((c=getc(tmpfile)) != EOF) {
			 putc(c, fNew);
		    }
		    
		    fclose(tmpfile);
		    fclose(fNew);
		    
		    break;
	       default:
		    printf("%s",sGAudibleBell);
		    fflush(stdout);
		    ch='\0';
		    break;
	       }
	  }
     }

     fflush(stdout);
}

#endif /* IS_MESS_DOS */
/*
** This mini pager is intended for people worried about shell escapes from
** more or less or whatever
*/

void
Ourpager(filename)
  char *filename;
{
     FILE *InFile;
     int i;
     char inputline[512], *cp;
     int Done = FALSE;
     char ZeTypedChar;

     if ((InFile = fopen(filename, "r")) == NULL)
	  return;

     gotoxy(0,0);

#ifndef IS_MESS_DOS
/* exit_curses cleared the screen for us, now Go to x=0, y=0.
   No, of course it's not very portable. */
	  __asm {
		mov ah, 2
		mov bh, 0
		mov dx, 0
		int 10h
	}
#endif

     while (Done == FALSE) {
#ifndef IS_MESS_DOS
	  tputs(sGClearscreen,1,outchar);
#endif /* MESS_DOS */
	  for (i=0 ; i < LINES-1; i++) {
	       cp = fgets(inputline, COLS, InFile);
	       ZapCRLF(inputline);
	       puts(inputline);
	  }

	  printf("----Press <ENTER> for next page, q to exit------");
	  
#if defined(SYSVCURSES) && !defined(IS_MESS_DOS)
	  Raw(ON);
	  ZeTypedChar = getchar();
#else
         ZeTypedChar = getche();
#endif
	  
	  if ((ZeTypedChar == 'q') || (cp == NULL)) {
	       Done = TRUE;
	  }
	       printf("\n");
      }

#if defined(SYSVCURSES) && !defined(IS_MESS_DOS)
     Raw(OFF);
#endif

     fclose(InFile);
}
/*
** Non System V getstr's all seem to be broken in some way.  Anyways
** a normal getstr wouldn't do for us.  This one displays a current value
** That the user can edit.
**
** Also, if a non-printable character is pressed we stop and return it.
** (tab, esc etc. )
*/

char
Mygetstr(inputline)
  char *inputline;
{
     int pointer = 0;
     char ch;

     cbreak();
     noecho();     

     /*** Check to see if there's something in the inputline already ***/
     
     while (inputline[pointer] != '\0') {
	  addch(inputline[pointer]);
	  pointer ++;
     }
     refresh();
	  

     for (;;) {
	  ch = getch();

	  switch (ch) {

#ifdef IS_A_RS6000
          case '\227':
#endif
	  case '\n':
	  case '\r':
	  case '\t':
	       inputline[pointer] = '\0';
	       return;
	       break;

	  /**  Backspace and delete **/

	  case '\010':
	  case '\177':
	       if (pointer > 0) {
		    addch('\010');
		    addch(' ');
		    addch('\010');
	       
		    inputline[--pointer] = '\0';
		    refresh();
	       }
	       break;
		    
	  case '\007': /* ^G */
	  case '\033': /* ESC */
	       inputline[0] = '\0';
	       return;
	       break;
	       
	  default:
	       if (!iscntrl(ch)) {
		    inputline[pointer++]= ch;
		    addch(ch);
		    refresh();
	       }
	       else
		    return(ch);
	  }
     }

}

/*
** This routine will allow the user to change a whole bunch of fields.
** 
** The maximum number of options is hard set at 9 right now.  It may be
** different in the future.
**
** The space for storing stuff is provided by the caller.  This routine
** will present it to the user in this fashion:
**
**           Option1 : responses1
**           Option2 : responses2
**           .....
**
** It would be wise to keep the length of the options and responses
** below 38 characters.
**
*/


Get_Options(Title, Err, numOptions, Options, Responses)
  char *Title;
  char Err[MAXSTR];
  int    numOptions;
  char **Options;
  char Responses[MAXRESP][MAXSTR];
{
     int         availlines;
     static char printstring[WHOLELINE];
     static char inputline[WHOLELINE];
     int         optionlen;
     int         maxoptionlen;
     int         i,j;          /** Acme Buggy whips and integers **/
     BOOLEAN     Done = FALSE;
     char        ch, fooch;

     while (Done == FALSE) {

	  clear();
	  Draw_Banner();
	  Draw_Status("Press <RETURN> to exit");
	  Centerline( Title, 3);
	  Centerline( Err, 4);
	  
	  availlines = LINES - 6;
	  
	  /** Find the longest width of the options strings **/
	  
	  maxoptionlen = 0;
	  
	  for (i=0; i<numOptions; i++) {
	       j= strlen(Options[i]);
	       maxoptionlen = (maxoptionlen > j) ? maxoptionlen:j;
	  }
	  
	  
	  /*** Print out the options in a nice looking fashion ***/
	  
	  for (i=0; i<numOptions; i++) {
	       optionlen = strlen(Options[i]);
	       mvaddch(i+5, 2, ('0' + 1 + i));
	       addstr(". ");
	       addstr(Options[i]);
	       mvaddstr(i+5, maxoptionlen + 6, ": ");
	       addstr(Responses[i]);
	  }

	  sprintf(printstring, "Press 1-%d to change a field, Return to accept fields and continue", numOptions);

	  Centerline(printstring, LINES-3);

	  refresh();

	  /*** Now get some user input ***/

	  ch = getch();

	  
#ifdef STUPIDTERM
	  /*** Suck off a return ***/
	  if (ch != '\n' && ch != '\r')
	       
	       do {
		    fooch = getch();
	       }
               while (fooch != '\n' && fooch != '\r');

#endif

	  if (ch == '\n' || ch == '\r' || ch == 'Q' || ch=='q')
	       Done = TRUE;

	  else if (isdigit(ch)) {
	       i = ch - '1' ;
               if(-1 < i && i < numOptions) {
	            Draw_Status("Press Return when finished");
	            move( i +5, maxoptionlen +8);
	            clrtoeol();
	            refresh();

	            echo();
                    curson();
	            inputline[0] = '\0';
	            Mygetstr(Responses[i]);
                    cursoff();
	            noecho();
               } else
                    printf("%s", sGAudibleBell);
	  }
	  else
	       addstr(sGAudibleBell);
     }
}

/*
 * This allows the user to add or change data in a form.
 *
 * It returns true if the user wants to keep the changes
 * It returns false if the user wants to abort
 *
 */

BOOLEAN
NewForm(ZeForm)
  Form *ZeForm;
{
     int         availlines;
     static char printstring[WHOLELINE];
     int         optionlen;
     int         maxoptionlen;
     int         i,j;          /** Acme Buggy whips and integers **/
     char        ch;

     while (1) {

	  DisplayForm(ZeForm);

	  sprintf(printstring, "Press <ESC> to accept fields and continue");

	  Centerline("Press <ESC> to accept fields and continue", LINES-3);
	  Centerline("or press <CTRL-A> to abort", LINES-2);

	  refresh();

	  /*** Now get some user input ***/

	  for (i=0; i< ZeForm->numfields; i++) {

	       move(ZeForm->yloc[i],ZeForm->xloc[i] + strlen(ZeForm->tags[i])+2);
	       refresh();
	       echo();

	       ch = Mygetstr(ZeForm->values[i]);

	       /*** ESC key ***/
	       if (ch == '\033') {
		    noecho();
		    return(TRUE);
	       }

	       /*** CTRL-A ***/
	       else if (ch == '\001') {
		    noecho();
		    return(FALSE);
	       }

	       noecho();
	  }
	  
     }

}




/*
 * This Displays a form and a "menu".  It displays the Form
 * and then it waits for a keypress.  It returns the value of the
 * key that is pressed.
 */

void
DisplayForm(ZeForm)
  Form *ZeForm;
{
     int         availlines;
     static char printstring[WHOLELINE];
     int         optionlen;
     int         maxoptionlen;
     int         i,j;          /** Acme Buggy whips and integers **/
     BOOLEAN     Done = FALSE;
     char        ch;


     clear();
     Draw_Banner();
     Centerline( ZeForm->Title, 2);
     
     availlines = LINES - 6;
     
     /*** Print out the options according to the Form structure ***/
     
     for (i=0; i<ZeForm->numfields; i++) {
	  optionlen = strlen((ZeForm->tags)[i]);
	  mvaddstr(ZeForm->yloc[i],ZeForm->xloc[i], 
		   ZeForm->tags[i]);
	  addch(':');
	  addch(' ');
	  
	  /*** Now add the current value ***/
	  addstr((ZeForm->values)[i]);
     }
     
}





void
CursesErrorMsg(Message)
  char *Message;
{
     char ch;
     int i;

     move(LINES-1, 0);
     /*** addstr(Message) doesn't seem to work.... ***/

     for (i=0; (i<60&&Message[i]!='\0'&&Message[i] !='\r' && Message[i]!='\n'); i++)
	  addch(Message[i]);

     refresh();

     addstr(" <press RETURN> ");
     clrtoeol();
     refresh();
     ch = getch();
     while (ch != '\r' && ch != '\n')
	  ch = getch();
}
     


void
GetOneOption(OptionName, Response)
  char *OptionName, *Response;
{
     mvaddstr(LINES-1, 0, OptionName);
     clrtoeol();
     refresh();
     echo();
     Mygetstr(Response);
     noecho();
}


/*
 ** This strips off  CR's and LF's leaving us with a nice pure string.
 */

void
ZapCRLF(inputline)
char *inputline;
{
     char *cp;
     
     cp = index(inputline, '\r');    /* Zap CR-LF */
     if (cp != NULL)
          *cp = '\0';
     else {
          cp = index(inputline, '\n');
          if (cp != NULL)
               *cp = '\0';
     }
}


int
OpenGopherConn(ZeGopher)
  GopherStruct *ZeGopher;
{
     int sockfd;
     static char inputline[MAXLINE];
     int length;

     inputline[0] = '\0';

     if ((sockfd = connect_to_gopher(GSgetHost(ZeGopher), GSgetPort(ZeGopher))) <0) {
	  check_sock(sockfd, GSgetHost(ZeGopher));
	  return(-1);
     }


     /*** Get rid of that darn Banner line ***
     length = readline(sockfd, inputline, MAXLINE); */

     return(sockfd);
     /*** TODO check to see if the server version is cool. ***/

}

/*
 * String insensitive strstr
 */

char *
strcasestr(inputline, match)
  char *inputline;
  char *match;
{
     int matchlen=0;
     int i, inlen;

     matchlen = strlen(match);
     inlen = strlen(inputline);

     for(i=0; i<inlen; i++) {
	  if (strncasecmp(inputline+i, match, matchlen)==0)
	       return(inputline+i);
     }

     return(NULL);
}

