/* manager.c
 *
 * Part of the Internet Gopher program, copyright (C) 1991
 * University of Minnesota Microcomputer Workstation and Networks Center
 */

#include "gopher.h"
extern size_t memInUse;

#define MENULINE(x)   (x)+3

/* If any gophers to display (screen can be blank), count the number
   of pages.  If there is a remainder greater than zero, add one page */
#define PAGECALC(x,y) (y) ? (x/y) + ((x%y)>0) : 1

#define MIN(x,y)      ((x) <= (y) ? (x) : (y))



/*
**  Initialize the curses stuff
*/


void
init_curses()
{
     initscr();
     cbreak();
     noecho();
     nonl();
#ifdef IS_MESS_DOS
     cursoff();
#endif
#ifdef SYSVCURSES
#ifndef IS_MESS_DOS
     intrflush(stdscr, FALSE);
#endif
#ifndef IS_A_DEC    /** Screws up keyboard input under Ultrix 4.0 */
#ifndef IS_A_RS6000 /** and under AIX **/
     keypad(stdscr, TRUE);
#endif
#endif
#endif

}


/*
** Exit curses system.
*/

void
exit_curses()
{
#ifdef IS_MESS_DOS
     curson();
#endif

#ifdef SYSVCURSES
     reset_shell_mode();
#endif
#ifndef IS_MESS_DOS
     tputs(sGClearscreen,1,outchar);     
#else
     clear();
     refresh();
#endif
     endwin();
     fflush(stdout);
}

/*
** Centerline, uses curses routines to center a line.
*/

void Centerline(theline, yval)
  char *theline;
  int yval;
{
     mvaddstr(yval, (COLS - strlen(theline))/2, theline);
}


/*
** Draw the title on the top
*/

Draw_Banner()
{
     standout();
     Centerline(VERSIONline, 0);
     Centerline(OACVERSION, 1);
     standend();
}     


/*
** Draw the status line
*/

Draw_Status(textline)
  char *textline;
{
     move(LINES-1, 0);
     clrtoeol();
     mvaddstr(LINES-1, 0, "Press ");
     standout();
     addstr("?");
     standend();

     addstr(" for Help, ");

     standout();
     addstr("q");
     standend();
     addstr(" to Quit, ");
     
     standout();
     addstr("u");
     standend();
     addstr(" to go up");
     clrtoeol();
     mvaddstr(LINES-1, COLS-strlen(textline)-1,textline);
}



/*
** Man is this ugly.
*/

NEAR Display_Dir_Page(gopherdir, iNewLine, nNewPage, nMaxPages, iPageLen, iLastPageLen)
  GopherDirObj *gopherdir;
  int nNewPage, nMaxPages, iPageLen, iLastPageLen;
{
     int i, iLoop, iOffset;

     /*** Clear the screen and redraw the top line **/
     clear();
     Draw_Banner();

     /** Draw the menu **/
     iLoop = (nNewPage == nMaxPages) && iLastPageLen ? iLastPageLen : iPageLen;

     for (i= 0, iOffset = (nNewPage-1) * iPageLen; i <iLoop; i++, iOffset++) {
	  move(MENULINE(i+1), 6);
	  printw("%d.", iOffset +1);
	  if (iOffset + 1 < 10)
	       addch(' ');

     {
	  char *c = GSgetTitle(GDgetEntry(gopherdir,iOffset));


	  if (strlen(c) > COLS-14)
	       c[COLS-15] = '\0';    /*** Gack, strip off extra cruft **/

          printw(" %s", c);

     }
	  switch(GSgetType(GDgetEntry(gopherdir,iOffset)))
	     {
	     case A_DIRECTORY:
	       addch('/');
	       break;
             case A_CSO:
	       addch(' '); addch('<'); addch('C'); addch('S'); 
	       addch('O'); addch('>');
	       break;
	     case A_TELNET:
	     case A_TN3270:
	       addch(' '); addch('<'); addch('T'); addch('E');
	       addch('L'); addch('>');
	       break;
	     case A_INDEX:
	       addch(' '); addch('<'); addch('?'); addch('>');
	       break;
             case A_SOUND:
	       addch(' '); 
	       addch('<');
	       addch(')');  /** It's supposed to look like a speaker! **/
	       break;
	     case A_FILE:
	       addch('.');
	       break;
  	     case A_TARORZ:
	       addch(' '); addch('<'); addch('B'); addch('i'); 
	       addch('n'); addch('>');
	       break;
  	     case A_MACHEX:
	       addch(' '); addch('<'); addch('H'); addch('Q'); 
	       addch('X'); addch('>');
	       break;
   	     case A_PCHEX:
	       addch(' '); addch('<'); addch('P'); addch('C'); addch(' ');
	       addch('B'); addch('i'); addch('n'); addch('>');
	       break;
	     case A_EVENT:
	       addch('#');
	       break;
	     case A_IMAGE:
/*
	       addch(' '); addch('<'); addch('P'); addch('i'); addch('c');
	       addch('t'); addch('u'); addch('r'); addch('e'); addch('>');
*/
	       addstr(" <Picture>");
	       break;
#ifdef IS_MESS_DOS
             case A_GIF:
               addch(' '); addch('<'); addch('G'); addch('I'); 
               addch('F'); addch('>');
               break;
#endif
             }
     }
}


/* scline - Screen line relocator.
 *          Returns the line resulting from choice */
int 
scline(iMaxGophers, iOldGopher, iNewGopher, gophersdir, MenuTitle)
  int iMaxGophers;    /* Total number of gophers on all pages */
  int iOldGopher;     /* Which gopher previously displayed */
  int iNewGopher;     /* New gopher to be displayed */
  GopherDirObj  *gophersdir;
  char *MenuTitle;
{
     int iPageLen, iLastPageLen;        /* Length of normal, final pages */
     int nMaxPages, nNewPage, nOldPage; /* Natural numbers */
     int iOldLine, iNewLine;            /* Screen locations */
     char sPagenum[40];
     
/*
     if ((iNewGopher < 0) || (iNewGopher > iMaxGophers))
	  return(iOldGopher);
*/
     if (iNewGopher == 0)
	iNewGopher = iMaxGophers;

     if (iNewGopher > iMaxGophers)
	iNewGopher = 1;
     
     iPageLen = LINES-6;    /* Number of menu lines possible per page */
     
     nMaxPages = PAGECALC(iMaxGophers, iPageLen);    /* Total number of pages */
     nOldPage =  PAGECALC(iOldGopher, iPageLen); 
     nNewPage =  PAGECALC(iNewGopher, iPageLen);
     
     if ((nNewPage < 1) || (nNewPage > nMaxPages))   /* It won't work , make*/
	  return(iOldGopher);                          /* no changes */
     
    iLastPageLen = iMaxGophers % iPageLen;

    /* Lines on last page */

     iOldLine = iOldGopher - ((nOldPage-1)*iPageLen);/* Old Screen location */
     iNewLine = iNewGopher - ((nNewPage-1)*iPageLen);/* New Screen location */
     
     if ((iNewLine < 0) || (iNewLine > iPageLen))
	  return(iOldGopher);
     
     if (nOldPage != nNewPage)    {
	Display_Dir_Page(gophersdir,
                        iNewLine, nNewPage, nMaxPages, iPageLen, iLastPageLen);
	Centerline(MenuTitle, 2);       /*** Draw the title ***/
   }
	
     if(debugStatus)
          sprintf(sPagenum, "Mem Used %lu, Stack: %d, Page: %d/%d",
                  memInUse, iLevel, nNewPage, nMaxPages);
     else
          sprintf(sPagenum, "  Page: %d/%d", nNewPage, nMaxPages);
     Draw_Status(sPagenum);
     mvaddstr(MENULINE(iOldLine), 1, "   ");
     mvaddstr(MENULINE(iNewLine), 1, "-->");
     refresh();

     return(iNewGopher);
}

/*
** This routine draws a numbered menu
** from a gopherdirobj
** 
** It returns the number that the user selected, or it returns
** zero if the user decided to cancel.
**
*/


int GetMenu(numitems, itemsdir, MenuTitle, typedchar, incomingLine, redisplay)
  int numitems;
  GopherDirObj *itemsdir;
/*  GopherStruct *items[];*/
  char *MenuTitle;
  char *typedchar;
  int incomingLine;
  BOOLEAN redisplay;
{
     int ch;              /* Input character */
     int iItem; /* Display line */
     static int iNewItem=1;
     char sLinenum[5];    /* Used when going to a specific line */
     BOOLEAN menudone = FALSE;
     char search1[100] = "", *search2;
     int i, sfound;

#define VTKEYS
#ifdef VTKEYS
     int escstat =0;  /* 0: normal, 1: last was ESC, 2: ESC[ or ESC O*/
#endif

     iItem = -1;
     iNewItem = incomingLine;

     if(redisplay == TRUE) {
        iItem = scline(numitems, iItem, iNewItem, itemsdir, MenuTitle);
        Centerline(MenuTitle, 2);       /*** Draw the title ***/
        move(3+iNewItem,6);

     /* Move to the last line that we were sitting on */

        refresh();
     } else
       iItem = incomingLine;


     while (menudone == FALSE) {
	  ch = getch();

#ifdef VTKEYS
	  /* handle ESC [ A or ESC 0 A variants of cursor keys.
	   * This sort of nonsense is the real reason for using
	   * SysV curses if at all possible.
	   */

	  switch (escstat) {
	  case 1:
	       escstat = (ch == '[' || ch == 'O') ?2:0;
	       break;
	  case 2:
	       switch (ch){
               case 'A':       ch = 'k'; break;        /*UP*/
               case 'B':       ch = 'j'; break;        /*DOWN*/
               case 'C':       ch = '\n'; break;       /*READ*/
               case 'D':       ch = 'u'; break;        /*UP*/
               default:        ch = ' '; break;        /* harmless */
               }
               escstat = 0;    /* ch contains equivalent char */
               break;
	  }
	  if (escstat !=0)
	       continue;

#endif
	  switch(ch)
	  {
	  case '\033':
	       escstat=1;
	       break;

#ifndef STUPIDTERM   /** Stupid terminals can't do cursor keys **/
	  case 'J':
	  case 'j':
	  case '\016':
#ifdef SYSVCURSES
	  case KEY_DOWN:
#endif /* SYSVCURSES */

	       iNewItem = iItem + 1; /* Advance down the page */
	       break;
	       
	  case 'K':
	  case 'k':
	  case '\020':   /*** For those emacs dudes **/
#ifdef SYSVCURSES
	  case KEY_UP:
#endif /* SYSVCURSES */

	       iNewItem = iItem - 1; /* Back up */
 	       break;


	  case '>':
#ifdef SYSVCURSES
	  case KEY_NPAGE:
#endif
	       /*** Go down a page ***/
	       iNewItem = iItem + (LINES -6);
		    if (iNewItem > numitems)
			 iNewItem = numitems;
	       break;


	  case '<':
          case 'b':  /* Intuitive */
#ifdef SYSVCURSES
	  case KEY_PPAGE:
#endif
	       /*** Go up a page ***/

	       iNewItem = iItem - (LINES - 6);
	       if ( iNewItem < 0 )
		    iNewItem = 1;
               break;


#endif /* STUPIDTERM */	       
	       
	  case '1': case '2': case '3': case '4': case '5':
	  case '6': case '7': case '8': case '9': case '0':
	       
	       sLinenum[0] = ch;
	       sLinenum[1] = '\0';
	       
	       GetOneOption("Move To Line: ", sLinenum);
	       
	       if (atoi(sLinenum) > 0 && atoi(sLinenum) <= numitems)
		    iNewItem = atoi(sLinenum); /* Jump */
	       
	       break;

	  case '/': case 'n':
	       sfound = 0;

	       if (search1[0] == '\0' || ch == '/')
		GetOneOption("Search String: ", search1);
	       if(strlen(search1) == 0)
		break;

	       /* Start searching from next item */
	       for (i = iItem; i < numitems && sfound == 0; i++) {
		search2 = GSgetTitle(GDgetEntry(itemsdir, i));
		if (strcasestr(search2, search1) != NULL) {
			iNewItem = i+1;
			sfound = 1;
		}
	       }
	       /* If we didn't find it after the current line
	          start at the beginning again.
               */
	       for (i=0; i < iItem && sfound == 0; i++) {
		search2 = GSgetTitle(GDgetEntry(itemsdir, i));
		if (strcasestr(search2, search1) != NULL) {
			iNewItem = i+1;
			sfound = 1;
		}	
	       }
	       if (sfound == 0) {
		printf("%s", sGAudibleBell);
		CursesErrorMsg("Search failed...");
	       }
	       break;

	  case '\0':
	       break;

	  default:
               if (ch == 'h')  /* for hjkl pattern */
                   ch = 'u';
               if (ch == 'l')
                   ch = '\r';
	       menudone = TRUE;
	       *typedchar = ch;
	  }

	  iItem = scline(numitems, iItem, iNewItem, itemsdir, MenuTitle);
     
	  refresh();
     
     }
#ifdef SYSVCURSES
     if (ch == KEY_LEFT)  ch = 'u';
     if (ch == KEY_RIGHT) ch = '\n';
#endif

     *typedchar = ch;

#ifdef STUPIDTERM  /*** ANET users have to press return to send a command **/
     if (ch != '\r' && ch != '\n' && ch != '\227')
	  while (ch = getch()) {
	       if (ch != '\r' || ch != '\n' || ch != '\227')
		    break;
	  }
     
#endif /** STUPIDTERM **/

     return(iItem);
}


