/*
 * This is a crude attempt at doing some object-based programming in C
 */
#include <string.h>
#include <stdio.h>

#include "conf.h"
#include "gopherst.h"
#if !defined(NeXT) || !defined(IS_MESS_DOS)
#include <malloc.h>
#endif

#ifdef IS_MESS_DOS
#include "dosmem.h"
#else
#define s_malloc malloc
#define s_free free
#define s_realloc realloc
#endif

extern int DEBUG;


/*
 * Make a new gopherstruct...  Should reuse destroyed GopherObjs...
 */

GopherObj *
GSnew()
{
     GopherObj *temp;

     temp = (GopherObj *) s_malloc(sizeof(GopherObj));
     
     temp->Selstr = STRnew();
     temp->Title  = STRnew();
     temp->Host   = STRnew();

     GSinit(temp);

     return(temp);
}

void
GSdestroy(gs)
  GopherObj *gs;
{
     if(gs != NULL) {
         STRdestroy(gs->Selstr);
         STRdestroy(gs->Title);
         STRdestroy(gs->Host);

         s_free(gs);
     }
     return;
}
     


/*
 * Clear out all the crud 
 */

void
NEAR GSinit(gs)
  GopherObj *gs;
{
     if(gs != NULL) {
         GSsetType(gs, '\0');
     
         STRinit(gs->Title);
         STRinit(gs->Selstr);
         STRinit(gs->Host);

         gs->iPort = 0;
         gs->iItemnum = 0;
    }
    return;
}


void
NEAR GStoNet(gs, sockfd)
  GopherObj *gs;
  int sockfd;
{
     static char buf[1024];

     if(gs == NULL)
	return;
     buf[0] = GSgetType(gs);

     sprintf(buf + 1, "%s\t%s\t%s\t%d\r\n",
	     GSgetTitle(gs),
	     GSgetPath(gs),
	     GSgetHost(gs),
	     GSgetPort(gs));

     writestring(sockfd, buf);
     
     if (DEBUG)
	  fprintf(stderr, buf);

}

extern int readfield();
extern int readline();

/*
 * GSfromLink takes an open file descriptor and starts reading from it.
 * It keeps going until it findsL
 *    enough fields for a gopherobj
 *    no data left
 * 
 * returns 0 with success, -1 on an error.
 */

#define	G_PATH	(1<<0)
#define	G_TYPE  (1<<1)
#define	G_NAME	(1<<2)
#define	G_PORT	(1<<3)
#define	G_HOST	(1<<4)
#define	G_ALL (G_PATH | G_TYPE | G_NAME | G_PORT | G_HOST)

int
NEAR GSfromLink(gs, fd, host, port)
  GopherObj *gs;
  FILE      *fd;
  char      *host;
  int       port;
{
     int doneflags = 0;
     char buf[1024];

     while ((doneflags != G_ALL) && fgets(buf, 1024, fd)) {
	  if (buf[0] == '#')
	       continue;   /* comment */

	  ZapCRLF(buf);

	  if (strncmp(buf, "Type=", 5)==0) {
	       GSsetType(gs, buf[5]);
	       doneflags |= G_TYPE;
	  }
	  
	  if (strncmp(buf, "Name=", 5)==0) {
	       GSsetTitle(gs, buf+5);
	       doneflags |= G_NAME;
	  }
 	  
	  if (strncmp(buf, "Path=", 5)==0) {
	       GSsetPath(gs, buf+5);
	       doneflags |= G_PATH;
	  }
 	  
	  if (strncmp(buf, "Host=", 5)==0) {
	       if (buf[5] == '+' && buf[6] == '\0')
		    GSsetHost(gs, host);
	       else
		    GSsetHost(gs, buf+5);

	       doneflags |= G_HOST;
	  }
	  if (strncmp(buf, "Port=", 5)==0) {
	       if (buf[5] == '+' && buf[6] == '\0')
		    GSsetPort(gs, port);
	       else
		    GSsetPort(gs, atoi(buf+5));

	       doneflags |= G_PORT;
	  }
	  if (strncmp(buf, "Numb=", 5)==0)
	       GSsetNum(gs, atoi(buf+5));
	  
     }
     return ((doneflags == G_ALL) ? 0 : -1); /* 0 == success */
}

void
NEAR GStoLink(gs, fd)
  GopherObj *gs;
  FILE *fd;
{
     char gtype[2];
     char portnum[16];
     
     gtype[0] = GSgetType(gs);
     gtype[1] = '\0';

     fputs("#", fd);
     fputs("\nType=", fd);
     fputs(gtype, fd);
     fputs("\nName=", fd);
     fputs(GSgetTitle(gs), fd);
     fputs("\nPath=", fd);
     fputs(GSgetPath(gs), fd);
     fputs("\nHost=", fd);
     fputs(GSgetHost(gs), fd);
     fputs("\nPort=", fd);
     sprintf(portnum, "%d", GSgetPort(gs));
     fputs(portnum, fd);
     fputs("\n", fd);
}

int
NEAR GSfromNet(gs, sockfd)
  GopherObj *gs;
  int sockfd;
{
     char *cPtr = NULL;
     char foo[1024];

     if(gs == NULL)
	return(1);     

     if (readfield(sockfd, foo, 1024)<= 0) {
	  /* EOF or error */
	  return(1);
     }

     GSsetType(gs, foo[0]);

     /** Get the kind of file from the first character **/
     /** Filter out files that we can't deal with **/

     switch (GSgetType(gs)) {
       case A_FILE:
       case A_DIRECTORY:
       case A_MACHEX:
       case A_PCHEX:
       case A_CSO:
       case A_INDEX:
       case A_TELNET:
       case A_TN3270:
       case A_SOUND:
       case A_TARORZ:
/*     case A_EVENT:
       case A_CALENDAR:   not ready for prime time yet */
       case A_IMAGE:
       case A_MIME:
#ifdef IS_MESS_DOS
       case A_GIF:
#endif
	  break;
       case A_EOI:
	  return(1);
     default:
	return(-1);  
     }

     /** Suck off the User Displayable name **/
     GSsetTitle(gs, foo+1);
     
     /** Suck off the Pathname **/
     if (readfield(sockfd, foo, 1024) == 0)
	  return(-1);
     GSsetPath(gs, foo);

     /** Suck off the hostname **/
     if (readfield(sockfd, foo, 1024) == 0)
	  return(-1);
     GSsetHost(gs, foo);

     if (readline(sockfd, foo, 1024)==0)
	  return(-1); 

     GSsetPort(gs, 0);

     /** Get the port number **/
     GSsetPort(gs, atoi(foo));

     return(0);
}

/** Copy a GopherObj ***/

void
GScpy(dest, orig)
  GopherObj *dest, *orig;
{
     if(dest == NULL || orig == NULL)
	return;

     dest->sFileType = orig->sFileType;
     dest->iPort     = orig->iPort;
     dest->iItemnum  = orig->iItemnum;

     GSsetTitle(dest, GSgetTitle(orig));
     GSsetPath(dest, GSgetPath(orig));
     GSsetHost(dest, GSgetHost(orig));
}



/***********************************************************************
** Stuff for GopherDirObjs
**
***********************************************************************/


GopherDirObj*
GDnew(size)
  int size;
{
     int i;
     GopherDirObj *temp;

     temp = (GopherDirObj*) s_malloc(sizeof(GopherDirObj));
     temp->Gophers = (GopherObj **) s_malloc(size * sizeof(GopherObj*));
    
     for (i = 0; i < size; i++)
	  temp->Gophers[i] = GSnew();

     temp->maxsize = size;

     GDinit(temp);
     return(temp);
}


void
GDdestroy(gd)
  GopherDirObj *gd;
{
     int i;

     if(gd != NULL) {     
/*         for (i = 0; i < gd->Top; i++) */
         for (i = 0; i < gd->maxsize; i++)
    	      GSdestroy(gd->Gophers[i]);

         s_free(gd->Gophers);
         s_free(gd);
     }
}


void
NEAR GDinit(gd)
  GopherDirObj *gd;
{
     int i;

     if(gd != NULL) {
         for (i=0; i<gd->maxsize; i++) {
	      GSinit(GDgetEntry(gd, i));
         }

         GDsetTop(gd, 0);
     }
     return;
}


/*
 * Increase the size of the GopherObj pointer array to "size"
 */

void
NEAR GDgrow(gd, size)
  GopherDirObj *gd;
  int size;
{
     GopherObj **temp;
     int i;

     if(gd == NULL)
        return;
     if (size < gd->maxsize)
	  return; /** Size is smaller than requested **/

     temp = (GopherObj **) s_realloc(gd->Gophers, size*sizeof(GopherObj*));
 
     if (temp == NULL)
	  fprintf(stderr, "Out of memory!!!\n"), exit(-1);

     if (temp != gd->Gophers) {
	  s_free(gd->Gophers);
	  gd->Gophers = temp;
     }

     /** Initialize the new GopherObjs.  **/

     for (i= gd->maxsize; i< size; i++)
	  gd->Gophers[i] = GSnew();
     
     gd->maxsize = size;
     return;
}


extern int DEBUG;

/** This proc adds a GopherObj to a gopherdir. **/
void
GDaddGS(gd, gs)
  GopherDirObj *gd;
  GopherObj *gs;
{
	int n, i;

        if(gd == NULL || gs == NULL)
	    return;
	if (GDgetTop(gd) == gd->maxsize)
		  GDgrow(gd, gd->maxsize*2);

	if (DEBUG)
		fprintf(stderr, "Adding %s, Top=%d, Num=%d\n",
			GSgetTitle(gs), GDgetTop(gd), GSgetNum(gs));

	if ((n = GSgetNum(gs)) == 0)	/* if we don't care where it goes */
		n=1;			/* put it in the first available slot */

	if (GSgetType(GDgetEntry(gd, n-1)) != '\0') {	/* that slot is in use*/
		for (i=1; ; i++)		/* find any empty slot */
			if (GSgetType(GDgetEntry(gd, i-1)) == '\0')
				break;		/* got one */
		if (i >= GDgetTop(gd))	/* item was past end of list */
			GDsetTop(gd, i);	/* update end of list */
		if (GSgetNum(gs) != 0) {	/* if we want that slot */
			/* kick out the entry that's in our way */
			GScpy(GDgetEntry(gd, i-1), GDgetEntry(gd, n-1));
		} else {
			n = i;	/* don't be a bully */
		}
	}

	GScpy(GDgetEntry(gd, n-1), gs);		/* put our entry in place */
	if (n >= GDgetTop(gd))			/* item was past end of list */
		GDsetTop(gd, n);		/* update end of list */

}


int
GDfromNet(gd, sockfd)
  GopherDirObj *gd;
  int sockfd;
{
     static GopherObj *TempGopher;
     static char ZesTmp[1024];
     int j, i;

     if(gd == NULL)
         return 0;

     for (j=0; ; j++) {

	  if (j == gd->maxsize)
	       GDgrow(gd, gd->maxsize*2);

	  ZesTmp[0] = '\0';
	  
	  TempGopher = GSnew();
	  GSinit(TempGopher);
	  i = GSfromNet(TempGopher, sockfd);
	  
	  if (i==0) {
	       GDaddGS(gd, TempGopher);
               twirl();
          }
          GSdestroy(TempGopher);
	  if (i==1)
	       return(j);

	  if (i<0) {

	       j = j-1;
	       if (j<0) j=0;
	       readline(sockfd, ZesTmp, 1024);
	  }
     }
} 

/*
 * Given an open file descriptor and an inited GopherDirobj,
 *   read in gopher links, and add them to a gopherdir
 */

void
GDfromLink(gd, fd, host, port)
  GopherDirObj *gd;
  FILE          *fd;
  char         *host;
  int          port;
{
     GopherObj *gs;

     gs = GSnew();

     while (GSfromLink(gs, fd, host, port) != -1)
	  GDaddGS(gd, gs);

     GSdestroy(gs);
}


void
GDtoLink(gd, fd)
  GopherDirObj *gd;
  FILE  *fd;
{
     int i;

     for (i=0; i< GDgetTop(gd); i++) {
	  GStoLink(GDgetEntry(gd, i), fd);
     }	  

}


#ifdef GOPHER_SERVER
/** Compare two GopherObjs ***/

int
GScmp(gs1, gs2)
  GopherObj *gs1, *gs2;
{
     if (GSgetTitle(gs1) == NULL)
	  return(1);
     if (GSgetTitle(gs2) == NULL)
	  return(-1);

     return(strcmp(GSgetTitle(gs1), GSgetTitle(gs2)));
}

/*
 * Really weird!!!  We need this for qsort,  don't know why we can't use
 * GScmp...
 */

int
GSmoocmp(gs1, gs2)
  GopherObj **gs1, **gs2;
{
     if (GSgetTitle(*gs1) == NULL)
	  return(1);
     if (GSgetTitle(*gs2) == NULL)
	  return(-1);

     return(strcmp(GSgetTitle(*gs1), GSgetTitle(*gs2)));
}


void
GDsort(gd)
  GopherDirObj *gd;
{
     int i;

     if(gd == NULL)
        return;
     /*** Find first non-numbered entry ***/

     for (i=0; ; i++) {
	  if (GSgetNum(GDgetEntry(gd, i)) == 0)
	       break;
     }

     /*** Everything up to i is already sorted by user-defined ordering ***/

     if (GDgetTop(gd) <= i)
	  /** No more sorting needed ***/
	  return;

     
     qsort((char *) (&(gd->Gophers[i])), gd->Top-i, 
	   sizeof(GopherObj*),GSmoocmp);

}


void
GDtoNet(gd, sockfd)
  GopherDirObj *gd;
  int sockfd;
{
     int i;

     if(gd != NULL) {
         for (i=0; i< GDgetTop(gd); i++) {
    	      GStoNet(GDgetEntry(gd, i), sockfd);
         }	  
     }
     return;
}
#endif
