/* error.c
 *
 * Error handling routines from Stevens: UNIX network programming pp 722-731
 *
 * The functions in this file are independent of any application
 * variables, and may be used in any C program.  Either of the names
 * CLIENT of SERVER may be defined when compiling this function.
 * If neither are defined, we assume SERVER.
 */

#include "gopher.h"

#include <varargs.h>

#ifdef IS_BSD
#define BSD 1
#endif

#ifdef CLIENT
#ifdef SERVER
/*no way jose, can't define both! (CLIENT and SERVER)*/
#endif
#endif

#ifndef CLIENT
#ifndef SERVER
#define CLIENT 1
#endif
#endif

#ifndef NULL
#define NULL ((void *) 0)
#endif

char *pname = NULL;

/*
 * Return a string containing some additional operating system
 * dependent information.
 * Note that different versions of UNIX assign different meanings
 * to the same value of "errno".  This means that if an error
 * condition is being sent ot another UNIX system, we must interpret
 * the errno value on the system that generated the error, and not
 * just send the decimal value of errno to the other system.
 */

char *
sys_err_str()
{
	static char msgstr[200];

	if (errno != 0) {
		if (errno >0 && errno < sys_nerr)
			sprintf(msgstr, "(%s)", sys_errlist[errno]);
		else
			sprintf(msgstr, "(errno = %d)", errno);
	} else {
		msgstr[0] = '\0';
	}

#ifdef SYS5

	if (t_errno != 0) {
		char tmsgstr[100];

		if (t_errno > 0 && t_errno < sys_nerr)
			sprintf(tmsgstr, " (%s)", t_errlist[t_errno]);
		else
			sprintf(tmsgstr, ", (t_errno = %d)", t_errno);

		strcat(msgstr, tmsgstr);
	}
#endif

	return(msgstr);
}

/*
 * Print the UNIX errno value
 */


my_perror()
{
	char *sys_err_str();

	fprintf(stderr, " %s\n", sys_err_str());
}

/*
 * Fatal error related to a system call. Print the message and terminate.
 * Don't dump core, but do print the systems errno value and its
 * associated message.
 *
 *	err_sys(str, arg1, arg2, ...)
 *
 */

/*VARARGS1*/
err_sys(va_alist)
char *va_alist;
{
	va_list args;
	char *fmt;

	va_start(args);
	if (pname != NULL)
		fprintf(stderr, "%s: ", pname);
	fmt = va_arg(args, char *);

#ifndef NO_VPRINTF
	vfprintf(stderr, fmt, args);
#endif

	va_end(args);

	my_perror();

	exit(1);
}


