/********************************************************************
 * lindner
 * 3.2
 * 1994/03/08 03:21:18
 * /home/mudhoney/GopherSrc/CVS/gopher+/object/fileio.h,v
 * Exp
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 92, 93, 94 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: fileio.h
 * Abstration of socket/file input output routines.
 *********************************************************************
 * Revision History:
 * fileio.h,v
 * Revision 3.2  1994/03/08  03:21:18  lindner
 * Mods for opening processes without sh
 *
 * Revision 3.1  1994/02/20  16:20:50  lindner
 * New object based versions of buffered io routines
 *
 *
 *********************************************************************/

#ifndef FILEIO_H
#define FILEIO_H

#include "STRstring.h"
#include "boolean.h"
#include "Stdlib.h"

#ifdef VMS
#  include processes
#  include unixio
#endif

struct fileio_struct 
{
     int     bufindex;
     int     bufdatasize;
     char    *buf;

     boolean issocket;
     
     String  *filename;
     int     fd;
     pid_t   pid;
};

typedef struct fileio_struct FileIO;


#define FIOBUFSIZE   4096
#define FIOMAXOFILES 256

#define FIOisSocket(a)      ((a)->issocket)
#define FIOgetPid(a)        ((a)->pid)
#define FIOgetfd(a)         ((a)->fd)
#define FIOgetFilename(a)   (STRget((a)->filename)
#define FIOgetBufIndex(a)   ((a)->bufindex)
#define FIOgetBufDsize(a)   ((a)->bufdatasize)


#define FIOsetfd(a,b)       ((a)->fd=(b))
#define FIOsetPid(a,b)      ((a)->pid=(b))
#define FIOsetSocket(a,b)   ((a)->issocket=(b))
#define FIOsetFilename(a,b) (STRset((a)->filename,(b)))
#define FIOsetBufIndex(a,b) ((a)->bufindex = (b))
#define FIOsetBufDsize(a,b) ((a)->bufdatasize = (b))


/*
 * More elegant way of doing socket writes than ifdefs everywhere
 */

#if defined(VMS)
#   if defined(WOLLONGONG) || defined(CMUIP) || defined(NETLIB)
#       define socket_write netwrite
#       define socket_read  netread
#       define socket_close netclose
#       define FIO_NOMULTIEOF
#   endif
    /*  Note that Multinet already has socket_*  */
#else
    /* Unix systems */
#   define socket_write write
#   define socket_read  read
#   define socket_close close
#endif


/** Forward Declarations **/

FileIO *FIOopenUFS();
FileIO *FIOopenfd();
FileIO *FIOopenProcess();
FileIO *FIOopenCmdline();
int     FIOclose();
int     FIOwriten();
int     FIOwritestring();
int     FIOreadbuf();
int     FIOreadn();
int     FIOreadline();
int     FIOwaitpid();
char  **FIOgetargv();
#endif
