      SUBROUTINE VT100 (CURSOR, LCURSOR)
C
C     CURSOR CONTROL CHARACTERS FOR A VT100 TERMINAL
C
      INTEGER ZERO, SEMI, H
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), CDATA(22), LCDATA(22),
     1 BUFFER4(2)
C
      LOGICAL CURRADDR
C
      DATA ZERO/Z'30'/, SEMI/Z'3B'/, H/Z'48'/
      DATA CDATA/
     1 Z'1B5B4800',Z'1B5B4100',Z'1B5B4200',Z'1B5B4400',Z'1B5B4300',
     2 Z'1B5B0000',Z'1B5B3652',Z'1B5B324A',Z'00000000',Z'1B5B304B',
     3 Z'1B5B304A',Z'00000000',Z'00000000',Z'00000000',Z'00000000',
     4 Z'00000000',Z'00000000',Z'00000000',Z'07000000',Z'09000000',
     5 Z'0D000000',Z'0A000000'/
      DATA LCDATA/3,3,3,3,3, 2,4,4,0,4, 4,0,0,0,0, 0,0,0,1,1, 1,1/
C
C     COMMAND      LEAD IN   KEY                ASCII   DECIMAL
C     -------      -------   ---                -----   -------
C
C     HOME           YES     [H                  [ H       91 72
C     UP             YES     [A                  [ A       91 65
C     DOWN           YES     [B                  [ B       91 66
C     LEFT           YES     [D                  [ D       91 68
C     RIGHT          YES     [C                  [ C       91 67
C     ADDRESS        YES     [X;YH               [         91
C     READ ADDRESS   YES     [6R                 [ 6 R     91 54 82
C     CLEAR SCREEN   YES     [2J                 [ 2 J     91 50 74
C     CLEAR FOREGR   ----------------NOT DEFINED-------------
C     CLEAR TO EOL   YES     [0K                 [ 0 K     91 48 75
C     CLEAR TO EOS   YES     [0J                 [ 0 J     91 48 74
C     CLEAR BACKSP   ----------------NOT DEFINED-------------
C     BCKGRND FLWS   ----------------NOT DEFINED-------------
C     FREGRND FLWS   ----------------NOT DEFINED-------------
C     DELETE LINE    ----------------NOT DEFINED-------------
C     INSERT LINE    ----------------NOT DEFINED-------------
C     KEYB LOCK      ----------------NOT DEFINED-------------
C     KEYB UNLOCK    ----------------NOT DEFINED-------------
C     BELL           NO      CONTROL-G           BEL       7
C     TAB            NO      TAB (CONTROL-I)     HT        9
C     CARRIAGE RET   NO      CR                  CR        14
C     LINE FEED      NO      LF                  LF        10
C
      DO 10 I=1,22
      CURSOR(1,I) = CDATA(I)
      LCURSOR(I) = LCDATA(I)
      DO 10 J=2,10
   10 CURSOR(J,I) = 0
      RETURN
C
C     ENTRY VTCONV
C
C     PERFORM BUFFER CONVERSION FOR VT 100 TERMINAL.
C     CURSOR ADDRESSING IS EXPANDED TO CONVERT THE X AND Y SCREEN
C     COORDINATES TO INTEGER NUMBERS.
C
C     CURSOR   - INPUT BUFFER (2 INTEGER*4 WORDS).
C     ICOUNT   - NUMBER OF CHARACTERS DEFINED IN BUFFER.
C                VTCONV ONLY INSPECTS (OR MODIFIES) 2 CHARACTER
C                COMMANDS.
C     CURRADDR - LOGICAL FLAG WHICH KEEPS TRACK OF WHETHER THE LAST
C                CURSOR COMMAND WAS CURSOR ADDRESSING - THIS VARIABLE
C                MUST BE SET FALSE BY THE CALLING PROGRAM BEFORE THE
C                FIRST CALL TO VTCONV. THE CALLING PROGRAM MAY CHANGE
C                THIS VARIABLE TO INDICATE THAT THE LAST COMMAND
C                WAS NOT CURSOR ADDRESSING (SET TO .FALSE.), OR VICE
C                VERSA (SET .TRUE. TO INDICATE LAST COMMAND WAS
C                CURSOR ADDRESSING). THIS ROUTINE WILL ALSO SET/RESET
C                THE FLAG APPROPRIATELY.
C
C     CURSOR ADDRESSING IS HANDLED BY SETTING THE TRANSFER COUNT FOR
C     THE OUTPUT OF THE 'ESC' '[' PART OF THE ADDRESS COMMAND STRING
C     TO 0, AND PREFIXING THE 'ESC' '[' ONTO THE ACTUAL CURSOR ADDRESSES
C     WHEN THEY ARE WRITTEN OUT - THIS AVOIDS EXTRANEOUS 'NUL'
C     CHARACTERS BEING SENT IN THE MIDDLE OF THE ADDRESS STRING.
C
      ENTRY VTCONV (CURSOR, ICOUNT, CURRADDR)
C
      IF (ICOUNT .NE. 2) GO TO 100
      BUFFER4(1) = CURSOR(1,1)
      IF (CURRADDR) GO TO 300
      IF (BUFFER4(1) .EQ. CDATA(6)) THEN
         CURRADDR = .TRUE.
         ICOUNT = 0
         RETURN
      END IF
  100 CURRADDR = .FALSE.
      RETURN
C
C     HANDLE SCREEN ADDRESSING BY EXPANDING THE BUFFER.
C
C     BYTE    INPUT BUFFER CONTAINS        OUTPUT BUFFER CONTAINS
C       1           X COORD                       ESCAPE
C       2           Y COORD                         [
C       3           -------                       X (TENS)
C       4           -------                       X (UNITS)
C       5           -------                         ;
C       6           -------                       Y (TENS)
C       7           -------                       Y (UNITS)
C       8           -------                         H
C
  300 CURRADDR = .FALSE.
      ICOUNT = 8
      IX = IGETBUFFER1 (1, BUFFER4(1))
      IY = IGETBUFFER1 (2, BUFFER4(1))
      BUFFER4(1) = CDATA(6)
      CALL ISETBUFFER1 (3, ZERO + IX/10, BUFFER4(1))
      CALL ISETBUFFER1 (4, ZERO + IX - 10*(IX/10), BUFFER4(1))
      BUFFER4(2) = 0
      CALL ISETBUFFER1 (1, SEMI, BUFFER4(2))
      CALL ISETBUFFER1 (2, ZERO + IY/10, BUFFER4(2))
      CALL ISETBUFFER1 (3, ZERO + IY - 10*(IY/10), BUFFER4(2))
      CALL ISETBUFFER1 (4, H, BUFFER4(2))
      CURSOR(1,1) = BUFFER4(1)
      CURSOR(2,1) = BUFFER4(2)
      RETURN
      END
