      SUBROUTINE TVI914 (CURSOR, LCURSOR)
C
C     CURSOR CONTROL CHARACTERS FOR A TELEVIDEO 914 TERMINAL.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), CDATA(22), LCDATA(22),
     1 BUFFER4
C
      LOGICAL CURRADDR
C
      DATA CDATA/
     1 Z'1E000000',Z'0B000000',Z'0A000000',Z'08000000',Z'0C000000',
     2 Z'1B3D0000',Z'1B3F0000',Z'1A000000',Z'00000000',Z'1B540000',
     3 Z'1B590000',Z'00000000',Z'00000000',Z'00000000',Z'1B520000',
     4 Z'1B450000',Z'1B230000',Z'1B220000',Z'07000000',Z'09000000',
     5 Z'0D000000',Z'0A000000'/
      DATA LCDATA/1,1,1,1,1, 2,2,1,0,2, 2,0,0,0,2, 2,2,2,1,1, 1,1/
C
C     COMMAND      LEAD IN   KEY                ASCII   DECIMAL
C     -------      -------   ---                -----   -------
C
C     HOME           NO      CONTROL-^           RS        30
C     UP             NO      CONTROL-K           VT        11
C     DOWN           NO      CONTROL-J           LF        10
C     LEFT           NO      CONTROL-H           BS        8
C     RIGHT          NO      CONTROL-L           FF        12
C     ADDRESS        YES     =                   =         61
C     READ ADDRESS   YES     ?                   ?         63
C     CLEAR SCREEN   NO      CONTROL-Z           SUB       26
C     CLEAR FOREGR   ----------------NOT DEFINED-------------
C     CLEAR TO EOL   YES     T                   T         84
C     CLEAR TO EOS   YES     Y                   Y         89
C     CLEAR BACKSP   ----------------NOT DEFINED-------------
C     BCKGRND FLWS   ----------------NOT DEFINED-------------
C     FREGRND FLWS   ----------------NOT DEFINED-------------
C     DELETE LINE    YES     R                   R         82
C     INSERT LINE    YES     E                   E         69
C     KEYB LOCK      YES     #                   #         35
C     KEYB UNLOCK    YES     "                   "         34
C     BELL           NO      CONTROL-G           BEL       7
C     TAB            NO      TAB (CONTROL-I)     HT        9
C     CARRIAGE RET   NO      CR                  CR        14
C     LINE FEED      NO      LF                  LF        10
C
      DO 10 I=1,22
      CURSOR(1,I) = CDATA(I)
      LCURSOR(I) = LCDATA(I)
      DO 10 J=2,10
   10 CURSOR(J,I) = 0
      RETURN
C
C     ENTRY TVICONV
C
C     PERFORM BUFFER CONVERSION FOR TELEVIDEO TERMINAL.
C     CURSOR ADDRESSING STRINGS MUST BE OUTPUT IN ONE STATEMENT
C     TO AVOID PROBLEMS WITH INTERVENING NULL CHARACTERS IN
C     TELNET/RLOGIN SESSIONS.
C
C     CURSOR   - INPUT BUFFER (1 INTEGER*4 WORD).
C     ICOUNT   - NUMBER OF CHARACTERS DEFINED IN BUFFER.
C                TVICONV ONLY INSPECTS (OR MODIFIES) 2 CHARACTER
C                COMMANDS.
C     CURRADDR - LOGICAL FLAG WHICH KEEPS TRACK OF WHETHER THE LAST
C                CURSOR COMMAND WAS CURSOR ADDRESSING - THIS VARIABLE
C                MUST BE SET FALSE BY THE CALLING PROGRAM BEFORE THE
C                FIRST CALL TO TVICONV. THE CALLING PROGRAM MAY CHANGE
C                THIS VARIABLE TO INDICATE THAT THE LAST COMMAND
C                WAS NOT CURSOR ADDRESSING (SET TO .FALSE.), OR VICE
C                VERSA (SET .TRUE. TO INDICATE LAST COMMAND WAS
C                CURSOR ADDRESSING). THIS ROUTINE WILL ALSO SET/RESET
C                THE FLAG APPROPRIATELY.
C
C     CURSOR ADDRESSING IS HANDLED BY SETTING THE TRANSFER COUNT FOR
C     THE OUTPUT OF THE 'ESC' '...' PART OF THE ADDRESS COMMAND STRING
C     TO 0, AND PREFIXING THE 'ESC' '...' ONTO THE ACTUAL CURSOR
C     ADDRESSES WHEN THEY ARE WRITTEN OUT - THIS AVOIDS EXTRANEOUS
C     'NUL' CHARACTERS BEING SENT IN THE MIDDLE OF THE ADDRESS STRING.
C
      ENTRY TVICONV (CURSOR, ICOUNT, CURRADDR)
C
      IF (ICOUNT .NE. 2) GO TO 100
      BUFFER4 = CURSOR(1,1)
      IF (CURRADDR) GO TO 300
      IF (BUFFER4 .EQ. CDATA(6)) THEN
         CURRADDR = .TRUE.
         ICOUNT = 0
         RETURN
      END IF
  100 CURRADDR = .FALSE.
      RETURN
C
C     HANDLE SCREEN ADDRESSING BY EXPANDING THE BUFFER.
C
C     BYTE    INPUT BUFFER CONTAINS        OUTPUT BUFFER CONTAINS
C       1           X COORD                       ESCAPE
C       2           Y COORD                     <WHATEVER>
C       3           -------                       X COORD
C       4           -------                       Y COORD
C
  300 CURRADDR = .FALSE.
      ICOUNT = 4
      IX = IGETBUFFER1 (1, BUFFER4)
      IY = IGETBUFFER1 (2, BUFFER4)
      BUFFER4 = CDATA(6)
      CALL ISETBUFFER1 (3, IX, BUFFER4)
      CALL ISETBUFFER1 (4, IY, BUFFER4)
      CURSOR(1,1) = BUFFER4
      RETURN
      END
