      SUBROUTINE TERMSET (TERM, JADD, CURSOR, LCURSOR)
C
C     ROUTINE TO DETERMINE THE TERMINAL TYPE AND LOAD THE
C     PROPER CONTROL/ESCAPE SEQUENCES FOR THE TERMINAL.
C
C     ARGUMENTS (INPUT):
C     TERM   - TERMINAL CODE (1-6 FOR STANDARD TYPES, 0 FOR
C              TERMINAL TYPE TO BE SET BY MPX 'TERMDEF' FACILITY,
C              -1 FOR THIS ROUTINE TO ASK THE USER WHAT HE'S GOT).
C     JADD   - ADDRESS OF FCB FOR TERMINAL LFC.
C
C     ARGUMENTS (OUTPUT):
C     TERM   - TERMINAL CODE (1-6 FOR STANDARD TYPES, 0 FOR
C              TERMINAL TYPE SET BY MPX 'TERMDEF' FACILITY).
C     CURSOR - ARRAY OF TERMINAL CONTROL/ESCAPE CODES, DIMENSIONED
C              (10,22). NOTE THAT EACH CODE SEQUENCE MAY BE UP TO
C              40 BYTES (10 WORDS) LONG.
C     LCURSOR - LENGTH OF EACH ENTRY IN THE CURSOR ARRAY.
C
      IMPLICIT INTEGER*4 (A-Z)
C
C     INTEGER*2 TDF2(0:11), TDFUNC(22)
C
      INTEGER*4 TDF4(0:5), CURSOR(10,22), LCURSOR(22),
     1 IRIN(0:7), IROUT(0:7), TDFBUFF(10)
C
      character ans*1
C
      LOGICAL LEXIST, ALLOWAST
C
C     EQUIVALENCE (TDF2(0),TDF4(0))
C
C     DATA TDFUNC/'hc', 'up', 'do', 'bc', 'nd', '  ', '  ', 'cl',
C    1 '  ', 'ce', 'cd', '  ', '  ', '  ', 'dl', 'al', 'KL', 'KU',
C    2 '  ', '  ', '  ', '  '/
C     DATA IRIN/8*0/, IROUT/8*0/
C
C
C     GET THE TERMINAL TYPE, IF NECESSARY.
C
      ALLOWAST = .FALSE.
      IF (TERM .GE. 0) GO TO 50
C
C     WHAT TYPE OF TERMINAL IS HE USING?
C
   10 call putline (0, ' ')
      call putline (0,
     1 ' Enter the number that corresponds to your terminal:')
      call putline (0,
     1 ' 1 - Hazeltine H1500                    '//
     2 ' 4 - Televideo 914 (default)')
      call putline (0,
     1 ' 2 - ADM 3A                             '//
     2 ' 5 - Perkin Elmer 550')
      call putline (0,
     1 ' 3 - ADDS (Regent series)               '//
     2 ' 6 - DEC VT 100')
      IF (ALLOWAST) THEN
         call putline (1, ' Enter code (use * for automatic setup): ')
      ELSE
         call putline (1, ' Enter code: ')
      END IF
C
      CALL READCH (JADD, TERM, ANS, *900, *900)
C     IF (ALLOWAST .AND. ANS.EQ.'*') GO TO 100
      IF (TERM.LE.0 .OR. TERM.GT.6) TERM = 4
C
C     SET TERMINAL CONTROL/ESCAPE CODES.
C
   50 continue
C  50 IF (TERM .NE. 0) GO TO 200
C
C     SET THE TERMINAL CODES FROM THE 'TERMDEF' FACILITY.
C
C 100 TERM = 0
C     CURSOR = 0
C     LCURSOR = 0
C     INQUIRE (FILE='@SYSTEM(SYSTEM)TERMPART', EXIST=LEXIST)
C     IF (.NOT. LEXIST) THEN
C        WRITE (6,110)
C 110    FORMAT (/' *** MPX TERMINAL DEFINITIONS DO NOT EXIST -',
C    1    '     PLEASE SELECT A SPECIFIC TERMINAL TYPE.')
C        ALLOWAST = .FALSE.
C        GO TO 10
C     END IF
C
C     PREPARE TERMDEF BLOCK.
C
C     TDF4 = 0
C     TDF4(0) = ' UT '
C     TDF4(1) = ADDR(TDFBUFF)
C     TDF2(6) = 40
C     IRIN(1) = ADDR(TDF4)
C
C     LOOP OVER ALL REQUIRED FUNCTIONS.
C
C     DO 180 I=1,22
C     IF (TDFUNC(I) .EQ. '  ') GO TO 180
C     TDF2(4) = TDFUNC(I)
C     TDF2(7) = 0
C     TDFBUFF = 0
C     CALL MPXSVC (X'207A', IRIN, IROUT, ICC, ISTAT)
C     IF (ISTAT .NE. 0) THEN
C        WRITE (0,130) ISTAT
C 130    FORMAT (/' *** MPXSVC RETURNED WITH ISTAT =',I10/
C    1    '     SEE YOUR SYSTEM ADMINISTRATOR RE TERMDEF.'/)
C        STOP
C     END IF
C     IF (TDF2(7) .EQ. 0) THEN
C     UNKNOWN TERMINAL TYPE ERROR.
C        IF (TDF2(4) .EQ. 2) THEN
C           WRITE (0,140)
C 140       FORMAT (/' *** TERMDEF REPORTS AN UNKNOWN TERMINAL TYPE -'/
C    1       '     PLEASE SELECT A SPECIFIC TERMINAL TYPE.')
C           ALLOWAST = .FALSE.
C           GO TO 10
C     UNDEFINED FUNCTION FOR THIS TERMINAL - SKIP IT.
C        ELSE IF (TDF2(4) .EQ. 10) THEN
C           GO TO 180
C     ALL OTHER PROBLEMS.
C        ELSE
C           WRITE (0,160) TDF2(4), TDFUNC(I)
C 160       FORMAT (/' *** TERMDEF ERROR NUMBER: ',I5,
C    1       ', FOR REQUESTED FUNCTION: ',A2/
C    2       '     SEE YOUR SYSTEM ADMINISTRATOR RE TERMDEF.'/)
C           STOP
C        END IF
C     END IF
C     DO 170 J=1,10
C 170 CURSOR(J,I) = TDFBUFF(J)
C     LCURSOR(I) = TDF2(7)
C 180 CONTINUE
C
C     TREAT THE CURSOR MOVEMENT COMMAND SPECIALLY - SET THE LENGTH TO
C     -1 SO THE 'WRITCH' ROUTINE WILL RECOGNIZE IT EASILY.
C
C     LCURSOR(6) = -1
C
C     IF THE CURSOR 'UP', 'DOWN', 'LEFT' AND 'RIGHT' COMMANDS, AND
C     THE 'BELL', 'TAB', 'CARRIAGE RETURN' AND 'LINE FEED' COMMANDS
C     WERE NOT FILLED IN BY TERMDEF, THEN FILL THEM IN HERE WITH THE
C     USUAL/STANDARD ASCII CODES.
C
C     IF (LCURSOR(2) .EQ. 0) THEN
C        CURSOR(1,2) = 16#0B000000
C        LCURSOR(2) = 1
C     END IF
C     IF (LCURSOR(3) .EQ. 0) THEN
C        CURSOR(1,3) = 16#0A000000
C        LCURSOR(3) = 1
C     END IF
C     IF (LCURSOR(4) .EQ. 0) THEN
C        CURSOR(1,4) = 16#08000000
C        LCURSOR(4) = 1
C     END IF
C     IF (LCURSOR(5) .EQ. 0) THEN
C        CURSOR(1,5) = 16#0C000000
C        LCURSOR(5) = 1
C     END IF
C     IF (LCURSOR(19) .EQ. 0) THEN
C        CURSOR(1,19) = 16#07000000
C        LCURSOR(19) = 1
C     END IF
C     IF (LCURSOR(20) .EQ. 0) THEN
C        CURSOR(1,20) = 16#09000000
C        LCURSOR(20) = 1
C     END IF
C     IF (LCURSOR(21) .EQ. 0) THEN
C        CURSOR(1,21) = 16#0D000000
C        LCURSOR(21) = 1
C     END IF
C     IF (LCURSOR(22) .EQ. 0) THEN
C        CURSOR(1,22) = 16#0A000000
C        LCURSOR(22) = 1
C     END IF
C     RETURN
C
C     A SPECIFIC TERMINAL TYPE WAS GIVEN.
C
  200 IF (TERM .EQ. 1) THEN
         CALL HAZEL (CURSOR, LCURSOR)
      ELSE IF (TERM .EQ. 2) THEN
         CALL ADM (CURSOR, LCURSOR)
      ELSE IF (TERM .EQ. 3) THEN
         CALL ADDS (CURSOR, LCURSOR)
      ELSE IF (TERM .EQ. 5) THEN
         CALL PE550 (CURSOR, LCURSOR)
      ELSE IF (TERM .EQ. 6) THEN
         CALL VT100 (CURSOR, LCURSOR)
      ELSE
         CALL TVI914 (CURSOR, LCURSOR)
         TERM=4
      ENDIF
      RETURN
C
  900 STOP
      END
