      subroutine stwar_tunnel (score, wave, shields, font, seed, 
     &                         hit_port)
c
c    *******************************************************************
c    *****                                                         *****
c    *****                 STAR WARS VERSION 1.1                   *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        8/87                             *****
c    *****                                                         *****
c    *****               Lunchtime Software Guild                  *****
c    *****        Massachussetts Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c                                                                             
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'
c
      integer*2 font(3), position(2), event_type, origin(2), cur_op(8)
      integer*2 timer(3)
      integer*4 status, score, shields, wave, ix, iz, passes
      integer*4 cursor_bitmap, horizon, index(3)
      integer*4 score_inc, radius(10), start_counter, num_photons
      integer*4 which, center(2, 10), limit, num, inc
      integer*4 np(9), port_index, cannon(30), roll, explode_counter
      real seed, rand, xvel, yvel, zvel, yinc, dt
      real x, y, z, xscale, zscale, xmax, zmax, xt, zt, size, p(3, 3)
      real phox(10), phoy(10), phoz(10), phvel(3, 10), dr(3, 3)
      real line_y(2), dist, torx(2), tory(2), torz(2), tor_vel(3)
      real c(3, 3), exp_obx(3), exp_oby(3), exp_obz(3), exp_vel(3, 3)
      real exp_dr(3, 3, 3), exp_rot (3, 3, 3)
      double precision elapsed, duration, turn
      logical hit, moved, event, active, miss, port, shot(200)
      logical fire, scored, inside, none, struck, torpedoes
      logical contact, shoot, photon(10), hit_photon, hit_port
      logical clip, refresh, begin _roll, explode, exp_obj(3)
      character key*1, path*120
      external rand, inside
      common / phot$/ phox, phoy, phoz, phvel, photon
      save xmax, zmax, horizon, xscale, zscale, np, dr
      data np / 6 * 6, 5, 0, 4/
      data xmax, zmax, horizon / 50, 90, 2000/
      data xscale, zscale / 0.03, 0.02/
      data dr / 0.9986353, 0.0, 0.052336, 0.0, 1.0, 0.0, 
     &         -0.052336, 0.0, 0.9986353/
c
c    read in the data file
c
      if (wave .le. tunnel_max) then
        i = wave
      else
        i = mod (wave - tunnel_max, tunnel_max - tunnel_cycle + 1)
        if (i .eq. 0) i = tunnel_max - tunnel_cycle + 1
        i = i + tunnel_cycle - 1
      end if
      path = '//alchemy/usr/local/src/games/stwar/stwar_info.dir/stwar_t
     1unnel_info.'//ending(i)
      open (unit = 1, file = path)
      read (1, *) num
      do 10 i = 1, num
        read(1, *) obx(i), oby(i), obz(i), type(i), color(i)
 10   continue
      read (1, *) dist
      close (1)
c
c    set up the exhaust port
c
      num = num + 1
      port_index = num
      type(num) = 9
      obx(num) = 0.0
      oby(num) = dist - 60.0
      obz(num) = 0.0
      color(num) = 7
c
c    init all objects
c
      do 20 i = 1, num
        object(i) = .true.
        seen(i) = .false.
        shot(i) = .false.
        oby(i) = oby(i) + 1200.0
 20   continue
      dist = dist + 1200.0
c
c    initialize player placement
c
      dt   = 1.0
      x    = 0.0
      y    = 0.0
      z    = 80.0
      yvel = 20 + (wave / tunnel_max) * 2.0
      yinc = yvel / 3000.0
      scored  = .false.
      struck  = .false.
      refresh = .false.
      fire    = .false.
      shoot   = .false.
      port    = .false.
      hit_port  = .false.
      torpedoes = .false.
      clip      = .false.
      begin_roll = .true.
      explode    = .false.
      exp_obj(1) = .false.
      exp_obj(2) = .false.
      exp_obj(3) = .false.
      roll = 0
      inc  = 3
      score_inc = 0
      index(1) = 1
      index(2) = 100 
      index(3) = 1
      line_y(1) = 700
      line_y(2) = 1700
      start_counter = 0
      p(1, 1) = -1.0
      p(2, 1) =  0.0
      p(3, 1) =  0.0
      p(1, 2) =  0.0
      p(2, 2) =  1.0
      p(3, 2) =  0.0
      p(1, 3) =  0.0
      p(2, 3) =  0.0
      p(3, 3) = -1.0
c
c    start turn timer
c
      call time_$clock (timer)
      call cal_$float_clock (timer, elapsed)
c
c    get the current cursor position and any key events
c
 60   continue
      passes = 0
      call gpr_$inq_cursor (cursor_bitmap, cur_op, active, position,
     &                      origin , status)
 70   continue
        if (passes .ge. 5) goto 80
          passes = passes + 1
          event = gpr_$cond_event_wait (event_type, key, position,
     &                                  status)
          if (event .and. event_type .eq. gpr_$buttons) then
            if (key .eq. 'a') then
              fire = .true.
            else if (key .eq. 'A') then
              fire = .false.
            else if (key .eq. 'b') then
              position(1) = 400
              position(2) = 425
              call gpr_$set_cursor_position (position, status)         
            else if (key .eq. 'c') then
              call pause (font)
            end if
          end if
        goto 70
 80   continue
c
c    limit x and z positions and cursor location (no clipping)
c
      ix = position(1) - 400.0
      iz = position(2) - 425.0
      moved = .false.                               
      if (abs(ix) .gt. 305) then
        position(1) = 400 + sign(305, ix)
        moved = .true.
      end if
      if (abs(iz) .gt. 305) then
        position(2) = 425 + sign(305, iz)
        moved = .true.
      end if      
      if (moved) then
        call gpr_$set_cursor_position (position, status)
      end if
      xrvel = (position(1) - 400) * xscale
      zrvel = (425 - position(2)) * zscale
c
c    roll the player view matrix 
c
      if (begin_roll) then
        roll = roll + 1
        if (roll .eq. 60) begin_roll = .false.
        do 500 k = 1, 3
          do 510 i = 1, 3
            c(i, k) = 0.0
            do 520 j = 1, 3
              c(i, k) = c(i, k) + dr(i, j) * p(j, k)
520         continue
510       continue
500     continue
        do 530 i = 1, 3
          do 540 j = 1, 3
            p(j, i) = c(j, i)
540       continue
530     continue
      end if
c
c    rotate velocities into tie-fighter frame
c
      xvel = xrvel * p(1, 1) + zrvel * p(1, 3)
      zvel = xrvel * p(3, 1) + zrvel * p(3, 3)
      xt = x + xvel * dt
      if (abs(xt) .gt. xmax) xt = sign(real(xmax), xt)
      xvel = xt - x
      zt   = z + zvel * dt
      if (abs(zt) .gt. zmax) zt = sign(real(zmax), zt)
      x = xt
      z = zt                  
      yvel = yvel + yinc                        
      y = y + yvel * dt
      dist = dist - yvel * dt
      if (dist .lt. horizon) port = .true.
c
c    move lines and refresh them if necessary
c
      line_y(1) = line_y(1) - yvel * dt
      line_y(2) = line_y(2) - yvel * dt
      if (line_y(1) .lt. 5) then
        line_y(1) = line_y(2)
        line_y(2) = line_y(1) + 1000
      end if
      if (port) then
        if (line_y(2) .gt. dist) line_y(2) = dist
      end if        
c
c    move objects, check if seen and set indicies
c
      do 90 i = index(1), num
        if (object(i)) then
          oby(i) = oby(i) - yvel * dt
          if (oby(i) .lt. horizon) then
            if (oby(i) .ge. 5.0) then
              if (type(i) .eq. 7) then
                chkx = abs((obx(i) - x) / oby(i))
                chkz = abs((obz(i) - z) / oby(i))
                if (chkx .gt. 1.0 .or. chkz .gt. 1.0) then
                  object(i) = .false.
                  seen(i) = .false.
                else
                  seen(i) = .true.
                end if
              else if (type(i) .lt. 7) then
                chkz = abs((obz(i) - z) / oby(i))
                if (chkz .gt. 1.2) then
                  object(i) = .false.
                  seen(i) = .false.
                else
                  seen(i) = .true.
                end if
              else if (type(i) .eq. 8) then
                chkx = abs((obx(i) - x) / oby(i))
                if (chkx .gt. 0.9) then
                  object(i) = .false.
                  seen(i) = .false.
                else
                  seen(i) = .true.
                end if
              else
                seen(i) = .true.
              end if
            else
              object(i) = .false.
              seen(i) = .false.
            end if                              
          else
            seen(i) = .false.
          end if
        end if
 90   continue
      i = index(1)
100   continue
      if (i .gt. num) goto 110
        if (object(i)) then
          index(1) = i
          goto 110
        end if
        i = i + 1
        goto 100
110   continue        
      i = index(1)
120   continue
      if (i .gt. num) then
        index(2) = num
        goto 130
      end if
      if (oby(i) .gt. horizon) then
        index(2) = i 
        goto 130
      end if
      i = i + 1
      goto 120
130   continue
      contact = .false.
      do 140 i = 1, 10
        if (photon(i)) then
          if (phoy(i) .lt. 150) then
            dt4 = dt / 4.0
            l = 4
          else
            dt4 = dt
            l = 1
          end if
          do 145 j = 1, l
            phox(i) = phox(i) + (phvel(1, i) - xvel) * dt4
            phoy(i) = phoy(i) + (phvel(2, i) - yvel) * dt4
            phoz(i) = phoz(i) + (phvel(3, i)) * dt4
            if (phoy(i) .gt. 3) then
              chkx = abs(phox(i) / phoy(i))
              chkz = abs((phoz(i) - z) / phoy(i))
              if (chkx .gt. 1.0 .or. chkz .gt. 1.0) then
                photon(i) = .false.
              end if
            else
              photon(i) = .false.
            end if
            if (photon(i)) then
              if (phoy(i) .lt. yvel + 10.0) then
                contact = .true.
                photon(i) = .false.
              end if
            end if
145       continue
        end if
140   continue
c
c    propagate torpedoes if they exists
c
      if (torpedoes) then
        torx(1) = torx(1) + tor_vel(1) * dt
        tory(1) = tory(1) + (tor_vel(2) - yvel) * dt
        torz(1) = torz(1) + tor_vel(3) * dt
        torx(2) = torx(2) + tor_vel(1) * dt
        tory(2) = tory(2) + (tor_vel(2) - yvel) * dt
        torz(2) = torz(2) + tor_vel(3) * dt
        if (torz(1) .lt. -200.0) then
          torz(1) = -200.0
          torz(2) = -200.0
        end if
        if (tory(1) .ge. oby(port_index)) then
          clip = .true.
          tory(1) = oby(port_index)
          tory(2) = oby(port_index)
          tor_vel(1) = 0.0
          tor_vel(2) = 0.0
          tor_vel(3) = -10.0
        end if
      end if                           
c
c    propagate exploded cannon pieces
c
      if (explode) then
        if (explode_counter .gt. 15) then
          explode = .false.
          do 600 i = 1, 3
            exp_obj(i)  = .false.
600       continue
        else
          do 610 i = 1, 3
            if (exp_obj(i)) then
              exp_obx(i) = exp_obx(i) +  exp_vel(1, i) * dt
              exp_oby(i) = exp_oby(i) + (exp_vel(2, i) - yvel) * dt
              exp_obz(i) = exp_obz(i) +  exp_vel(3, i) * dt
              if (abs(exp_obx(i)) .gt. 70.0 .and. 
     &            exp_obz(i) .lt. 100.0) then
                exp_obx(i) = sign (abs(exp_obx(i)) - 70.0, exp_obx(i))
                exp_vel(1, i) = -exp_vel(1, i)
              end if
              if (exp_obz(i) .lt. -100.0) then
                exp_obz(i) = -200.0 - exp_obz(i)
                exp_vel(3, i) = -exp_vel(3, i)
              end if                                                 
              if (exp_oby(i) .gt. 15.0) then
                chkx = abs(exp_obx(i) / exp_oby(i))
                chkz = abs(exp_obz(i) / exp_oby(i))
                if (chkx .gt. 1.0 .or. chkz .gt. 1.0) then
                  exp_obj(i) = .false.
                end if
              else
                exp_obj(i) = .false.
              end if
              if (exp_obj(i)) then
                call stwar_matrix_multiply (exp_dr(1, 1, i), 
     &                                      exp_rot(1, 1, i), c, 1)
                call stwar_matrix_sub (c, exp_rot(1, 1, i))
              end if 
            end if
610       continue
        end if
      end if
c
c    erase and draw new objects
c          
      call gpr_$set_clipping_active (.true., status)
      call stwar_draw_tunnel (p, x, z, .true., port, dist)
      call stwar_draw_port (x, z, port_index)
      call stwar_draw_lines (p, line_y, x, z)
      call stwar_draw_design (p, x, z, begin_roll, index)
      call stwar_draw_cannons (p, x, z, begin_roll, index)
      call stwar_explode_cannons (p, x, z, exp_obx, exp_oby, exp_obz,
     &                            exp_obj, exp_rot)
      call stwar_draw_catwalks (p, x, z, begin_roll, index)
      call stwar_draw_photons (z, p, center, radius, refresh)
      if (torpedoes) then
        call stwar_draw_torpedoes (torx, tory, torz, x, z, port_index,
     &                             clip)
      end if
      call stwar_draw_phasers (position, fire, inc, shoot)
      call stwar_draw_x_hairs (position)
      call gpr_$set_clipping_active (.false., status)
c
c    check to see if player fire hits anything, starting with photons
c    if one is hit the distance is recorded.
c
      distance = 9999999.0
      hit_photon = .false.
      if (shoot) then
        do 150 i = 1, 10
          if (photon(i)) then
            range = (center(1, i) - position(1))**2 +
     &              (center(2, i) - position(2))**2
            if (range .le. radius(i)**2) then
              hit_photon = .true.
              if (phoy(i) .lt. distance) then
                distance = phoy(i)
                which = i
              end if          
            end if
          end if
150     continue
        i = index(1)
160     continue      
        if (i .gt. index(2)) goto 170
        if (seen(i)) then  
          if (hit_photon .and. oby(i) .gt. distance) goto 170
          hit = inside (poly_x(1, i), poly_y(1, i), np(type(i)), 
     &                  position(1), position(2))
          if (hit) then
            hit_photon = .false.
            if (type(i) .eq. 7) then
              object(i) = .false.
              seen(i) = .false.
              scored = .true.
              score = score + 100
              score_inc = 100
              explode = .true.
              explode_counter = 0
              call stwar_place_cannon (i, exp_obx, exp_oby, exp_obz,
     &                                 exp_vel, exp_obj, exp_dr, 
     &                                 exp_rot, seed)
              
            end if
            goto 170
          end if
        end if
        i = i + 1
        goto 160
      end if
170   continue
      if (hit_photon) then
        photon(which) = .false.
        scored = .true.
        score = score + 35
        score_inc = 35
      end if
      if (port) then
        if (fire .and. .not. torpedoes) then
          i = port_index
          hit = inside (poly_x(1, i), poly_y(1, i), np(type(i)), 
     &                  position(1), position(2))
          if (hit) then
            torpedoes = .true.
            torx(1) = x - 15.0
            tory(1) = 0.0
            torz(1) = z
            torx(2) = x + 15.0
            tory(2) = 0.0
            torz(2) = z  
            tor_vel(2) = yvel + 20.0
            num_forward = oby(i) / tor_vel(2)
            tor_vel(1) = -x / num_forward
            tor_vel(3) = (-80.0 - z) / num_forward
            hit_port = .true.
          end if
        end if
      end if
c
c    update the score
c
      call stwar_update_score (score, score_inc, scored)
c
c    check to see if the player's x-wing hits anything else
c
      if (.not. struck) then
        do 190 i = index(1), index(2)
          if (type(i) .le. 6) then
            if (seen(i) .and. oby(i) .lt. 50.0) then
              if (abs(obz(i) - z) .lt. 25) then
                itype = (type(i) - 1) / 2 + 1
                if (itype .eq. 1) then
                  contact = .true.
                else if (itype .eq. 2) then
                  if (x .lt. 10) contact = .true.
                else if (itype .eq. 3) then
                  if (x .gt. 10) contact = .true.
                end if     
              end if
            end if
         end if
190     continue
      end if
      if (contact .and. (.not. struck)) then
        struck = .true.
        counter = 0
        shields = shields - 1
        if (shields .lt. 0) then
          call stwar_scores (score, font)
        end if
        call stwar_update_shields (shields, font)
        call gpr_$set_color_map (15, int2(1), 2763306, status)
      end if
      counter = counter + 1
      if (struck .and. counter .gt. 10) then
        struck = .false.
        call gpr_$set_color_map (15, int2(1), 0, status)
      end if
c
c    shoot enemy photons
c
      num_photons = 0
      do 270 i = 1, 10
        if (photon(i)) then
          num_photons = num_photons + 1
        end if
270   continue
      j = 0
      limit = min (wave + 1, 4)
      if (num_photons .lt. limit .and.
     &    mod(start_counter, 2) .eq. 0) then
c
c    find the cannons that are visible and have not shot
c
        i = index(1)
        j = 0
280     continue
        if (i .gt. index(2)) goto 290
          if (seen(i) .and. type(i) .eq. 7) then
            if (.not. shot(i)) then
              if (oby(i) .gt. 750.0 .and. oby(i) .lt. 1500.0) then
                j = j + 1
                cannon(j) = i
              end if
            end if
          end if
          i = i + 1
          goto 280
290     continue
      end if
c
c    pick a cannon and decide if it should shoot this turn
c
      if (j .ne. 0) then
        i = min (rand(seed) * j + 1, j)
        j = cannon(i)
        if (rand(seed) .gt. 0.5) then
          num_forward = oby(j) / (10.0 + yvel)
          call stwar_find_free (i)
          phvel(1, i) = rand(seed) * 40.0 / num_forward
          if (obx(j) .gt. 0.0) phvel(1, i) = -phvel(1, i)
          phvel(2, i) = -15.0
          phvel(3, i) = 0.0
          photon(i) = .true.
          phox(i) = sign (55.0, obx(j)) - x
          phoy(i) = oby(j)
          phoz(i) = obz(j)
          shot(j) = .true.
        end if
      end if
      index(3) = index(1)
      start_counter = start_counter + 1
      explode_counter = explode_counter + 1
c
c    if too close to port then return to main
c
      if (dist .lt. 200) then
        call gpr_$set_color_map (15, int2(1), 0, status)
        return
      end if
c
c    repeat the sequence after timing the turn
c
310   continue
      call time_$clock (timer)
      call cal_$float_clock (timer, turn)
      duration = turn - elapsed
      if (duration .gt. 0.03) then
        dt = duration / 0.03
        dt = min (dt, 1.75)
        elapsed = turn
        goto 60
      end if
      goto 310
      end




      subroutine stwar_draw_tunnel (p, xcrd, zcrd, seen, port, dist)
c
c     STWAR_DRAW_TUNNEL draws the tunnel for the tunnel phase
c     If port is true the end of the tunnel and heat port are
c     also drawn.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 line_x(12), line_y(12), poly_x(4), poly_y(4)
      integer*2 x(12), y(12), z(12), box_x(4, 4), box_y(4, 4)
      integer*2 bx(4, 4), bz(4, 4)
      integer*4 status
      real xcrd, zcrd, dist, p(3, 3)
      logical port, last(2), seen
      save last, line_x, line_y, poly_x, poly_y, x, y, z
      save box_x, box_y, bx, bz
      data x / 4 * -70, 2 * -45, 2 * 45, 4 * 70/
      data y / 12 * 2000/
      data z / 2 * 100, 8 * -100, 2 * 100/
      data bx / -50, -50, -10, -10, -50, -50, -10, -10, 50, 50, 
     &           10, 10, 50, 50, 10, 10/
      data bz / 50, 10, 10, 50, -10, -50, -50, -10, 50, 10,
     &          10, 50, -10, -50, -50, -10/
      data last /2 * .false./     
c
c    erase the view seen last time
c
      if (last(1)) then
        call gpr_$set_draw_value (15, status)
        call gpr_$move (line_x(1), line_y(1), status)
        call gpr_$polyline (poly_x, poly_y, int2(3), status)
        call gpr_$multiline (line_x, line_y, int2(12), status)
      else if (last(2)) then
        call gpr_$set_draw_value (15, status)
        call gpr_$move (line_x(1), line_y(1), status)
        call gpr_$polyline (poly_x, poly_y, int2(4), status)
        call gpr_$multiline (line_x, line_y, int2(12), status)
        call gpr_$move (box_x(4, 1), box_y(4, 1), status)
        call gpr_$polyline (box_x(1, 1), box_y(1, 1), int2(4), status)
        call gpr_$move (box_x(4, 2), box_y(4, 2), status)
        call gpr_$polyline (box_x(1, 2), box_y(1, 2), int2(4), status)
        call gpr_$move (box_x(4, 3), box_y(4, 3), status)
        call gpr_$polyline (box_x(1, 3), box_y(1, 3), int2(4), status)
        call gpr_$move (box_x(4, 4), box_y(4, 4), status)
        call gpr_$polyline (box_x(1, 4), box_y(1, 4), int2(4), status)
      end if                                                  
      if (seen) then
        if (.not. port) then
          do 10 i = 2, 12, 2
            yx = x(i) - xcrd
            yz = z(i) - zcrd
            y(i) = max (yx, yz)
            y(i) = max (y(i), 5)
 10       continue
          do 20 i = 1, 11, 2
            y(i) = 2000
 20       continue
          do 30 i = 1, 12
            xoff = x(i) - xcrd
            yoff = y(i)
            zoff = z(i) - zcrd
            prx = xoff * p(1, 1) + zoff * p(3, 1)
            pry = yoff 
            prz = xoff * p(1, 3) + zoff * p(3, 3)
            line_x(i) = 400 + prx / pry * 350
            line_y(i) = 425 - prz / pry * 350
 30       continue
          poly_x(1) = line_x(3)
          poly_y(1) = line_y(3)
          poly_x(2) = line_x(9)
          poly_y(2) = line_y(9)
          poly_x(3) = line_x(11)
          poly_y(3) = line_y(11)
          call gpr_$set_draw_value (14, status)
          call gpr_$move (line_x(1), line_y(1), status)
          call gpr_$polyline (poly_x, poly_y, int2(3), status)
          call gpr_$multiline (line_x, line_y, int2(12), status)
          last(1) = .true.
          last(2) = .false.
        else
          do 40 i = 2, 12, 2
            yx = x(i) - xcrd
            yz = z(i) - zcrd
            y(i) = max (yx, yz)
            y(i) = max (y(i), 5)
 40       continue
          do 50 i = 1, 11, 2
            y(i) = dist
 50       continue
          do 60 i = 1, 12
            prx = x(i) - xcrd
            pry = y(i)
            prz = z(i) - zcrd
            line_x(i) = 400 + prx / pry * 350
            line_y(i) = 425 - prz / pry * 350
 60       continue
          do 70 i = 1, 4
            do 80 j = 1, 4
              prx = bx(j, i) - xcrd
              pry = dist
              prz = bz(j, i) - zcrd
              box_x(j, i) = 400 + prx / pry * 350
              box_y(j, i) = 425 - prz / pry * 350
 80         continue
 70       continue
          poly_x(1) = line_x(3)
          poly_y(1) = line_y(3)
          poly_x(2) = line_x(9)
          poly_y(2) = line_y(9)
          poly_x(3) = line_x(11)
          poly_y(3) = line_y(11)
          poly_x(4) = line_x(1)
          poly_y(4) = line_y(1)
          call gpr_$set_draw_value (14, status)
          call gpr_$move (line_x(1), line_y(1), status)
          call gpr_$polyline (poly_x, poly_y, int2(4), status)
          call gpr_$set_draw_value (8, status)
          call gpr_$multiline (line_x, line_y, int2(12), status)
          call gpr_$move (box_x(4, 1), box_y(4, 1), status)
          call gpr_$polyline (box_x(1, 1), box_y(1, 1), int2(4), status)
          call gpr_$move (box_x(4, 2), box_y(4, 2), status)
          call gpr_$polyline (box_x(1, 2), box_y(1, 2), int2(4), status)
          call gpr_$move (box_x(4, 3), box_y(4, 3), status)
          call gpr_$polyline (box_x(1, 3), box_y(1, 3), int2(4), status)
          call gpr_$move (box_x(4, 4), box_y(4, 4), status)
          call gpr_$polyline (box_x(1, 4), box_y(1, 4), int2(4), status)
          last(1) = .false.
          last(2) = .true.
        end if
      else
        last(1) = .false.
        last(2) = .false.
      end if
      return
      end




      subroutine stwar_draw_catwalks (p, x, z, roll, index)
c
c     STWAR_DRAW_CATWALKS draws the catwalks for the
c     tunnel phase.
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 xp(6, 3), yp(6), zp(6), ys(3), zs(3)
      integer*2 ym(4), zm(4), zmult, num(6)
      integer*4 status, index(3), itype
      real x, z, prx, pry, prz, xoff, yoff, zoff, p(3, 3)
      logical side(200), roll
      save xp, yp, zp, ym, zm, ys, zs, side, num
      data xp / 70, 70, -70, -70, -70, 70, 0, 0, -70, -70, -70, 0, 70,
     &          70, 0, 0, 0, 70/
      data yp / -25, 0, 0, -25, 0, 0/
      data zp / 0, 25, 25, 0, -25, -25/
      data ys / 25, 0, 0/
      data zs / 0, -25, 25/
      data ym / 0, -25, -25, 0/
      data zm / 25, 0, 0, -25/
      data num / 6, 5, 6, 5, 6, 5/
c
c    what the types mean
c
c      1 full catwalk (isolated or bottom of stack)
c      2 full catwalk (otherwise)
c     +2 lefthand side 
c     +4 righthand side
c
c    erase the catwalks drawn last pass
c
      if (roll) then
        do 10 i = index(3), index(2)
          if (type(i) .le. 6) then
            if (last(i)) then
              call gpr_$set_draw_value (15, status)
              call gpr_$move (poly_x(6, i), poly_y(6, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), 
     &                            num(type(i)), status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), int2(6),
     &                             status)
              if (side(i)) then
                call gpr_$move (mult_x(9, i), mult_y(9, i), status)
                call gpr_$polyline (mult_x(7, i), mult_y(7, i), int2(2),
     &                              status)
              end if
            end if
c
c    draw the new catwalks if seen
c
            if (seen(i)) then
              itype = (type(i) - 1) / 2 + 1
              do 20 j = 1, 6
                xoff = xp(j, itype) - x 
                yoff = yp(j) + oby(i)    
                zoff = zp(j) + obz(i) - z
                prx = xoff * p(1, 1) + zoff * p(3, 1)
                pry = yoff 
                prz = xoff * p(1, 3) + zoff * p(3, 3)
                if (pry .lt. 5.0) pry = 5.0
                poly_x(j, i) = 400 + prx / pry * 350
                poly_y(j, i) = 425 - prz / pry * 350
 20           continue
              do 30 j = 1, 4
                xoff = -x 
                yoff = ym(j) + oby(i)    
                zoff = zm(j) + obz(i) - z
                prx = xoff * p(1, 1) + zoff * p(3, 1)
                pry = yoff 
                prz = xoff * p(1, 3) + zoff * p(3, 3)
                if (pry .lt. 5.0) pry = 5.0
                mult_x(j, i) = 400 + prx / pry * 350
                mult_y(j, i) = 425 - prz / pry * 350
 30           continue
              mult_x(5, i) = poly_x(1, i)
              mult_y(5, i) = poly_y(1, i)
              mult_x(6, i) = poly_x(4, i)
              mult_y(6, i) = poly_y(4, i)
              side(i) = .false.
              if (oby(i) .lt. 500.0) then
                if (itype .eq. 2 .and. x .gt. 0.0) then
                  side(i) = .true.
                else if (itype .eq. 3 .and. x .lt. 0.0) then
                  side(i) = .true.
                end if
              end if
              if (side(i)) then
                do 40 j = 1, 3
                  k = j + 6
                  xoff = - x 
                  yoff = ys(j) + oby(i)    
                  zoff = zs(j) + obz(i) - z
                  prx = xoff * p(1, 1) + zoff * p(3, 1)
                  pry = yoff 
                  prz = xoff * p(1, 3) + zoff * p(3, 3)
                  if (pry .lt. 5.0) pry = 5.0
                  mult_x(k, i) = 400 + prx / pry * 350
                  mult_y(k, i) = 425 - prz / pry * 350
 40             continue
              end if
              call gpr_$set_draw_value (color(i), status)
              call gpr_$move (poly_x(6, i), poly_y(6, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), 
     &                            num(type(i)), status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), int2(6),
     &                             status)
              if (side(i)) then
                call gpr_$move (mult_x(9, i), mult_y(9, i), status)
                call gpr_$polyline (mult_x(7, i), mult_y(7, i), int2(2),
     &                              status)
              end if
              last(i) = .true.
            else
              last(i) = .false.
            end if
          end if
 10     continue
      else
        do 50 i = index(3), index(2)
          if (type(i) .le. 6) then
            if (last(i)) then
              call gpr_$set_draw_value (15, status)
              call gpr_$move (poly_x(6, i), poly_y(6, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), 
     &                            num(type(i)), status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), int2(6),
     &                             status)
              if (side(i)) then
                call gpr_$move (mult_x(9, i), mult_y(9, i), status)
                call gpr_$polyline (mult_x(7, i), mult_y(7, i), int2(2),
     &                              status)
              end if
            end if
c
c    draw the new catwalks if seen
c
            if (seen(i)) then
              itype = (type(i) - 1) / 2 + 1
              do 60 j = 1, 6
                prx = xp(j, itype) - x 
                pry = yp(j) + oby(i)    
                prz = zp(j) + obz(i) - z
                if (pry .lt. 5.0) pry = 5.0
                poly_x(j, i) = 400 + prx / pry * 350
                poly_y(j, i) = 425 - prz / pry * 350
 60           continue
              do 70 j = 1, 4
                prx = -x 
                pry = ym(j) + oby(i)    
                prz = zm(j) + obz(i) - z
                if (pry .lt. 5.0) pry = 5.0
                mult_x(j, i) = 400 + prx / pry * 350
                mult_y(j, i) = 425 - prz / pry * 350
 70           continue
              mult_x(5, i) = poly_x(1, i)
              mult_y(5, i) = poly_y(1, i)
              mult_x(6, i) = poly_x(4, i)
              mult_y(6, i) = poly_y(4, i)
              side(i) = .false.
              if (oby(i) .lt. 500.0) then
                if (itype .eq. 2 .and. x .gt. 0.0) then
                  side(i) = .true.
                else if (itype .eq. 3 .and. x .lt. 0.0) then
                  side(i) = .true.
                end if
              end if
              if (side(i)) then
                do 80 j = 1, 3
                  k = j + 6
                  prx = - x 
                  pry = ys(j) + oby(i)    
                  prz = zs(j) + obz(i) - z
                  if (pry .lt. 5.0) pry = 5.0
                  mult_x(k, i) = 400 + prx / pry * 350
                  mult_y(k, i) = 425 - prz / pry * 350
 80             continue
              end if
              call gpr_$set_draw_value (color(i), status)
              call gpr_$move (poly_x(6, i), poly_y(6, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), 
     &                            num(type(i)), status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), int2(6),
     &                             status)
              if (side(i)) then
                call gpr_$move (mult_x(9, i), mult_y(9, i), status)
                call gpr_$polyline (mult_x(7, i), mult_y(7, i), int2(2),
     &                              status)
              end if
              last(i) = .true.
            else
              last(i) = .false.
            end if
          end if
 50     continue
      end if
      return
      end




      subroutine stwar_draw_cannons (p, x, z, roll, index)
c
c     STWAR_DRAW_CANNONS draws the red cannons for the
c     tunnel phase.
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 xp(6), yp(6), zp(6)
      integer*4 status, index(3)
      real x, z, way, prx, pry, prz, xoff, yoff, zoff, p(3, 3)
      logical roll
      save xp, yp, zp
      data xp / 0, 0, 0, 0, 10, 10/
      data yp /12, -12, -12, 12, 2, -2/
      data zp /12, 12, -12, -12, 0, 0/
c
c    erase the cannons drawn last pass
c
      if (roll) then
        do 10 i = index(3), index(2)
          if (type(i) .eq. 7) then
            if (last(i)) then
              call gpr_$set_draw_value (15, status)
              call gpr_$move (poly_x(5, i), poly_y(5, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(6),
     &                            status)
              call gpr_$move (poly_x(2, i), poly_y(2, i), status)
              call gpr_$polyline (mult_x(1, i), mult_y(1, i), int2(2), 
     &                            status)
            end if
c
c    draw the new cannons if seen
c
            if (seen(i)) then
              way = 1.0
              if (obx(i) .gt. 0.0) way = -1.0
              do 20 j = 1, 6
                xoff = way * xp(j) + obx(i) - x 
                yoff = yp(j) + oby(i)    
                zoff = zp(j) + obz(i) - z
                prx = xoff * p(1, 1) + zoff * p(3, 1)
                pry = yoff 
                prz = xoff * p(1, 3) + zoff * p(3, 3)
                if (pry .lt. 10.0) pry = 10.0
                poly_x(j, i) = 400 + prx / pry * 350
                poly_y(j, i) = 425 - prz / pry * 350
 20           continue
              mult_x(1, i) = poly_x(6, i)
              mult_y(1, i) = poly_y(6, i)
              mult_x(2, i) = poly_x(3, i)
              mult_y(2, i) = poly_y(3, i)
              call gpr_$set_draw_value (7, status)
              call gpr_$move (poly_x(5, i), poly_y(5, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(6),
     &                            status)
              call gpr_$move (poly_x(2, i), poly_y(2, i), status)
              call gpr_$polyline (mult_x(1, i), mult_y(1, i), int2(2), 
     &                            status)
              last(i) = .true.
            else
              last(i) = .false.
            end if
          end if
 10     continue
      else
        do 30 i = index(3), index(2)
          if (type(i) .eq. 7) then
            if (last(i)) then
              call gpr_$set_draw_value (15, status)
              call gpr_$move (poly_x(5, i), poly_y(5, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(6),
     &                            status)
              call gpr_$move (poly_x(2, i), poly_y(2, i), status)
              call gpr_$polyline (mult_x(1, i), mult_y(1, i), int2(2), 
     &                            status)
            end if
c
c    draw the new cannons if seen
c
            if (seen(i)) then
              way = 1.0
              if (obx(i) .gt. 0.0) way = -1.0
              do 40 j = 1, 6
                prx = way * xp(j) + obx(i) - x 
                pry = yp(j) + oby(i)    
                prz = zp(j) + obz(i) - z
                if (pry .lt. 10.0) pry = 10.0
                poly_x(j, i) = 400 + prx / pry * 350
                poly_y(j, i) = 425 - prz / pry * 350
 40           continue
              mult_x(1, i) = poly_x(6, i)
              mult_y(1, i) = poly_y(6, i)
              mult_x(2, i) = poly_x(3, i)
              mult_y(2, i) = poly_y(3, i)
              call gpr_$set_draw_value (7, status)
              call gpr_$move (poly_x(5, i), poly_y(5, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(6),
     &                            status)
              call gpr_$move (poly_x(2, i), poly_y(2, i), status)
              call gpr_$polyline (mult_x(1, i), mult_y(1, i), int2(2), 
     &                            status)
              last(i) = .true.
            else
              last(i) = .false.
            end if
          end if
 30     continue
      end if
      return
      end




      subroutine stwar_draw_lines (p, y, xcrd, zcrd)
c
c     STWAR_DRAW_LINES draws the lines that run the length of
c     the tunnel
c                                                                             
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 line_x(8), line_y(8), x(8), z(8)
      integer*4 status
      real xcrd, y(2), zcrd, p(3, 3)
      save line_x, line_y, x, z
      data x / 2 * 70, 2 * - 70, 2 * 70, 2 * -70/
      data z / 100, -100, 100, -100, 100, -100, 100, -100/
      data line_x, line_y / 16 * 0/
c
c    erase the old lines
c
      call gpr_$set_draw_value (15, status)
      call gpr_$multiline (line_x, line_y, int2(8), status)
c
c    draw the new lines
c
      do 10 i = 1, 8
        j   = (i - 1) / 4 + 1
        xoff = x(i) - xcrd
        yoff = y(j)
        zoff = z(i) - zcrd
        prx = xoff * p(1, 1) + zoff * p(3, 1)
        pry = yoff 
        prz = xoff * p(1, 3) + zoff * p(3, 3)
        if (pry .lt. 5.0) pry = 5.0
        line_x(i) = 400 + prx / pry * 350
        line_y(i) = 425 - prz / pry * 350        
 10   continue
      call gpr_$set_draw_value (8, status)
      call gpr_$multiline (line_x, line_y, int2(8), status)
      return
      end





      subroutine stwar_draw_port (x, z, index)
c
c     STWAR_DRAW_PORT draws the heat exhaust port at the tunnel's
c     end
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 bx(4), by(4), bz(4), px(4), py(4)
      integer*4 status, index
      real x, z
      logical drew
      save drew, bx, by, bz, px, py
      data bx / 2 * -40, 2 * 40/
      data by / 40, -40, -40, 40/
      data bz / 4 * -100/
      data px / 2 * -30, 2 * 30/
      data py / 30, -30, -30, 30/
      data drew / .false./     
c
c    erase the view seen last time
c
      if (drew) then
        call gpr_$set_draw_value (15, status)
        call gpr_$move (poly_x(4, index), poly_y(4, index), status)
        call gpr_$polyline (poly_x(1, index), poly_y(1, index), 
     &                      int2(4), status)
        call gpr_$multiline (mult_x(5, index), mult_y(5, index), 
     &                      int2(12), status)      
        call gpr_$move (mult_x(4, index), mult_y(4, index), status)
        call gpr_$polyline (mult_x(1, index), mult_y(1, index), 
     &                      int2(4), status)      
      end if                                                  
      if (seen(index)) then
        do 10 i = 1, 4
          prx = bx(i) - x
          pry = by(i) + oby(index)
          prz = bz(i) - z
          if (pry .lt. 5) pry = 5
          poly_x(i, index) = 400 + prx / pry * 350
          poly_y(i, index) = 425 - prz / pry * 350
 10     continue
        do 20 i = 1, 4
          prx = px(i) - x
          pry = py(i) + oby(index)
          prz = bz(i) - z
          if (pry .lt. 5) pry = 5
          mult_x(i, index) = 400 + prx / pry * 350
          mult_y(i, index) = 425 - prz / pry * 350
 20     continue
        mult_x(5,index) = poly_x(1, index)
        mult_y(5,index) = poly_y(1, index)
        mult_x(6,index) = mult_x(1, index)
        mult_y(6,index) = mult_y(1, index)
        mult_x(7,index) = poly_x(2, index)
        mult_y(7,index) = poly_y(2, index)
        mult_x(8,index) = mult_x(2, index)
        mult_y(8,index) = mult_y(2, index)
        mult_x(9,index) = poly_x(3, index)
        mult_y(9,index) = poly_y(3, index)
        mult_x(10,index) = mult_x(3, index)
        mult_y(10,index) = mult_y(3, index)
        mult_x(11,index) = poly_x(4, index)
        mult_y(11,index) = poly_y(4, index)
        mult_x(12,index) = mult_x(4, index)
        mult_y(12,index) = mult_y(4, index)
        call gpr_$set_draw_value (6, status)
        call gpr_$move (poly_x(4, index), poly_y(4, index), status)
        call gpr_$polyline (poly_x(1, index), poly_y(1, index), 
     &                      int2(4), status)
        call gpr_$multiline (mult_x(5, index), mult_y(5, index), 
     &                      int2(12), status)      
        call gpr_$set_draw_value (7, status)       
        call gpr_$move (mult_x(4, index), mult_y(4, index), status)
        call gpr_$polyline (mult_x(1, index), mult_y(1, index), 
     &                      int2(4), status)      
        drew = .true.
      end if
      return
      end




      subroutine stwar_draw_torpedoes (xt, yt, zt, xp, zp, index, clip)
c
c     STWAR_DRAW_TORPEDOES draws the players torpedoes that are
c     used to destroy the death star, notice the use of clipping
c     in here.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 xpt(14, 2), ypt(14, 2), x(14), y(14), z(14)
      integer*2 window_1(2, 2), window_2(2, 2)
      integer*4 status, index
      real xt(2), yt(2), zt(2), xp, zp
      real xoff, yoff, zoff, prx, pry, prz, r(3, 3), c(3, 3)
      real dr(3, 3), dx, dy, dz
      logical clip
c      save xpt, ypt, x, y, z, index, r, dr, window_1, window_2
      save xpt, ypt, x, y, z, r, dr, window_1, window_2
      data window_1, window_2 / 50, 100, 700, 650, 50, 100, 700, 650/
      data x / 25, -25, 0, 0, 0, 0, -15, 15, 15, -15, -15, 15, -15, 15/
      data y / 0, 0, 25, -25, 0, 0, -15, 15, 15, -15, 15, -15, 15, -15/
      data z / 0, 0, 0, 0, 25, -25, 15, -15, 15, -15, 15, -15, -15, 15/
      data r / 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/
      data dr /     0.9924033, 7.9259750E-02, -9.4093890E-02,
     &         -8.6827580E-02,     0.9930655, -7.9259750E-02,
     &          8.7159270E-02, 8.6827580E-02,      0.9924033/
c
c    update the photon rotation matrix (r)
c
      do 10 k = 1, 3
        do 20 i = 1, 3
          c(i, k) = 0.0
          do 30 j = 1, 3
            c(i, k) = c(i, k) + dr(i, j) * r(j, k)
 30       continue
 20     continue
 10   continue                             
      do 40 k = 1, 3
        do 50 i = 1, 3
          r(i, k) = c(i, k)
 50     continue
 40   continue                             
c
c    erase the photons seen last turn
c
      call gpr_$set_clip_window (window_2, status)
      call gpr_$set_draw_value (15, status)
      call gpr_$multiline (xpt(1, 1), ypt(1, 1), int2(14), status)
      call gpr_$multiline (xpt(1, 2), ypt(1, 2), int2(14), status)
c
c    draw the new photons if seen
c
      if (clip) then
        window_2(1, 1) = poly_x(2, index)
        window_2(2, 1) = 100
        window_2(1, 2) = poly_x(3, index) - poly_x(2, index)
        window_2(2, 2) = poly_y(2, index) - 101
        window_2(2, 2) = min (window_2(2, 2), 650)
      else
        window_2(1, 1) = window_1(1, 1)
        window_2(2, 1) = window_1(2, 1)
        window_2(1, 2) = window_1(1, 2)
        window_2(2, 2) = window_1(2, 2)
      end if
      call gpr_$set_clip_window (window_2, status)
      do 80 i = 1, 2
        xoff = xp - xt(i)
        yoff = -yt(i)      
        zoff = zp - zt(i)
        dx = xoff * r(1, 1) + yoff * r(2, 1) + zoff * r(3, 1)
        dy = xoff * r(1, 2) + yoff * r(2, 2) + zoff * r(3, 2)
        dz = xoff * r(1, 3) + yoff * r(2, 3) + zoff * r(3, 3)
        do 90 j = 1, 14
          xoff = x(j) - dx
          yoff = y(j) - dy
          zoff = z(j) - dz
          prx = xoff * r(1, 1) + yoff * r(1, 2) + zoff * r(1, 3)
          pry = xoff * r(2, 1) + yoff * r(2, 2) + zoff * r(2, 3)
          prz = xoff * r(3, 1) + yoff * r(3, 2) + zoff * r(3, 3)
          if (pry .lt. 5.0) pry = 5.0
          xpt(j, i) = 400 + prx / pry * 350
          ypt(j, i) = 425 - prz / pry * 350
 90     continue          
        call gpr_$set_draw_value (12, status)            
        call gpr_$multiline (xpt(1, i), ypt(1, i), int2(14), status)
 80   continue
      call gpr_$set_clip_window (window_1, status)
      return
      end






      subroutine stwar_draw_design (p, x, z, roll, index)
c
c     STWAR_DRAW_DESIGN draws the wall designs for the tunnel phase.  
c     These are purely decorative.
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 yp(4), zp(4), ym(16, 4), zm(16, 4)
      integer*2 num(4)
      integer*4 status, index(3)
      real x, z, prx, pry, prz, xoff, yoff, zoff, p(3, 3)
      logical roll
      save yp, zp, ym, zm, num
      data num / 0, 4, 16, 10/
      data yp /-60, -60, 60, 60/
      data zp /90, -90, -90, 90/
      data ym / 16 * 0, -60, 60, 60, -60, 12 * 0, -60, -20, 60, 20, 
     &          -60, -20, 60, 20, -20, 20, 20, 20, 20, -20, -20, -20, 
     &          -60, -20, 60, 20, -60, -20, 60, 20, -20, 20, 6 * 0/
      data zm / 16 * 0, 85, -85, 85, -85, 12 * 0, 85, 30, 85, 30,
     &          -85, -30, -85, -30, 30, 30, 30, -30, -30, -30, -30, 
     &           30, 85, 0, 85, 0, -85, 0, -85, 0, 0, 0, 6 * 0/
c
c    erase the designs drawn last pass
c
      if (roll) then
        do 10 i = index(3), index(2)
          if (type(i) .eq. 8) then
            if (last(i)) then
              call gpr_$set_draw_value (15, status)
              call gpr_$move (poly_x(4, i), poly_y(4, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(4),
     &                            status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), 
     &                            num(color(i)), status)
            end if
c
c    draw the new designs if seen
c
            if (seen(i)) then
              k = color(i)
              do 20 j = 1, 4
                xoff = obx(i) - x 
                yoff = yp(j) + oby(i)    
                zoff = zp(j) - z
                prx = xoff * p(1, 1) + zoff * p(3, 1)
                pry = yoff 
                prz = xoff * p(1, 3) + zoff * p(3, 3)
                pry = max(20.0, pry)
                poly_x(j, i) = 400 + prx / pry * 350
                poly_y(j, i) = 425 - prz / pry * 350
 20           continue
              do 30 j = 1, num(k)
                xoff = obx(i) - x 
                yoff = ym(j, k) + oby(i)    
                zoff = zm(j, k) - z
                prx = xoff * p(1, 1) + zoff * p(3, 1)
                pry = yoff 
                prz = xoff * p(1, 3) + zoff * p(3, 3)
                pry = max(20.0, pry)
                mult_x(j, i) = 400 + prx / pry * 350
                mult_y(j, i) = 425 - prz / pry * 350
 30           continue
              call gpr_$set_draw_value (14, status)
              call gpr_$move (poly_x(4, i), poly_y(4, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(4),
     &                            status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), 
     &                            num(color(i)), status)
              last(i) = .true.
            else
              last(i) = .false.
            end if
          end if
 10     continue
      else
        do 40 i = index(3), index(2)
          if (type(i) .eq. 8) then
            if (last(i)) then
              call gpr_$set_draw_value (15, status)
              call gpr_$move (poly_x(4, i), poly_y(4, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(4),
     &                            status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), 
     &                            num(color(i)), status)
            end if
c
c    draw the new cannons if seen
c
            if (seen(i)) then
              k = color(i)
              do 50 j = 1, 6
                prx = obx(i) - x 
                pry = yp(j) + oby(i)    
                prz = zp(j) - z
                pry = max(20.0, pry)
                poly_x(j, i) = 400 + prx / pry * 350
                poly_y(j, i) = 425 - prz / pry * 350
 50           continue
              do 60 j = 1, num(k)
                prx = obx(i) - x 
                pry = ym(j, k) + oby(i)    
                prz = zm(j, k) - z
                pry = max(20.0, pry)
                mult_x(j, i) = 400 + prx / pry * 350
                mult_y(j, i) = 425 - prz / pry * 350
 60           continue
              call gpr_$set_draw_value (14, status)
              call gpr_$move (poly_x(4, i), poly_y(4, i), status)
              call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(4),
     &                            status)
              call gpr_$multiline (mult_x(1, i), mult_y(1, i), 
     &                            num(color(i)), status)
              last(i) = .true.
            else
              last(i) = .false.
            end if
          end if
 40     continue
      end if
      return
      end





      subroutine stwar_place_cannon (index, exp_obx, exp_oby, exp_obz,
     &                               exp_vel, exp_obj, exp_dr, exp_rot, 
     &                               seed)
c
c     STWAR_PLACE_CANNON initializes the placement, rotation, velocity
c     and rotation rate of the pieces of an exploding cannon.
c
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'
c
      integer index
      real exp_obx(3), exp_oby(3), exp_obz(3), exp_vel(3, 3)
      real exp_dr(3, 3, 3), exp_rot(3, 3, 3), seed, rand
      real base_obx(3), base_oby(3), base_obz(3)
      logical exp_obj(3)
      external rand
      save base_obx, base_oby, base_obz
      data base_obx / 5, 5, 5/
      data base_oby / -7, 0, 0/
      data base_obz / 0, 6, -6/
c
c    start to initialize all variables
c
      do 10 i = 1, 3
c
c    existance flag
c
        exp_obj(i) = .true.
c
c    starting rotation
c
        do 20 j = 1, 3
          do 30 k = 1, 3
            exp_rot(k, j, i) = 0.0
 30       continue
          exp_rot(j, j, i) = 1.0          
 20     continue                
c
c    starting position
c
        way = sign(1.0, obx(index))
        exp_obx(i) = obx(index) - base_obx(i) * way
        exp_oby(i) = oby(index) + base_oby(i)
        exp_obz(i) = obz(index) + base_obz(i) 
c
c    starting velocity
c
        exp_vel(1, i) = -3.0 * rand(seed) * way
        exp_vel(2, i) =  3.0
        exp_vel(3, i) =  7.5 * (rand(seed) - 0.5)
c
c    incremental rotation
c
        phi = 0.8 * (rand(seed))
        if (rand(seed) .gt. 0.5) phi = -phi
        theta = 0.8 * (rand(seed))
        if (rand(seed) .gt. 0.5) theta = -theta
        psi = 0.8 * (rand(seed))
        if (rand(seed) .gt. 0.5) psi = -psi
        c1 = cos(phi)
        s1 = sin(phi)
        c2 = cos(theta)
        s2 = sin(theta)
        c3 = cos(psi) 
        s3 = sin(psi)
        exp_dr(1, 1, i) =  c3 * c1 - c2 * s1 * s3
        exp_dr(2, 1, i) = -s3 * c1 - c2 * s1 * c3
        exp_dr(3, 1, i) =  s2 * s1
        exp_dr(1, 2, i) =  c3 * s1 + c2 * c1 * s3
        exp_dr(2, 2, i) = -s3 * s1 + c2 * c1 * c3
        exp_dr(3, 2, i) = -s2 * c1
        exp_dr(1, 3, i) =  s3 * s2
        exp_dr(2, 3, i) =  c3 * s2
        exp_dr(3, 3, i) =  c2
 10   continue
c
c    ensure a nice looking explosion
c
      exp_vel(3, 2) = -sign(abs(exp_vel(3, 2)), exp_vel(3, 3))
      return
      end

                        



      subroutine stwar_explode_cannons (p, x, z, exp_obx, exp_oby, 
     &                                  exp_obz, exp_obj, exp_rot)
c
c     STWAR_EXPLODE_CANNONS draws the pieces of an exploding cannon
c
      integer*2 poly_x(4, 3), poly_y(4, 3), num(3)
      integer*2 cpx(4, 3), cpy(4, 3), cpz(4, 3)
      integer*4 status
      real exp_obx(3), exp_oby(3), exp_obz(3), exp_rot(3, 3, 3)
      real p(3, 3), x, z, b(3, 3)
      logical exp_obj(3), last(3)
      save num, cpx, cpy, cpz, last, poly_x, poly_y
      data poly_x / 12 * 0/
      data poly_y / 12 * 0/
      data num / 3, 4, 4/
      data cpx / -5, 5, -5, -5, -5, 5, 5, -5, -5, 5, 5, -5/
      data cpy / -5, 5, -5, -5, -12, -2, 2, 12, -12, -2, 2, 12/
      data cpz / 12, 0, -12, -12, 6, -6, -6, 6, -6, 6, 6, -6/
      data last / 3 * .false./
c
c    erase any fragments drawn last pass
c
      do 10 i = 1, 3
        if (last(i)) then
          call gpr_$set_draw_value (15, status)
          call gpr_$move (poly_x(num(i), i), poly_y(num(i), i), status)
          call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(num(i)),
     &                        status)
        end if
 10   continue
c
c    draw any fragments currently in view
c
      do 20 i = 1, 3
        if (exp_obj(i)) then
          do 30 j = 1, 3
            do 40 k = 1, 3
              b(j, k) = 0.0
              do 50 l = 1, 3
                b(j, k) = b(j, k) + exp_rot(l, j, i) * p(l, k)
 50           continue
 40         continue
 30       continue                              
          xt = x - exp_obx(i)
          yt = -exp_oby(i)
          zt = z - exp_obz(i)
          dx = xt * exp_rot(1, 1, i) + yt * exp_rot(2, 1, i) + 
     &         zt * exp_rot(3, 1, i)
          dy = xt * exp_rot(1, 2, i) + yt * exp_rot(2, 2, i) + 
     &         zt * exp_rot(3, 2, i)
          dz = xt * exp_rot(1, 3, i) + yt * exp_rot(2, 3, i) + 
     &         zt * exp_rot(3, 3, i)
          do 60 j = 1, num(i)
            rx = cpx(j, i) - dx
            ry = cpy(j, i) - dy
            rz = cpz(j, i) - dz
            prx = rx * b(1, 1) + ry * b(2, 1) + rz * b(3, 1)
            pry = rx * b(1, 2) + ry * b(2, 2) + rz * b(3, 2)
            prz = rx * b(1, 3) + ry * b(2, 3) + rz * b(3, 3)
            pry = max(pry, 10.0)
            poly_x(j, i) = 400 + prx / pry * 350
            poly_y(j, i) = 425 - prz / pry * 350
 60       continue                                
          call gpr_$set_draw_value (7, status)
          call gpr_$move (poly_x(num(i), i), poly_y(num(i), i), status)
          call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(num(i)),
     &                        status)
          last(i) = .true.
        else
          last(i) = .false.
        end if
 20   continue
      return
      end
