      subroutine stwar_towers (score, wave, shields, font, seed,
     &                         cleared)
c
c    *******************************************************************
c    *****                                                         *****
c    *****                 STAR WARS VERSION 1.1                   *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        8/87                             *****
c    *****                                                         *****
c    *****               Lunchtime Software Guild                  *****
c    *****        Massachussetts Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c                                                                             
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'
c
      integer*2 font(3), position(2), event_type, origin(2), cur_op(8)
      integer*2 window(2, 2), timer(3), col_obj(40), col_type(40)
      integer*2 col_side(40), num_col, max_shot(3)
      integer*4 status, score, shields, wave, ix, iz, passes
      integer*4 cursor_bitmap, horizon, xoff, xmax, sequence(12)
      integer*4 tlist(30, 10), number(10), phase, index, shot(30)
      integer*4 score_inc, np(3), points(3), counter, roll, roll_max
      integer*4 direct, radius(10), start_counter, num_photons, which
      integer*4 center(2, 10), limit, height(3), num_caps, total_caps
      real xdot(20), ydot(20), seed, rand, xvel, yvel, xlist(30, 10)
      real ylist(30, 10), marker, yinc
      real xscale, zscale, p(3, 3), zmin, zmax, xt, zt, size
      real b(3, 3), c(3, 3), r(3, 3, 2), phox(10), phoy(10), phoz(10)
      real phvel(3, 10), dt, d(3, 3), rscale, a(3, 3)
      double precision elapsed, duration, turn
      logical hit, moved, event, active, miss, cleared, explode
      logical fire, scored, inside, none, struck, refresh, final_roll
      logical contact, veer, shoot, photon(10), hit_photon, final
      character key*1, path*120, text*10
      external rand, inside
      common / phot$/ phox, phoy, phoz, phvel, photon
      save points, np, roll_max, xmax, horizon, zmin, zmax, xscale
      save yscale, b, r, window, max_shot, rscale
      data window / 650, 79, 101, 20/
      data points, np / 0, 100, 400, 8, 6, 6/
      data max_shot / 0, 2, 3/
      data xmax, horizon / 1250, 1750/
      data roll_max / 15/
      data height / 0, 20, 240/
      data yinc, xscale, zscale, rscale / 0.005, 0.03, 0.02, 4.0e-4/
      data zmin, zmax / 10.0, 170.0/
      data r / 0.9986353, 0.0, -0.052336, 0.0, 1.0, 0.0, 0.052336, 
     &         0.0, 0.9986353, 0.9986353, 0.0, 0.052336, 0.0, 1.0, 
     &         0.0, -0.052336, 0.0, 0.9986353/
      data b / 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/          
c
c    read in the data file
c
      if (wave .le. towers_max) then
        i = wave
      else
        i = mod (wave - towers_max, towers_max - towers_cycle + 1)
        if (i .eq. 0) i = towers_max - towers_cycle + 1
        i = i + towers_cycle - 1
      end if
      path = '//alchemy/usr/local/src/games/stwar/stwar_info.dir/stwar_t
     1owers_info.'//ending(i)
      open (unit = 1, file = path)
      read (1, *) (sequence(i), i = 1, 12)
      read (1, *) total_caps
      do 10 i = 1, 10
        read (1, *) number(i)
        do 15 j = 1, number(i)
          read (1, *) xlist(j, i), ylist(j, i), tlist(j, i)
 15     continue
 10   continue
      close (1)
c
c    initialize the dots and player placement
c
      dt   = 1.0
      xoff = 0.0
      z    = 50.0
      xvel = 0.0
      zvel = 0.0
      yvel = 15 + wave / 1.5
      yinc = yvel / 2000.0
      scored  = .false.
      explode = .false.
      struck  = .false.
      refresh = .false.
      veer    = .false.
      fire    = .false.
      shoot   = .false.
      cleared = .false.
      final   = .false.
      final_roll = .false.
      score_inc = 0
      num_caps = 0
      roll = 0
      inc  = 3
      do 20 i = 1, 3
        do 30 j = 1, 3
          d(j, i) = b(j, i)
 30     continue
 20   continue
      do 40 i = 1, 20
        xdot(i) = xmax * (2.0 * rand(seed) - 1.0)
        ydot(i) = horizon * rand(seed)
 40   continue                           
c
c    give the number of caps
c
      if (total_caps .gt. 0) then
        call gpr_$set_clipping_active (.false., status)
        call gpr_$set_text_font (font(1), status)
        call gpr_$set_text_value (9, status)
        call gpr_$move (int2(686), int2(95), status)
        text = 'TOWERS'
        call gpr_$text (text, int2(6), status)
        write (text, '(i2)') total_caps 
        call gpr_$set_text_value (6, status)
        call gpr_$move (int2(658), int2(95), status)
        call gpr_$text (text, int2(2), status)
      end if
c
c    set up the first pass (note that this is always empty)
c
      phase = 0
      num = 0
      start_counter = 0
      do 50 i = 1, 30
        object(i) = .false.
        seen(i) = .false.
        shot(i) = 0
        obx(i)  = 0.0
        oby(i)  = 0.0
        type(i) = 1.0
 50   continue
c
c    start turn timer
c
      call time_$clock (timer)
      call cal_$float_clock (timer, elapsed)
c
c    get the current cursor position and any key events
c
 60   continue
      passes = 0
      call gpr_$inq_cursor (cursor_bitmap, cur_op, active, position,
     &                      origin , status)
 70   continue
        if (passes .ge. 5) goto 80
          passes = passes + 1
          event = gpr_$cond_event_wait (event_type, key, position,
     &                                  status)
          if (event .and. event_type .eq. gpr_$buttons) then
            if (key .eq. 'a') then
              fire = .true.
            else if (key .eq. 'A') then
              fire = .false.
            else if (key .eq. 'b') then
              position(1) = 400
              position(2) = 425
              call gpr_$set_cursor_position (position, status)         
            else if (key .eq. 'c') then
              call pause (font)
            end if
          end if
        goto 70
 80   continue
c
c    limit x and z positions and cursor location (no clipping)
c
      ix = position(1) - 400.0
      iz = position(2) - 425.0
      moved = .false.                               
      if (abs(ix) .gt. 305) then
        position(1) = 400 + sign(305, ix)
        moved = .true.
      end if
      if (abs(iz) .gt. 305) then
        position(2) = 425 + sign(305, iz)
        moved = .true.
      end if      
      if (moved) then
        call gpr_$set_cursor_position (position, status)
      end if
      if (.not. veer) then 
        xvel = (position(1) - 400) * xscale
        zvel = (425 - position(2)) * zscale
      end if
      sn = sin (rscale * (position(1) - 400))
      cn = cos (rscale * (position(1) - 400))
      xt = xoff + xvel * dt
      if (abs(xt) .gt. xmax) xt = sign(real(xmax), xt)
      xvel = xt - xoff
      xoff = xt
      yvel = yvel + yinc
      zt = z + zvel * dt
      if (zt .gt. zmax) zt = zmax
      if (zt .lt. zmin) zt = zmin
      zvel = zt - z
      z = zt
      a(1, 1) = cn
      a(2, 1) = 0.0
      a(3, 1) = -sn
      a(1, 2) = 0.0
      a(2, 2) = 1.0
      a(3, 2) = 0.0
      a(1, 3) = sn
      a(2, 3) = 0.0
      a(3, 3) = cn
      do 400 k = 1, 3
        do 410 i = 1, 3
          p(i, k) = 0.0
          do 420 j = 1, 3
            p(i, k) = p(i, k) + d(i, j) * a(j, k)
420       continue
410     continue
400   continue
c
c    replace worn out dots with new ones
c
      do 90 i = 1, 20
        xdot(i) = xdot(i) - xvel * dt
        ydot(i) = ydot(i) - yvel * dt
        chkz = max (z, 5.0)
        if (ydot(i) .gt. chkz) then
          chkx = abs(xdot(i) / ydot(i))
          if (chkx .gt. 1.0) then
            ydot(i) = horizon
            xdot(i) = xmax * (2.0 * rand(seed) - 1) - xoff
          end if
        else
          ydot(i) = horizon
          xdot(i) = xmax * (2.0 * rand(seed) - 1) - xoff
        end if
 90   continue
c
c    move objects along (deleting those that are out of sight)
c
      num_col = 0
      do 100 i = 1, num   
        if (object(i)) then
          hit = .false.
          if (oby(i) .lt. 200.0) then
            dt3 = dt / 3.0
            l = 3
          else
            dt3 = dt 
            l = 1
          end if
          seen(i) = .true.
          do 101 j = 1, l
            obx(i) = obx(i) - xvel * dt3
            oby(i) = oby(i) - yvel * dt3
            if (oby(i) .gt. horizon) then
              seen(i) = .false.
            else if (oby(i) .gt. 5.0) then
              chkx = abs(obx(i) / oby(i))
              if (chkx .gt. 1.0) then
                object(i) = .false.
                seen(i) = .false.
              end if
            else
              object(i) = .false.
              seen(i) = .false.
            end if
            if (oby(i) .lt. 50.0 .and. seen(i)) then
              range = obx(i)**2 + oby(i)**2
              if (type(i) .eq. 1) then
                if (z .le. 60.0) then
                  size = (85.0 - z / 4.0)**2
                else
                  size = (70.0 - (z - 60) / 24.0)**2
                end if                              
              else if (type(i) .eq. 2) then
                if (z .lt. 50.0) then
                  size = 85.0**2
                else
                  size = 0.0 
                end if
              else
                size = 0.0
              end if
              if (range .lt. size .and. .not. hit) then
                num_col = num_col + 1
                col_obj(num_col) = i
                col_type(num_col) = 0
                col_side(num_col) = int2(sign(1.0, -obx(i)))
                hit = .true.
              end if
            end if
101       continue
        end if
100   continue    
c
c    move photons along and check for collision with those that are
c    close
c
      do 105 i = 1, 10
        if (photon(i)) then
          hit = .false.
          if (phoy(i) .lt. 200.0) then
            dt3 = dt / 3.0
            l = 3
          else
            dt3 = dt
            l = 1
          end if
          do 110 j = 1, l
            phox(i) = phox(i) + (phvel(1, i) - xvel) * dt3
            phoy(i) = phoy(i) + (phvel(2, i) - yvel) * dt3
            phoz(i) = phoz(i) + (phvel(3, i)) * dt3
            if (phoy(i) .gt. 3) then
              chkx = abs(phox(i) / phoy(i))
              chkz = abs((phoz(i) - z) / phoy(i))
              if (chkx .gt. 1.0 .or. chkz .gt. 1.0) then
                photon(i) = .false.
              end if
            else
              photon(i) = .false.
            end if
            if (photon(i) .and. .not. hit) then
              if (phoy(i) .lt. yvel + 10.0) then
                num_col = num_col + 1
                col_obj(num_col) = i
                col_type(num_col) = 1
                hit = .true.
              end if
            end if
110       continue
        end if
105   continue
c
c    draw the new objects and x hairs
c
      call gpr_$set_clipping_active (.true., status)
      call stwar_draw_dots (xdot, ydot, z, p)
      call stwar_draw_bunkers (z, p, num)
      call stwar_draw_towers (z, p, num)
      call stwar_draw_caps (z, p, num)
      call stwar_draw_photons (z, p, center, radius, refresh)
      call stwar_draw_x_hairs (position)
      call stwar_draw_phasers (position, fire, inc, shoot)
      call gpr_$set_clipping_active (.false., status)
c
c    check to see if player fire hits anything, starting with photons
c    if one is hit the distance is recorded.
c
      dist = 9999999.0
      hit_photon = .false.
      which  = -1
      if (shoot) then
        do 120 i = 1, 10
          if (photon(i)) then
            range = (center(1, i) - position(1))**2 +
     &              (center(2, i) - position(2))**2
            if (range .le. radius(i)**2) then
              hit_photon = .true.
              if (phoy(i) .lt. dist) then
                dist = phoy(i)
                which = i
              end if          
            end if
          end if
120     continue
        i = 1
130     continue      
        if (i .gt. num) goto 140
        if (seen(i)) then  
          if (hit_photon .and. oby(i) .gt. dist) goto 140
          hit = inside (poly_x(1, i), poly_y(1, i), np(type(i)), 
     &                  position(1), position(2))
          if (hit) then
            hit_photon = .false.
            which = i
            if (type(i) .gt. 1) then
              object(i) = .false.
              explode = .true.
              seen(i) = .false.
              scored = .true.
              score = score + points(type(i))
              score_inc = points(type(i))
            end if
            if (type(i) .eq. 3) then
              tlist(i, index) = 4
              num_caps = num_caps + 1
              if (num_caps .ge. total_caps) then
                num_caps = total_caps
                if (.not. cleared) then
                  call gpr_$set_fill_value (0, status)
                  call gpr_$rectangle (window, status)
                  text = '  CLEARED'
                  call gpr_$set_text_font (font(1), status)
                  call gpr_$set_text_value (6, status)
                  call gpr_$move (int2(653), int2(95), status)
                  call gpr_$text (text, int2(9), status)
                  cleared = .true.
                end if
              else
                write (text, '(i2)') total_caps - num_caps
                call gpr_$set_text_font (font(1), status)
                call gpr_$set_text_value (6, status)
                call gpr_$move (int2(658), int2(95), status)
                call gpr_$text (text, int2(2), status)
              end if
            end if
            goto 140
          end if
        end if
        i = i + 1
        goto 130
      end if
140   continue
      if (hit_photon) then
        photon(which) = .false.
        scored = .true.
        score = score + 35
        score_inc = 35
      end if
c
c    update the score
c
      call stwar_update_score (score, score_inc, scored)
c
c    check to see if the player's x-wing hits anything (note that
c    we must remove anything that hit him and was shot also)
c
      contact = .false.
      if (num_col .gt. 0 .and. which .ne. -1) then
        do 150 i = 1, num_col
          if (col_type(i) .eq. 1 .and. hit_photon) then
            if (col_obj(i) .eq. which) col_type(i) = 2
          else if (col_type(i) .eq. 0 .and. .not. hit_photon) then
            if (col_obj(i) .eq. which) col_type(i) = 2
          end if
150     continue
      end if
c
c    add up actual collisions and decide if a veer is appropriate
c
      do 160 i = 1, num_col
        if (col_type(i) .eq. 0) then
          contact = .true.
          veer = .true.
          direct = col_side(i)
        else if (col_type(i) .eq. 1) then
          contact = .true.
          photon(col_obj(i)) = .false.
        end if
160   continue
      if (contact .and. (.not. struck)) then
        struck = .true.
        counter = 0
        shields = shields - 1
        if (shields .lt. 0) then
          call stwar_scores (score, font)
        end if
        call stwar_update_shields (shields, font)
        call gpr_$set_color_map (15, int2(1), 2763306, status)
      end if
      counter = counter + 1
      if (struck .and. counter .gt. 10) then
        struck = .false.
        call gpr_$set_color_map (15, int2(1), 0, status)
      end if
c
c    set up the variables for rolling the ship if necessary
c
      if (veer) then
        roll = roll + direct
        if (abs(roll) .gt. roll_max) then
          roll = sign (roll_max, roll)
          direct = -direct
        else if (roll .eq. 0) then
          veer = .false.
        end if
      end if
c
c    if a veer is indicated then update the rotation matrix P
c
      if (veer) then
        index = 1
        if (direct .eq. -1) index = 2
        do 200 k = 1, 3
          do 210 i = 1, 3
            c(i, k) = 0.0
            do 220 j = 1, 3
              c(i, k) = c(i, k) + r(i, j, index) * d(j, k)
220         continue
210       continue
200     continue
        do 230 i = 1, 3
          do 240 j = 1, 3
            d(j, i) = c(j, i)
240       continue
230     continue
      else if (final_roll) then
        index = 2
        roll = roll - 1
        do 250 k = 1, 3
          do 260 i = 1, 3
            c(i, k) = 0.0
            do 270 j = 1, 3
              c(i, k) = c(i, k) + r(i, j, index) * d(j, k)
270         continue
260       continue
250     continue
        do 280 i = 1, 3
          do 290 j = 1, 3
            d(j, i) = c(j, i)
290       continue
280     continue
      else
        roll = 0
        do 300 i = 1, 3
          do 310 j = 1, 3
            d(j, i) = b(j, i)
310       continue
300     continue
      end if
c
c    shoot enemy photons
c
      num_photons = 0
      do 320 i = 1, 10
        if (photon(i)) then
          num_photons = num_photons + 1
        end if
320   continue
      limit = min (wave + 1, 4)
      if (num_photons .lt. limit .and.
     &    mod(start_counter, 5 - limit) .eq. 0) then
        i = rand(seed) * num + 1
        i = min(i, num)
        if (type(i) .gt. 1 .and. seen(i)) then
          if (shot(i) .lt. max_shot(type(i))) then
            num_forward = oby(i) / (yvel * (1.0 + 0.5 * rand(seed)))
            num_forward = max(3, num_forward)
            yt = oby(i) - yvel * num_forward
            miss = .false.
            if (rand(seed) .gt. 0.75) miss = .true.
            if (shot(i) .ge. 1 .and. rand(seed) .gt. 0.25) miss = .true.
            if (miss) then
              xt = oby(i) * (rand(seed) - 0.5)
              zt = zmin + rand(seed) * zmax
            else
              xt = obx(i) - xvel * num_forward
              xt = xt + (rand(seed) * 100.0 - 50.0)
              zt = zt + zvel * num_forward
              zt = zt + (rand(seed) * 100.0 - 50.0)
              zt = max(0.0, zt)
              zt = min(200.0, zt)
            end if
            call stwar_find_free (j)
            phvel(1, j) = -xt / num_forward
            phvel(2, j) = -yt / num_forward
            phvel(3, j) = (zt - height(type(i))) / num_forward
            phox(j) = obx(i)
            phoy(j) = oby(i)
            phoz(j) = height(type(i))
            photon(j) = .true.
            shot(i) = shot(i) + 1
            num_photon = num_photon + 1
          end if
        end if
      end if
c
c    update the marker, if it is far enough along then initialize
c    a new sequence. if this was the final sequence then return
c    to the main routine. 
c
      none = .true.
      if (num_photons .eq. 0) then
        i = 1
330     continue
        if (i .gt. num) goto 340
          if (object(i) .or. explode) then
            none = .false.
            goto 340
          end if        
          i = i + 1
          goto 330
340     continue
      else
        none = .false.
      end if
      start_counter = start_counter + 1
      if (phase .eq. 0 .and. start_counter .lt. 100) none = .false.
      if (final .and. abs(roll) .lt. 60) then
        if (none) then
          none = .false.
          final_roll = .true.
        end if
      end if
      if (none) then
        phase = phase + 1
        if (phase .le. 12) then
          index = sequence(phase)
          num = number(index)
          do 350 i = 1, num
            object(i) = .true.
            seen(i) = .false.
            shot(i) = 0
            obx(i)  = xlist(i, index) - xoff
            oby(i)  = ylist(i, index) + horizon
            type(i) = tlist(i, index)
            if (tlist(i, index) .eq. 4) object(i) = .false.
350       continue
          if (phase .eq. 12) final = .true.
        else
          call gpr_$set_color_map (15, int2(1), 0, status)
          call gpr_$set_fill_value (0, status)
          call gpr_$rectangle (window, status)
          return
        end if
      end if    
      explode = .false.
c
c    repeat the sequence after timing the turn
c
360   continue
      call time_$clock (timer)
      call cal_$float_clock (timer, turn)
      duration = turn - elapsed
      if (duration .gt. 0.04) then
        dt = duration / 0.04
        dt = min (dt, 1.5)
        elapsed = turn
        goto 60
      end if
      goto 360
      end
        






      subroutine stwar_draw_bunkers (z, p, num)
c
c     STWAR_DRAW_BUNKERS draws the red bunkers for the
c     tower phase. 
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 xp(8), yp(8), zp(8)
      integer*4 status, num
      real z, p(3, 3)
      real prx, pry, prz, xoff, yoff, zoff
      save xp, yp, zp
      data xp / -35, -40, 0, 40, 35, 0, -35, 0/
      data yp / 0, 0, -40, 0, 0, 35, 0, -35/
      data zp / 30, 0, 0, 0, 30, 30, 30, 30/
c
c    erase the bunkers drawn last pass
c
      do 10 i = 1, num
        if (type(i) .eq. 2) then
          if (last(i)) then
            call gpr_$set_draw_value (15, status)
            call gpr_$move (poly_x(8, i), poly_y(8, i), status)
            call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(7),
     &                          status)
            call gpr_$move (poly_x(3, i), poly_y(3, i), status)
            call gpr_$polyline (mult_x(1, i), mult_y(1, i), int2(2), 
     &                          status)
          end if
c
c    draw the new bunkers if seen
c
          if (seen(i)) then
            do 20 j = 1, 8
              xoff = xp(j) + obx(i)
              yoff = yp(j) + oby(i)      
              zoff = zp(j) - z
              prx = xoff * p(1, 1) + zoff * p(3, 1)
              pry = yoff
              prz = xoff * p(1, 3) + zoff * p(3, 3)
              if (pry .lt. 5.0) pry = 5.0
              poly_x(j, i) = 400 + prx / pry * 350
              poly_y(j, i) = 425 - prz / pry * 350
 20         continue
            mult_x(1, i) = poly_x(8, i)
            mult_y(1, i) = poly_y(8, i)
            mult_x(2, i) = poly_x(5, i)
            mult_y(2, i) = poly_y(5, i)
            call gpr_$set_draw_value (7, status)
            call gpr_$move (poly_x(8, i), poly_y(8, i), status)
            call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(7),
     &                          status)
            call gpr_$move (poly_x(3, i), poly_y(3, i), status)
            call gpr_$polyline (mult_x(1, i), mult_y(1, i), int2(2), 
     &                          status)
            last(i) = .true.
          else
            last(i) = .false.
          end if
        end if
 10   continue
      return
      end





      subroutine stwar_draw_caps (z, p, num)
c
c     STWAR_DRAW_CAPS draws the white caps for the
c     tower phase. 
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 xp(7), yp(7), zp(7)
      integer*4 status, num
      real z, p(3, 3), prx, pry, prz, xoff, yoff, zoff
      save xp, yp, zp
      data xp / 0, -14, -15, 0, 15, 14, 0/
      data yp / -14, 0, 0, -15, 0, 0, -14/
      data zp / 250, 250, 230, 230, 230, 250, 250/
c
c    erase the caps drawn last pass
c
      do 10 i = 1, num
        if (type(i) .eq. 3) then
          if (last(i)) then
            call gpr_$set_draw_value (15, status)
            call gpr_$move (poly_x(4, i), poly_y(4, i), status)
            call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(7),
     &                          status)
          end if
c
c    draw the new caps if seen
c
          if (seen(i)) then
            do 20 j = 1, 7
              xoff = xp(j) + obx(i)
              yoff = yp(j) + oby(i)      
              zoff = zp(j) - z
              prx = xoff * p(1, 1) + zoff * p(3, 1)
              pry = yoff 
              prz = xoff * p(1, 3) + zoff * p(3, 3)
              if (pry .lt. 5.0) pry = 5.0
              poly_x(j, i) = 400 + prx / pry * 350
              poly_y(j, i) = 425 - prz / pry * 350
 20         continue
            call gpr_$set_draw_value (6, status)
            call gpr_$move (poly_x(4, i), poly_y(4, i), status)
            call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(7),
     &                          status)
            last(i) = .true.
          else
            last(i) = .false.
          end if
        end if
 10   continue
      return
      end





      subroutine stwar_draw_dots (xcrd, ycrd, z, p)
c
c     STWAR_DRAW_DOTS draws the dots that are scattered about
c     the surface of the death star during the towers phase.
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 xp(20), yp(20)
      integer*4 status
      real xcrd(20), ycrd(20), z, p(3, 3)
      real prx, pry, prz, xoff, yoff, zoff
      save xp, yp, zp
c
c    erase the old dots
c
      call gpr_$set_draw_value (15, status)
      do 10 i = 1, 20
        call gpr_$move (xp(i), yp(i), status)
        call gpr_$line (xp(i), yp(i), status)
 10   continue
      call gpr_$set_draw_value (8, status)
c
c    draw the new dots
c
      do 20 i = 1, 20
        xoff = xcrd(i)
        yoff = ycrd(i)      
        zoff = -z
        prx = xoff * p(1, 1) + zoff * p(3, 1)
        pry = yoff 
        prz = xoff * p(1, 3) + zoff * p(3, 3)
        if (pry .lt. 5.0) pry = 5.0
        xp(i) = 400 + prx / pry * 350
        yp(i) = 425 - prz / pry * 350
        call gpr_$move (xp(i), yp(i), status)
        call gpr_$line (xp(i), yp(i), status)
 20   continue
      return
      end





      subroutine stwar_draw_towers (z, p, num)
c
c     STWAR_DRAW_TOWERS draws the orange towers for the
c     tower phase. 
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*2 xp(10), yp(10), zp(10)
      integer*4 status, num
      real z, p(3, 3), prx, pry, prz, xoff, yoff, zoff
      save xp, yp, zp
      data xp / -15, -20, -35, 0, 35, 20, 15, 0, 0, 0/
      data yp / 0, 0, 0, -35, 0, 0, 0, -15, -20, -35/
      data zp / 230, 60, 0, 0, 0, 60, 230, 230, 60, 0/
c
c    erase the towers drawn last pass
c
      do 10 i = 1, num
        if (type(i) .eq. 1) then
          if (last(i)) then
            call gpr_$set_draw_value (15, status)
            call gpr_$move (poly_x(8, i), poly_y(8, i), status)
            call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(10),
     &                          status)
          end if
c
c    draw the new towers if seen
c
          if (seen(i)) then
            do 20 j = 1, 10
              xoff = xp(j) + obx(i)
              yoff = yp(j) + oby(i)      
              zoff = zp(j) - z
              prx = xoff * p(1, 1) + zoff * p(3, 1)
              pry = yoff 
              prz = xoff * p(1, 3) + zoff * p(3, 3)
              if (pry .lt. 15.0) pry = 15.0
              poly_x(j, i) = 400 + prx / pry * 350
              poly_y(j, i) = 425 - prz / pry * 350
 20         continue
            call gpr_$set_draw_value (11, status)
            call gpr_$move (poly_x(8, i), poly_y(8, i), status)
            call gpr_$polyline (poly_x(1, i), poly_y(1, i), int2(10),
     &                          status)
            last(i) = .true.
          else
            last(i) = .false.
          end if
        end if
 10   continue
      return
      end





