      subroutine stwar_screen_init (bitmap_desc, font)
c
c    *******************************************************************
c    *****                                                         *****
c    *****                 STAR WARS VERSION 1.1                   *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        8/87                             *****
c    *****                                                         *****
c    *****               Lunchtime Software Guild                  *****
c    *****        Massachussetts Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c                                                                       
c     STWAR_SCREEN_INIT initializes the GPR package, and draws the
c     static portion of the display panel.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 size(2), key_set(16), font(3), pt(2), window(2, 2)
      integer*2 config
      integer*4 bitmap_desc, status, value(16)
      character text*30, answer*1
c
c    data for key sets and window sizes
c
      data size / 2*1024/
      data key_set / 16 * 16#ffff/
      data pt / 400, 425/
      data value /        0,   2763306,  5592405,  8355711, 11184810, 
     &             13948116,  16777215, 16711700,    65280,  9869055,     
     &              5046271,  16750848, 16724889, 16777000,    53760,
     &                    0/

c    Key to colors:
c
c      0 - Black
c      1 - 6 Fading White (dim to brite)
c      7 - Red
c      8 - Green
c      9 - Blue
c     10 - Aqua
c     11 - Orange                              
c     12 - Purple
c     13 - Yellow
c     14 - Faded Green
c     15 - Black (remapped to grey during a shield loss)
c
c    init screen in borrow mode
c
      call gpr_$inq_config (config, status)
      if (config .lt. 2 .or. config .ge. 12) then
        print*,'Star Wars must be played on a color node!'
c       stop
      end if
      call gpr_$init (gpr_$borrow, int2(1), size, int2(3), bitmap_desc,
     &                status)
      call gpr_$set_color_map (0, int2(16), value, status)
c
c    load all necessary fonts
c
      call gpr_$load_font_file ('/sys/dm/fonts/f9x15', int2(19),
     &                          font(1), status)
      call gpr_$load_font_file ('//alchemy/usr/local/src/games/stwar/fon
     1ts.dir/f20x30', int2(16), font(2), status)
      call gpr_$load_font_file ('//alchemy/usr/local/src/games/stwar/fon
     1ts.dir/f67x100', int2(17), font(3), status)

c
c    set up text parameters and fill values
c
      call gpr_$set_text_path (gpr_$down, status)
      call gpr_$set_text_background_value (0, status)
      call gpr_$set_fill_value (0, status)         
c
c    enable mouse events
c
      call gpr_$enable_input (gpr_$buttons, key_set, status)
c
c    set the cursor to the screen center
c
      call gpr_$set_cursor_position (pt ,status)
c
c    insert text
c
      call gpr_$set_text_value (8, status)
      call gpr_$set_text_font (font(3), status)
      text = 'STAR@WARS'
      call gpr_$move (int2(830), int2(75), status)
      call gpr_$text (text, int2(9), status)      
      call gpr_$set_text_font (font(1), status)
      text = '1987 JSR'
      call gpr_$move (int2(810), int2(75), status)
      call gpr_$text (text, int2(8), status)      
      call gpr_$set_text_value (9, status)
      call gpr_$set_text_path (gpr_$right, status)      
      text = 'SCORE'
      call gpr_$move (int2(61), int2(45), status)
      call gpr_$text (text, int2(5), status)
      if (status .ne. 0) print*, 'text'
      text = 'WAVE'
      call gpr_$move (int2(708), int2(45), status)
      call gpr_$text (text, int2(4), status)
      text = 'SHIELD'
      call gpr_$move (int2(368), int2(45), status)
      call gpr_$text (text, int2(6), status)
c
c    set up clipping window
c
      window(1, 1) = 50
      window(2, 1) = 100
      window(1, 2) = 700
      window(2, 2) = 650
      call gpr_$set_fill_value (15, status)
      call gpr_$rectangle (window, status)
      call gpr_$set_fill_value (0, status)
      call gpr_$set_clip_window (window, status)            
      call gpr_$set_clipping_active (.true., status)
      return
      end




      subroutine stwar_update_shields (shield, font)
c
c     STWAR_UPDATE_SHIELDS refreshes the shields remaining graphic
c     and writes shields gone when there are zero shields remaining.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 font(3), cpos(2)
      integer*2 x(7, 9), y(7, 9), num(9), x_move(9), y_move(9)
      integer*4 diff, status, shield
      character text*12
      save x, y, num, x_move, y_move, left
      data left / 0/
      data num / 7, 3, 3, 3, 3, 3, 3, 3, 3/
      data x / 380, 380, 400, 400, 420, 420, 400, 440, 440, 420, 4 * 0,
     &         360, 360, 380, 4 * 0, 460, 460, 440, 4 * 0, 340, 340,
     &         360, 4 * 0, 480, 480, 460, 4 * 0, 320, 320, 340, 4 * 0,
     &         500, 500, 480, 4 * 0, 300, 300, 320, 4 * 0/
      data y / 50, 60, 56, 50, 50, 60, 56, 50, 64, 60, 4 * 0, 50, 64, 
     &         60, 4 * 0, 50, 68, 64, 4 * 0, 50, 68, 64, 4 * 0, 50,
     &         72, 68, 4 * 0, 50, 72, 68, 4 * 0, 50, 76, 72, 4 * 0, 
     &         50, 76, 72, 4 * 0/
      data x_move / 400, 420, 380, 440, 360, 460, 340, 480, 320/
      data y_move / 9 * 50/

c
c    determine whether to add or subtract shields and how many
c
      diff = shield - left
      if (diff .eq. 0) then
        return
      else if (diff .lt. 0) then
        call gpr_$set_draw_value (0, status)
      else
        call gpr_$set_draw_value (7, status)         
        if (left .eq. 0) then
          text = 'SHIELD GONE'
          call gpr_$set_text_value (0, status)
          call gpr_$set_text_font (font(2), status)
          call gpr_$move (int2(285), int2(90), status)
          call gpr_$text (text, int2(11), status)
          call gpr_$set_text_font (font(1), status)
        end if
      end if
c
c    draw or erase shield bar elements
c
      call gpr_$set_text_value (6, status)
      if (diff. lt. 0) then
        do 10 i = left, shield + 1, -1
          call gpr_$move (x_move(i), y_move(i), status)
          call gpr_$polyline (x(1, i), y(1, i), num(i), status)
 10     continue
        if (shield .eq. 0) then
          text = 'SHIELD GONE'
          call gpr_$set_text_font (font(2), status)
          call gpr_$move (int2(285), int2(90), status)
          call gpr_$text (text, int2(11), status)
          call gpr_$set_text_font (font(1), status)
        else
          write (text, '(i1)') shield
          call gpr_$move (int2(395), int2(75), status)
          call gpr_$text (text, int2(1), status)
        end if
      else
        do 20 i = left + 1, shield, 1
          call gpr_$move (x_move(i), y_move(i), status)
          call gpr_$polyline (x(1, i), y(1, i), num(i), status)
 20     continue
        write (text, '(i1)') shield
        call gpr_$move (int2(395), int2(75), status)
        call gpr_$text (text, int2(1), status)
      end if
      left = shield
      return
      end

        



      subroutine stwar_update_score (score, score_inc, scored)
c
c     STWAR_UPDATE_SCORE displays the new score and the scoring
c     increment just received, which is then faded out. Will
c     erase the score increment if a 0 is entered for it.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*4 score, score_inc, pass, status, value
      character text*8
      logical scored
      save pass, text
      data pass / 19/
c
c    if scored, then reset pass, write score and score increment
c    and put false in scored.
c
      if (scored) then
        pass = 0 
        scored = .false.
        write (text, '(i8)') score
        call gpr_$set_text_value (6, status)
        call gpr_$move (int2(27), int2(70), status)
        call gpr_$text (text, int2(8), status)
        write (text, '(''+'', i7)') score_inc
        call gpr_$set_text_value (6, status)
        call gpr_$move (int2(27), int2(90), status)
        call gpr_$text (text, int2(8), status)
      else
        pass = pass + 1
        i = mod(pass, 3)
        if (pass .le. 18 .and. i. eq. 0) then
          value = (18 - pass) / 3
          call gpr_$set_text_value (value, status)
          call gpr_$move (int2(27), int2(90), status)
          call gpr_$text (text, int2(8), status)
        end if
      end if
      return
      end
        




      subroutine stwar_draw_x_hairs (position)
c
c     STWAR_DRAW_X_HAIRS draws the targeting - navigiation
c     cross-hairs centered on the point given by position.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 position(2), x(4, 4), y(4, 4), poly_x(4, 4)
      integer*2 poly_y(4, 4)
      integer*4 status
      save x, y, poly_x, poly_y
      data x, y / 32 * 0/
      data poly_x / 6, 4, 28, 0, 56, 58, 35, 62, 0, 6, 4, 28,
     &              62, 56, 58, 35/
      data poly_y / 6, 0, 17, 8, 6, 0, 17, 8, 29, 31, 37, 21, 
     &              29, 31, 37, 21/
c
c    erase the old cross-hairs
c
      call gpr_$set_draw_value (15, status)
      do 10 i = 1, 4
        call gpr_$move (x(4, i), y(4, i), status)
        call gpr_$polyline (x(1, i), y(1, i), int2(4), status)
 10   continue
c
c    create and draw the new pair
c
      do 20 i = 1, 4
        do 30 j = 1, 4
          x(j, i) = poly_x(j, i) + position(1) - 31
          y(j, i) = poly_y(j, i) + position(2) - 19
 30     continue
 20   continue
      call gpr_$set_draw_value (9, status)
      do 40 i = 1, 4
        call gpr_$move (x(4, i), y(4, i), status)
        call gpr_$polyline (x(1, i), y(1, i), int2(4), status)
 40   continue
      return
      end




      subroutine stwar_draw_phasers (position, fire, inc, shoot)
c
c     STWAR_DRAW_PHASERS draws the players phaser fire
c     Should be called regardless of whether fire is true or not
c     as it needs to erase itself. 
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 position(2), x(4), y(4)
      integer*4 status, counter, inc
      logical fire, shoot, left, last, draw, fired
      save left, x, y, last, draw, counter, fired
      data counter / 6/
      data last, left, draw, fired / 4 * .false./
c
c    draw the phaser fire
c
      if (last) then
        call gpr_$set_draw_value (15, status)
        call gpr_$multiline (x, y, int2(4), status)
      end if
      if (fire) then
        counter = counter + 1
        if (counter .ge. 121) counter = 1
        if (.not. fired) counter = (counter - 1) / inc * inc + inc
        if (mod(counter, inc) .eq. 0) then
          x(2) = position(1)
          x(4) = position(1)
          y(1) = 600
          y(2) = position(2)
          y(3) = 750
          y(4) = position(2)
          if (left) then
            x(1) = 50
            x(3) = 125
          else
            x(1) = 750
            x(3) = 675
          end if
          call gpr_$set_draw_value (9, status)
          call gpr_$multiline (x, y, int2(4), status)
          last = .true.
          left = .not. left
          shoot = .true.
        else
          last = .false.
          shoot = .false.
        end if             
        fired = .true.
      else
        shoot = .false.
        last = .false.
        fired = .false.
      end if
      return
      end       





      subroutine stwar_draw_photons (zp, p, center, radius, refresh)
c
c     STWAR_DRAW_PHOTONS draws the computer's photons (max of 10)
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 xpt(14, 10), ypt(14, 10), x(14), y(14), z(14)
      integer*4 radius(10), status, color(7), index(13)
      integer*4 center(2, 10), list(10), num_list
      real xcrd(10), ycrd(10), zcrd(10), zp, p(3, 3)
      real xoff, yoff, zoff, prx, pry, prz, r(3, 3), c(3, 3)
      real b(3, 3), dr(3, 3), dx, dy, dz, phvel(3, 10)
      logical seen(10), refresh
      common / phot$/ xcrd, ycrd, zcrd, phvel, seen
      save xpt, ypt, x, y, z, color, index, r, dr
      save list, num_list
      data list, num_list / 11 * 0/
      data x / 15, -15, 0, 0, 0, 0, -9, 9, 9, -9, -9, 9, -9, 9/
      data y / 0, 0, 15, -15, 0, 0, -9, 9, 9, -9, 9, -9, 9, -9/
      data z / 0, 0, 0, 0, 15, -15, 9, -9, 9, -9, 9, -9, -9, 9/
      data color / 6, 10, 6, 7, 6, 12, 7/
      data index / 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7/
      data r / 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/
      data dr /     0.9924033, 7.9259750E-02, -9.4093890E-02,
     &         -8.6827580E-02,     0.9930655, -7.9259750E-02,
     &          8.7159270E-02, 8.6827580E-02,      0.9924033/
c
c    update the photon rotation matrix (r)
c
      do 10 k = 1, 3
        do 20 i = 1, 3
          c(i, k) = 0.0
          do 30 j = 1, 3
            c(i, k) = c(i, k) + dr(i, j) * r(j, k)
 30       continue
 20     continue
 10   continue                             
      do 40 k = 1, 3
        do 50 i = 1, 3
          b(i, k) = 0.0
          r(i, k) = c(i, k)
          do 60 j = 1, 3
            b(i, k) = b(i, k) + c(j, i) * p(j, k)
 60       continue
 50     continue
 40   continue                             
c
c    erase the photons seen last turn
c
      call gpr_$set_draw_value (15, status)
      do 70 j = 1, num_list
        i = list(j)
        call gpr_$multiline (xpt(1, i), ypt(1, i), int2(14), status)
 70   continue
      num_list = 0
      do 75 i = 1, 10
c
c    draw the new photons if seen
c
        if (seen(i)) then
          num_list = num_list + 1
          list(num_list) = i
          xoff = -xcrd(i)
          yoff = -ycrd(i)      
          zoff = zp - zcrd(i)
          dx = xoff * r(1, 1) + yoff * r(2, 1) + zoff * r(3, 1)
          dy = xoff * r(1, 2) + yoff * r(2, 2) + zoff * r(3, 2)
          dz = xoff * r(1, 3) + yoff * r(2, 3) + zoff * r(3, 3)
          do 90 j = 1, 14
            xoff = x(j) - dx
            yoff = y(j) - dy
            zoff = z(j) - dz
            prx = xoff * b(1, 1) + yoff * b(2, 1) + zoff * b(3, 1)
            pry = xoff * b(1, 2) + yoff * b(2, 2) + zoff * b(3, 2)
            prz = xoff * b(1, 3) + yoff * b(2, 3) + zoff * b(3, 3)
            if (pry .lt. 10.0) pry = 10.0
            xpt(j, i) = 400 + prx / pry * 350
            ypt(j, i) = 425 - prz / pry * 350
 90       continue          
          prx = -(dx * b(1, 1) + dy * b(2, 1) + dz * b(3, 1))
          pry = -(dx * b(1, 2) + dy * b(2, 2) + dz * b(3, 2))
          prz = -(dx * b(1, 3) + dy * b(2, 3) + dz * b(3, 3))
          if (pry .lt. 10.0) pry = 10.0
          radius(i) = nint(4200.0 / pry)
          center(1, i) = 400 + prx / pry * 350
          center(2, i) = 425 - prz / pry * 350
        end if
 75   continue
      do 100 j = 1, 13, 2
        k = j + 1
        l = index(j)
        call gpr_$set_draw_value (color(l), status)            
        do 110 m = 1, num_list
          i = list(m)
          call gpr_$move (xpt(j, i), ypt(j, i), status)
          call gpr_$line (xpt(k, i), ypt(k, i), status)
110     continue
100   continue
      if (refresh) then
        do 120 i = 1, 3
          do 130 j = 1, 3
            r(j, i) = 0.0
130       continue
120     continue
        r(1, 1) = 1.0
        r(2, 2) = 1.0
        r(3, 3) = 1.0
      end if
      return
      end



      subroutine stwar_scores (score, font)
c
c     STWAR_SCORES displays the top ten scores at the end of the game.
c     If the player has placed into the top ten it retrieves his/her
c     name and adds it to the list.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include '/sys/ins/kbd.ins.ftn'
% include '/sys/ins/time.ins.ftn'
c
      integer*2 font(3), clock(3), y, key_set(16), cpos(2), event_type
      integer*2 decoded_clock(6), font_id, rectangle(2, 2), box(2, 2)
      integer*4 score, status, position, top_score(10)
      character top_name(10)*3, key*1, top10_file*80, text*80, name*4
      logical top_ten, event
      data clock / 0, 12, 0/
      data key_set / 16 * 16#ffff/
      data top10_file / '/usr/local/lib/stwar_top10'/
      data rectangle / 255, 545, 300, 50/
      data box / 270, 0, 100, 20/
c
c    load the 'game over' font
c
      call gpr_$set_color_map (15, int2(1), 0, status)
      call gpr_$set_fill_value (15, status)
      call gpr_$set_text_value (7, status)
      call gpr_$set_text_background_value (-1, status)
      call gpr_$set_text_font (font(3), status)
      call gpr_$move (int2(250), int2(400), status)
      text = 'GAME'
      call gpr_$text (text, int2(4), status)
      call gpr_$move (int2(250), int2(550), status)
      text = 'OVER'
      call gpr_$text (text, int2(4), status)
c
c    load the top 10 scores font and read the top 10 file
c
      open (unit = 1, file = top10_file)
 10   continue
      do 20 i = 1, 10
        read (1,'(a3, i13)',end=999,err=999) top_name(i), top_score(i)
 20   continue
      rewind (1)
      top_ten = .false.
      i = 10
      position = 11
 30   continue
      if (score .gt. top_score(i)) then
        position = i
        top_ten = .true.
      end if
      i = i - 1
      if (i .gt. 0) goto 30      
c
c    pause for a bit
c
      call time_$wait (time_$relative, clock, status)
      call gpr_$disable_input (gpr_$buttons, status)
      call gpr_$enable_input (gpr_$keystroke, key_set, status) 
      call gpr_$set_clipping_active (.true., status)
      call gpr_$clear (15, status)      
      call gpr_$load_font_file('/sys/dm/fonts/times-bold24',
     &                         int2(26), font_id, status)      
      call gpr_$set_text_font (font_id, status)
      call gpr_$set_text_value (9, status)       
      call cal_$decode_local_time (decoded_clock)
      call gpr_$disable_input (gpr_$buttons, status)
c
c    branch here if score is a top ten score
c
      if (top_ten) then
        write (text, 40) decoded_clock(2), decoded_clock(3),
     &                   decoded_clock(1)
 40     format (' Top Ten Scores as of ',i2,'/',i2,'/',i4,':')
        call gpr_$move (int2(200), int2(250), status)
        call gpr_$text (text, int2(33), status)
        write (text, '(''     Player            Score'')')
        call gpr_$move (int2(245), int2(290), status)
        call gpr_$text (text, int2(28), status)
        call gpr_$set_text_value (11, status)
        do 50 i = 1, position - 1
          write (text, '(6x, a3)') top_name(i)
          text_y = 310 + i * 22
          call gpr_$move (int2(245), int2(text_y), status)
          call gpr_$text (text, int2(9), status)
          text(1:28) = '                         '
          write (text, '(15x, i13)') top_score(i)
          call gpr_$inq_text_extent (text, int2(28), cpos, status)
          xoff = cpos(1) - 260
          call gpr_$move (int2(245 - xoff), int2(text_y), status)
          call gpr_$text (text, int2(28), status)
 50     continue
        write (text, '(6x, a3)') '   '
        text_y = 310 + position * 22
        call gpr_$move (int2(245), int2(text_y), status)
        call gpr_$text (text, int2(9), status)
        text(1:28) = '                         '
        write (text, '(15x, i13)') score
        call gpr_$inq_text_extent (text, int2(28), cpos, status)
        xoff = cpos(1) - 260
        call gpr_$move (int2(245 - xoff), int2(text_y), status)
        call gpr_$text (text, int2(28), status)
        do 60 i = position, 9
          write (text, '(6x, a3)') top_name(i)
          text_y = 330 + i * 22
          call gpr_$move (int2(245), int2(text_y), status)
          call gpr_$text (text, int2(9), status)
          text(1:25) = '                         '
          write (text, '(15x, i13)') top_score(i)
          call gpr_$inq_text_extent (text, int2(28), cpos, status)
          xoff = cpos(1) - 260
          call gpr_$move (int2(245 - xoff), int2(text_y), status)
          call gpr_$text (text, int2(28), status)
 60     continue                     
        call gpr_$move (int2(275), int2(570), status)
        call gpr_$set_text_value (9, status)
        call gpr_$text (' Enter your initials:', int2(21), status)        
        name = '   '
        i = 1
 70     continue
          event = gpr_$event_wait (event_type, key, cpos, status)          
          if (.not. event .or. status .ne. 0) goto 70
          j = ichar(key)
          if (j .ge. 65 .and. j .le. 90) then
            name(i:i) = key
            i = i + 1
          else if (j .ge. 97 .and. j .le. 122) then
            name(i:i) = char(j - 32)
            i = i + 1
          else if (key .eq. kbd_$bs) then
            i = i - 1
            name(i:i) = ' '
          else if (key .eq. kbd_$cr) then
            goto 80
          end if
          text_y = 310 + position * 22
          text = ' '
          text(7:9) = name
          box(2, 1) = 310 + position * 22 - 17
          call gpr_$rectangle (box, status)
          call gpr_$move (int2(245), int2(text_y), status)
          call gpr_$set_text_value (11, status)
          call gpr_$text (text, int2(12), status)
          i = min(i, 4)
          i = max(i, 1)
          goto 70
 80     continue
        call gpr_$rectangle (rectangle, status)
c
c    rewrite the top scores file and quit
c
        do 90 i = 1, position - 1
          write (1, '(a3, i13)') top_name(i), top_score(i),
 90     continue
        write (1, '(a3, i13)') name, score
        do 100 i = position, 9
          write (1, '(a3, i13)') top_name(i), top_score(i),
100     continue
        rewind(1)
        do 110 i = 1, 10
          read (1, '(a3, i13)') top_name(i), top_score(i),
110     continue
      else
        write (text, 40) decoded_clock(2), decoded_clock(3),
     &                   decoded_clock(1)
        call gpr_$move (int2(200), int2(245), status)
        call gpr_$text (text, int2(33), status)
        write (text, '(''     Player            Score'')')
        call gpr_$move (int2(245), int2(290), status)
        call gpr_$text (text, int2(28), status)
        call gpr_$set_text_value (11, status)       
        do 120 i = 1, position - 1
          write (text, '(6x, a3)') top_name(i)
          text_y = 310 + i * 22
          call gpr_$move (int2(245), int2(text_y), status)
          call gpr_$text (text, int2(9), status)
          text(1:28) = '                         '
          write (text, '(15x, i13)') top_score(i)
          call gpr_$inq_text_extent (text, int2(28), cpos, status)
          xoff = cpos(1) - 260
          call gpr_$move (int2(245 - xoff), int2(text_y), status)
          call gpr_$text (text, int2(28), status)
120     continue
      end if
      call gpr_$move (int2(275), int2(570), status)
      call gpr_$set_text_value (9, status)
      call gpr_$text (' Hit space bar to exit', int2(22), status)        
130   continue
      event = gpr_$event_wait (event_type, key, cpos, status)          
      if (.not. event .or. key .ne. ' ') goto 130
      call gpr_$terminate (.false., status)
      close (1)
      stop
999   continue
c
c    create a new top 10 file
c
      rewind (1)
      do 1000 i = 1, 10
        write (1, '(a3, i13)') 'XYZ', 0
1000  continue
      rewind (1)
      goto 10
      end






      subroutine stwar_pick_wave (wave, bonus, font)
c
c     STWAR_PICK_WAVE allows the player to choose a starting
c     wave.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'
c
      integer*2 font(3), position(2), event_type, origin(2), cur_op(8)
      integer*2 timer(3)
      integer*4 status, wave, ix, iz, passes, bonus, cursor_bitmap
      integer*4 inc
      real x(3), y(3), r2
      double precision elapsed, duration, turn
      logical event, active, fire, moved, shoot
      character key*1, text*80
      data x / 180, 400, 620/
      data y / 320, 500, 320/
      data r2 / 4900/
c
c    init graphics
c
      inc = 2
      call gpr_$set_text_font (font(1), status)
      call gpr_$set_clipping_active (.true., status)
c
c    get the current cursor position and any key events
c
      i = 1
 10   continue
      i = i + 1
      passes = 0
      call gpr_$inq_cursor (cursor_bitmap, cur_op, active, position,
     &                      origin , status)
 20   continue
        if (passes .ge. 5) goto 30
          passes = passes + 1
          event = gpr_$cond_event_wait (event_type, key, position,
     &                                  status)
          if (event .and. event_type .eq. gpr_$buttons) then
            if (key .eq. 'a') then
              fire = .true.
            else if (key .eq. 'A') then
              fire = .false.
            else if (key .eq. 'b') then
              position(1) = 400
              position(2) = 425
              call gpr_$set_cursor_position (position, status)
            else if (key .eq. 'c') then
              call pause (font)
            end if
          end if
        goto 20
 30   continue
c
c    limit x and z positions and cursor location (no clipping)
c
      ix = position(1) - 400.0
      iz = position(2) - 425.0
      moved = .false.                               
      if (abs(ix) .gt. 305) then
        position(1) = 400 + sign(305, ix)
        moved = .true.
      end if
      if (abs(iz) .gt. 305) then
        position(2) = 425 + sign(305, iz)
        moved = .true.
      end if      
      if (moved) then
        call gpr_$set_cursor_position (position, status)
      end if
c
c    draw screen objects
c
      call gpr_$set_text_value (9, status) 
      text = 'CHOOSE A DIFFICULTY LEVEL'
      call gpr_$move (int2(265), int2(150), status)
      call gpr_$text (text, int2(25), status)
      text = ' BY FIRING AT DEATH STAR'
      call gpr_$move (int2(265), int2(175), status)
      call gpr_$text (text, int2(24), status)
      text = 'BONUS POINTS AWARDED UPON COMPLETION OF WAVE'
      call gpr_$move (int2(165), int2(670), status)
      call gpr_$text (text, int2(44), status)
      text = 'EASY'
      call gpr_$move (int2(160), int2(233), status)
      call gpr_$text (text, int2(4), status)
      text = 'MODERATE'
      call gpr_$move (int2(360), int2(413), status)
      call gpr_$text (text, int2(8), status)
      text = 'HARD'
      call gpr_$move (int2(600), int2(233), status)
      call gpr_$text (text, int2(4), status)
      call gpr_$set_text_value (6, status) 
      text = 'NO BONUS'
      call gpr_$move (int2(140), int2(420), status)
      call gpr_$text (text, int2(8), status)
      write (text, '(i3, '',000'')') start_bonus(2) / 1000
      call gpr_$move (int2(364), int2(600), status)
      call gpr_$text (text, int2(7), status)
      write (text, '(i3, '',000'')') start_bonus(3) / 1000
      call gpr_$move (int2(585), int2(420), status)
      call gpr_$text (text, int2(7), status)
      j = mod(i, 3) + 1
      call stwar_draw_ds_simple (x(j), y(j), j)
      call stwar_draw_x_hairs (position)
c
c    if player is firing, has he/she hit a death star
c
      call stwar_draw_phasers (position, fire, inc, shoot)
      if (shoot) then
        do 50 i = 1, 3
          range = (position(1) - x(i))**2 + (position(2) - y(i))**2
          if (range .lt. r2) then
            wave = start_level(i)
            bonus = start_bonus(i)
            call gpr_$clear (15, status)
            return
          end if                  
 50     continue
      end if
      goto 10
      end

