c    *******************************************************************
c    *****                                                         *****
c    *****                 STAR WARS VERSION 1.1                   *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        8/87                             *****
c    *****                                                         *****
c    *****               Lunchtime Software Guild                  *****
c    *****        Massachussetts Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c
      logical function inside (x, y, n, xp, yp)
c
c     INSIDE determines whether the point (xp, yp) lies inside the region 
c     enclosed by the simply connected polygon given by the n vertices 
c     (x, y).
c
      integer*2 x(20), y(20), xp, yp
      integer*4 n, inter, d1, d2, d3, d4
      real xt, dx, dy
c
c    perform a quick check that the point (xp, yp) lies to the left
c    of at least one line segment.
c
      i = 1
 10   continue
      if (xp .le. x(i)) goto 20
      i = i + 1
      if (i .gt. n) then
        inside = .false.
        return
      end if
      goto 10
 20   continue
      inter = 0
      do 30 i = 1, n
        k = i + 1
        j = i + 2
        if (k .gt. n) k = k - n
        if (j .gt. n) j = j - n
        if (xp .ge. x(i) .or. xp .ge. x(k)) then
          d1 = abs(y(k) - y(i))
          d2 = abs(yp - y(i))
          d3 = abs(yp - y(k))
          d4 = d2 + d3
          if (d1 .eq. d4 .and. d2 .ne. 0) then
            dx = x(k) - x(i)
            dy = y(k) - y(i)
            xt = (yp - y(i)) * (dx / dy) + x(i)
            if (xp .ge. nint(xt)) then
              if (d3 .eq. 0) then
                if ((y(k) - y(i)) * (y(j) - y(k)) .gt. 0) then
                  inter = inter + 1
                end if
              else 
                inter = inter + 1
              end if
            end if
          else if (d1 + d2 .eq. 0) then
            d1 = abs(x(k) - x(i))
            d2 = abs(xp - x(i)) + abs(xp - x(k))
            if (d1 .eq. d2) then
              inside = .true.
              return
            end if
          end if
        end if
 30   continue
      if (mod(inter, 2) .ne. 0) then
        inside = .true.
      else
        inside = .false.
      end if
      return
      end





      function rand (x)
c
c    RAND is a fast pseudo-random number generator, with a unique 
c    sequence of 566927 numbers. X must be between 0 and 1 
c    ((0,1] actually).
c
      integer*4 k, j, m, ix, irand
      real*4 x, rm, rand
      save k, j, m, rm
      data k, j, m, rm / 5701, 3612, 566927, 566927.0/
      ix = int (x * rm)
      irand = mod (j * ix + k, m)
      x = (real (irand) + 0.5) / rm
      rand = x
      return
      end




      subroutine pause (font)
c
c     PAUSE causes the game to pause until any key is struck.
c     
% include '/sys/ins/gpr.ins.ftn'
% include '/sys/ins/kbd.ins.ftn'
c
      integer*2 font(3), cpos(2), event_type
      integer*4 status
      character key*1, text*80
      logical event
c
c    write out text at the bottom of the screen
c
      text = 'GAME SUSPENDED, HIT ANY MOUSE KEY TO CONTINUE.'      
      call gpr_$set_text_font (font(1), status)
      call gpr_$set_text_value (10, status)
      call gpr_$move (int2(150), int2(765), status)
      call gpr_$text (text, int2(46), status)
c
c    wait for a key
c
 10   continue
      event = gpr_$event_wait (event_type, key, cpos, status)          
      if (event .and. key. eq. 'C') goto 10
c
c    erase the message and resume
c
      call gpr_$set_text_value (0, status)
      call gpr_$move (int2(150), int2(765), status)
      call gpr_$text (text, int2(46), status)
      return
      end



      subroutine stwar_photons 
c
c     STWAR_PHOTONS zeros out the photon counters    
c
      real phox(10), phoy(10), phoz(10), phvel(3, 10)
      logical photon(10)
      common / phot$/ phox, phoy, phoz, phvel, photon
      do 10 i = 1, 10
        photon(i) = .false.
 10   continue
      return
      end



      subroutine stwar_find_free (open)
c
c     STWAR_FIND_FREE returns the first open photon slot open = 11 
c     means there are no open slots
c
      integer*4 open
      real phox(10), phoy(10), phoz(10), phvel(3, 10)
      logical photon(10)
      common / phot$/ phox, phoy, phoz, phvel, photon
      i = 1
 10   continue                               
      if (.not. photon(i)) then
        open = i
        return
      end if
      i = i + 1
      if (i .le. 10) goto 10
      open = 11
      return
      end
     




      subroutine stwar_matrix_multiply (a, b, c, op)
c
c     STWAR_MATRIX_MULTIPLY multiplies two (3, 3) matrices.
c
c     Op = 1: C = A B
c          2: C = trans(A) B
c          3: C = A trans(B)
c
      integer op
      real a(3, 3), b(3, 3), c(3, 3) 
c
c    C = A B
c
      if (op .eq. 1) then
        do 10 k = 1, 3
          do 20 i = 1, 3
            c(i, k) = 0.0
            do 30 j = 1, 3
              c(i, k) = c(i, k) + a(i, j) * b(j, k)
 30         continue
 20       continue
 10     continue

      else if (op .eq. 2) then
c
c    C = trans(A) B
c
        do 40 k = 1, 3
          do 50 i = 1, 3
            c(i, k) = 0.0
            do 60 j = 1, 3
              c(i, k) = c(i, k) + a(j, i) * b(j, k)
 60         continue
 50       continue
 40     continue
      else
c
c    C =  A trans(B)
c
        do 70 k = 1, 3
          do 80 i = 1, 3
            c(i, k) = 0.0
            do 90 j = 1, 3
              c(i, k) = c(i, k) + a(i, j) * b(k, j)
 90         continue
 80       continue
 70     continue
      end if
      return
      end




      subroutine stwar_matrix_sub (a, b)
c
c     STWAR_MATRIX_SUB plugs the contents of a into b
c
      real a(3, 3), b(3, 3)
      do 10 i = 1, 3
        do 20 j = 1, 3
          b(i, j) = a(i, j)
 20     continue
 10   continue            
      return
      end

