      PROGRAM SLOGRO
C
C     ****************************************************************
C     *              SLOGRO PROGRAM                                  *
C     ****************************************************************
C
C     THE BASIC CURSOR CONTROL CO-ORDINATES ARE THOSE SUITABLE FOR
C     A HAZELTINE TERMINAL. I.E. X-Y ORDER WHERE X IS THE COLUMN NUMBER
C     FROM 0 TO 79 AND Y IS THE ROW NUMBER FROM 0 TO 23.
C     TOP LEFT IS 0,0           TOP RIGHT IS 79,0
C     BOTTOM LEFT IS 0,23       BOTTOM RIGHT IS 79,23
C
C        0,0-----------> X
C          |
C          |
C          |
C          |
C          V
C          Y
C
C     CODED FROM IDEAS PRESENTED IN SCIENTIFIC AMERICAN COMPUTER
C     RECREATIONS COLUMN, BY A.K. DEWDNEY, SEPT. 1988.
C     MIKE PETERSON, DEPT OF CHEMISTRY, UNIV OF TORONTO, TORONTO, CANADA
C
      implicit integer*4 (a-z)
C
C     In the following statement:
C     MAXPART   - maximum number of paricles allowed.
C     XMAX      - maximum number of columns on the screen.
C     YMAX      - maximum number of rows on the screen.
C     MAXRADIUS - maximum number of radii used for computing the fractal
C                 dimension.
C
      parameter (maxpart=2000, xmax=39, ymax=23, maxradius=20)
C
      integer xcoord(maxpart), ycoord(maxpart), p(maxradius)
C
      real*4 rand, angle, cos, sin, radius, fract, alog, float,
     1 alogpi
C
      logical moved
C
      CHARACTER TEXT*10, label(maxpart)*2, l*2
C
C     CURSOR CONTROL COMMON BLOCK DEFINITIONS.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), DISPWORD, BELL(10)
C
      COMMON /CURCOM/ CURSOR, LCURSOR, ITERM, DISPWORD, JADD
      COMMON /PARAM/ RAND
C
      EQUIVALENCE (BELL(1),CURSOR(1,19)), (LBELL,LCURSOR(19))
C
      DATA BLANK/' '/
C     DATA LFCUT/'UT  '/, LFCVDU/'VDU '/
C
C     OPEN VDU AND ADJUST ITS FCB
C
C     OPEN (UNIT=LFCUT, OPENMODE='U')
C     OPEN (UNIT=LFCVDU, OPENMODE='U')
C     JADD = M:GETFCB(LFCVDU)
C     CALL SETFCB (JADD)
C
C     CHECK FOR TERMINAL TYPE ON INPUT LINE.
C
C     CALL X:TSCAN (1, I, DISP, TEXT)
      ITERM = -1
C     IF (I.NE.1 .OR. DISP(2).NE.2) GO TO 20
C     IF (TEXT(1:1) .EQ. '*') THEN
C        ITERM = 0
C     ELSE IF (TEXT(1:1).GE.'1' .AND. TEXT(1:1).LE.'6') THEN
C        READ (TEXT(1:1),10) ITERM
C  10    FORMAT (I1)
C     END IF
C     GO TO 50
C
   20 WRITE (6,30)
   30 FORMAT (/' Welcome to the Slo Gro Game.'//
     1 ' This is a game of diffusion limited aggregation,'/
     2 ' from Scientific American (Sept. 1988), by A.K. Dewdney.'/
     3 ' For more information about this topic, see'/
     4 ' "Fractal Growth" by L.M. Sander, Scientific American,'/
     5 ' Jan. 1987.')
C
   50 CALL TERMSET (ITERM, JADD, CURSOR, LCURSOR)
C
      rand = 0.0
   60 write (6,70)
   70 format (/' Do you want to start the new particles on the'/
     1 ' circumference of a circle, or at the left edge of the screen?'/
     2 ' '/
     3 ' 1 - circumference of a circle (default).'/
     4 ' 2 - left edge of screen.'/
     5 ' '/
     6 ' Enter your choice: ',$)
      read (5,'(i10)',end=9000) istart
      if (istart .ne. 2) istart = 1
C
C     Set the initial conditions.
C
      xcenter = xmax / 2
      ycenter = ymax / 2
      npart = 1
      xcoord(1) = xcenter
      ycoord(1) = ycenter
      label(1) = '@@'
      iradius = min0 (xcenter, ycenter, xmax-xcenter, ymax-ycenter)
      radius = iradius
      iter = 0
      fract = 0.0
      nomove = 0
      alogpi = alog (3.14159)
C
C     Display the field.
C
  200 call dispfield (xcoord, ycoord, label, npart, iter, fract)
C
C     Add a new particle.
C
  300 npass = 0
      moved = .false.
      iter = iter + 1
      if (iter .eq. 50*(iter/50)) then
         call dispfield (xcoord, ycoord, label, npart, iter, fract)
      else
         call dispiter (iter)
      end if
C
  320 call random (rand)
      if (istart .eq. 1) then
         angle = rand * 2.0 * 3.14159
         x = radius*cos(angle) + xcenter
         y = radius*sin(angle) + ycenter
      else
         x = 2
         y = ymax * rand
      end if
      do 330 i=1,npart
      if (x.eq.xcoord(i) .and. y.eq.ycoord(i)) go to 350
  330 continue
C
C     Use the 100's digit of the iteration number as the label,
C     starting with 1.
C
      i = iter / 100
      i = mod (i+1, 10)
      l(1:1) = char(i+ichar('0'))
      l(2:2) = char(i+ichar('0'))
      go to 390
C
C     Try another position.
C
  350 npass = npass + 1
      if (npass .le. 50) go to 320
      GO TO 7000
C
C     Got some valid coordinates - display the new particle.
C
  390 call display (2*x, y, '*', .false.)
      call delay (1)
C
C     Move the new particle around until it hits the aggregate,
C     or falls off the edge of the screen.
C
  400 call display (2*x, y, ' ', .false.)
      xp1 = x + 1
      xm1 = x - 1
      yp1 = y + 1
      ym1 = y - 1
      do 410 i=1,npart
      if (xp1.eq.xcoord(i) .and. y.eq.ycoord(i)) go to 500
      if (xm1.eq.xcoord(i) .and. y.eq.ycoord(i)) go to 500
      if (x.eq.xcoord(i) .and. yp1.eq.ycoord(i)) go to 500
      if (x.eq.xcoord(i) .and. ym1.eq.ycoord(i)) go to 500
  410 continue
C
C     Find the particle's new position, and move it there.
C
      moved = .true.
      call random (rand)
      if (rand .le. 0.25) then
         x = x + 1
      else if (rand .le. 0.50) then
         x = x - 1
      else if (rand .le. 0.75) then
         y = y + 1
      else
         y = y - 1
      end if
      if (x.lt.0 .or. x.ge.xmax .or. y.lt.0 .or. y.ge.ymax) go to 300
      call display (2*x, y, '*', .false.)
      go to 400
C
C     This particle has found it's friends - leave it there forever.
C
  500 npart = npart + 1
      if (npart .gt. maxpart) then
         call display (0, 22, 'The maximum number of particles has '//
     1    'exceeded.', .true.)
         call display (0, 23, 'We might as well call it quits!'//
     1    '     Enter <CR> to continue: ', .true.)
         read (5,'(a)',end=9000) text
         go to 8000
      end if
      xcoord(npart) = x
      ycoord(npart) = y
      label(npart) = l
      call display (2*x, y, l, .false.)
c
c     Compute the new fractal dimension.
c
      do 520 i=1,iradius-1
      p(i) = 0
  520 continue
c
      do 540 j=1,npart
      dist2 = (xcoord(j)-xcenter)**2 + (ycoord(j)-ycenter)**2
      do 530 i=1,iradius-1
      if (dist2 .le. i*i) p(i) = p(i) + 1
  530 continue
  540 continue
c
      fract = 0.0
      do 550 i=2,iradius-1
      fract = fract + (alog(float(p(i)))-alogpi)/alog(float(i))
  550 continue
      fract = fract / float(iradius-2)
      call dispfract (fract)
      call delay (1)
c
c     Check whether this particle managed to move after being added -
c     if not, the starting locus is getting jammed up, and we should
c     quit.
c
      if (moved) then
         nomove = 0
         go to 300
      end if
      nomove = nomove + 1
      if (nomove .lt. 3) go to 300
c
c     The game has reached a state where new particles can't move -
c     might as well quit.
c
      call display (0, 22, 'The game has reached the point where '//
     1 'new particles do not move much.', .true.)
      call display (0, 23, 'We might as well call it quits!'//
     1 '     Enter <CR> to continue: ', .true.)
      read (5,'(a)',end=9000) text
      go to 8000
C
C     The game has reached a steady state - might as well quit.
C
 7000 call display (0, 22, 'The game has reached the point where '//
     1 'no new particles can be added.', .true.)
      call display (0, 23, 'We might as well call it quits!'//
     1 '     Enter <CR> to continue: ', .true.)
      read (5,'(a)',end=9000) text
C
C     Game's over.
C
 8000 call display (0, 23, 'The game is over -- come back soon !!!',
     1 .true.)
      call delay (2)
      call dispfield (xcoord, ycoord, label, npart, iter, fract)
      call display (0, 0, 'Final pattern', .false.)
      call delay (10)
      call display (0, 23, 'Would you like to have another game now'//
     1 ' (Y or N) ? ', .true.)
      read (5,'(a)',end=9000) text
      if (text.eq.'Y' .or. text.eq.'y') go to 60
      stop
C
 9000 stop
      end
      subroutine dispfield (xcoord, ycoord, label, npart,
     1 iter, fract)
c
c     Subroutine to display the field on the screen.
c
c     Arguments:
c     XCOORD - X coordinates of the particles.
c     YCOORD - Y coordinates of the particles.
c     LABEL  - particle label (CHARACTER*2).
c     NPART  - number of particles.
c     ITER   - iteration number.
c     FRACT  - fractal dimension.
c
      implicit integer*4 (a-z)
c
      integer xcoord(npart), ycoord(npart)
c
      real fract
c
      character label(npart)*2
c
      call clear
      do 100 i=1,npart
      call display (2*xcoord(i), ycoord(i), label(i), .false.)
  100 continue
      if (iter .ne. 0) call dispiter (iter)
      if (fract .ne. 0.0) call dispfract (fract)
      return
      end
      subroutine dispiter (iter)
c
c     Subroutine to display the iteration number on the screen.
c
c     Argument:
c     ITER   - iteration number.
c
      implicit integer*4 (a-z)
c
      call display (0, 23, 'Iteration:', .false.)
      write (6,100) iter
  100 format (i7,$)
      return
      end
      subroutine dispfract (fract)
c
c     Subroutine to display the fractal dimension on the screen.
c
c     Argument:
c     FRACT  - fractal dimension.
c
      implicit integer*4 (a-z)
c
      real fract
c
      call display (50, 23, 'Fractal dimension:', .false.)
      write (6,100) fract
  100 format (f9.4,$)
      return
      end
