
/* RCS Info: $Revision: 1.1 $ on $Date: 89/03/10 10:11:14 $
 *		   $Source: /yew3/faustus/src/scrabble/RCS/util.h,v $
 * Copyright (c) 1986 Wayne A. Christopher, U. C. Berkeley CAD Group
 *
 * Standard definitions.
 */

/*
 * One or more of the following should be defined in the Makefile.
 * You can alternately define them here.
 */
/* #define UNIX */
/* #define MSDOS */
/* #define BSD */

/* vcc has problems with math.h */

#define u3b     0
#define u3b5    0
#define gcos    0
#define gould   0
#define pdp11   0
#define u370    0

#ifndef FILE
#include <stdio.h>
#endif
#ifndef isalpha
#include <ctype.h>
#endif
#ifndef HUGE
#include <math.h>
#endif
#include <strings.h>

#ifdef assert
#undef assert
#endif

#define assert(ex) \
	{if (!(ex)) {\
		fprintf(stderr,"Internal error: file %s, line %d\n",\
			__FILE__, __LINE__);\
		abort();\
	}}

#ifdef UNIX
typedef int bool;
#endif

#define false 0
#define true 1

#define boolname(vv) ((vv) ? "true" : "false")

#define gprof_point(name)       asm("   .globl name"); asm("name:");

#define BSIZE	   512

/* Some standard macros. */

#define eq(a,b)	 (!strcmp((a), (b)))
#define alloc(strname)  ((struct strname *) util_malloc(sizeof(struct strname)))
#define max(i, j)       (((i) > (j)) ? (i) : (j))
#define min(i, j)       (((i) < (j)) ? (i) : (j))
#define badness()	{ fprintf(stderr, \
		"Internal Error: line %d in file %s\n",\
		__LINE__, __FILE__);\
		exit(1); }

#define EXIT_NORMAL	0
#define EXIT_BAD	1

/* Utility things. */

extern char *strsav();
extern char *strstr();
extern char *util_datestring();
extern char *util_malloc();
#ifdef MSDOS
extern char far *util_farmalloc();
#endif
extern char *util_realloc();
extern int util_seconds();
#ifdef UNIX
extern char *util_tildexpand();
#endif

/* Externs from libc */

extern char *getenv();
extern char *mktemp();
extern int errno;
extern char *sys_errlist[];
extern double atof();
#ifdef UNIX
extern long random();
extern void srandom();
#endif
extern long time();
extern void exit();
extern void bcopy();
#ifdef UNIX
extern char *sbrk();
#endif
extern char *getlogin();
extern void free();
extern void perror();
extern void abort();

