
/* RCS Info: $Revision: 1.1 $ on $Date: 89/03/10 10:11:10 $
 *           $Source: /yew3/faustus/src/scrabble/RCS/util.c,v $
 * Copyright (c) 1988 Wayne A. Christopher, U. C. Berkeley CAD Group 
 *	 faustus@cad.berkeley.edu, ucbvax!faustus
 * Permission is granted to modify and re-distribute this code in any manner
 * as long as this notice is preserved.  All standard disclaimers apply.
 *
 */

#include "util.h"
#ifdef UNIX
#include <pwd.h>
#include <sys/types.h>
#ifdef BSD
#include <sys/time.h>
#include <sys/resource.h>
#else /* BSD */
#include <time.h>
#endif /* BSD */

extern char *malloc();
extern char *realloc();
#endif /* UNIX */

#ifdef MSDOS
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <alloc.h>
#endif /* MSDOS */

char *
strsav(str)
	char *str;
{
	char *p;
	
	p = malloc(strlen(str) + 1);
	if (p)
		strcpy(p, str);
	return (p);
}

#ifndef __STDC__
char *
strstr(str, sub)
	char *str, *sub;
{
	char *s, *t;

	while (*str) {
		if (*str == *sub) {
			for (s = sub, t = str; *s && *t; s++, t++)
				if (*s != *t)
					break;
			if (!*s)
				return (str);
		}
		str++;
	}
	return (NULL);
}
#endif

char *
util_datestring()
{
	struct tm *tp;
	static char tbuf[40];
	char *ap;
	int i;
#ifdef BSD
	register char *tzn;
	struct timeval tv;
	struct timezone tz;
#ifndef __hpux
	extern char *timezone();	/* missing from time.h */
#endif
#else
	time_t t;
#endif

#ifdef BSD
	(void) gettimeofday(&tv, &tz);
	tp = localtime((time_t *) &tv.tv_sec);
	tzn = timezone(tz.tz_minuteswest, tp->tm_isdst);
#else
	t = time((time_t *) NULL);
	tp = localtime(&t);
#endif
	ap = asctime(tp);
	sprintf(tbuf, "%.20s", ap);
#ifdef BSD
	if (tzn)
		strcat(tbuf, tzn);
#endif
	strcat(tbuf, ap + 19);
	i = strlen(tbuf);
	tbuf[i - 1] = '\0';
	return (tbuf);
}

#ifdef BSD
int
util_seconds()
{
	struct rusage ruse;

	getrusage(RUSAGE_SELF, &ruse);
	return (ruse.ru_utime.tv_sec);
}
#endif

#ifdef UNIX
char *
util_tildexpand(s)
	char *s;
{
	struct passwd *pw;
	char *n, buf[64];
	int i;

	if (*s != '~') {
		n = malloc(strlen(s) + 1);
		strcpy(n, s);
		return (n);
	}

	for (s++, i = 0; *s != '/'; s++, i++)
		buf[i] = *s;
	buf[i] = '\0';
	if (!i)
		pw = getpwuid(getuid());
	else
		pw = getpwnam(buf);
	if (!pw)
		return (s);
	n = malloc(strlen(s) + strlen(pw->pw_dir) + 1);
	strcpy(n, pw->pw_dir);
	strcat(n, s);
	return (n);
}
#endif

char *
util_malloc(num)
	int num;
{
	char *s;

	s = malloc((unsigned) num);
	if (!s) {
		fprintf(stderr, "malloc: can't allocate %d bytes", num);
		exit(1);
	}
#ifdef BSD
	bzero(s, num);
#else
	(void) memset(s, 0, num);
#endif
	return (s);
}

char *
util_realloc(ptr, num)
	char *ptr;
	int num;
{
	char *s;

	s = realloc(ptr, (unsigned) num);
	if (!s) {
		fprintf(stderr, "realloc: can't allocate %d bytes", num);
		exit(1);
	}
	return (s);
}

#ifdef MSDOS
char far *
util_farmalloc(num)
        unsigned long num;
{
        char far *s;
        char far *t;

        s = (char far *) farmalloc(num);
        if (!s) {
                fprintf(stderr, "malloc: can't allocate %d bytes", num);
                exit(1);
        }
        for (t = s; t < s + num; t++) {
          *t = 0;
        }
        return (s);
}
#endif
