
/* RCS Info: $Revision: 1.1 $ on $Date: 89/03/15 11:17:22 $
 *           $Source: /yew3/faustus/src/scrabble/RCS/user.c,v $
 * Copyright (c) 1989 Wayne A. Christopher, U. C. Berkeley CS Dept
 *	 faustus@renoir.berkeley.edu, ucbvax!faustus
 * Permission is granted to modify and re-distribute this code in any manner
 * as long as this notice is preserved.  All standard disclaimers apply.
 *
 * With a minimum amount of hacking more device descriptions can be
 * added to this file.
 */

#ifdef MSDOS
typedef char bool;
#endif
#include "scrabble.h"

struct device {
#ifdef _STDC_
	void (*init)(board_t *board, player_t *players[], int numplayers);
	void (*message)(char *message);
	char *(*question)(char *message);
	bool (*confirm)(char *message);
	command_t (*command)(board_t *board, player_t *player, move_t *move);
	void (*drawplayer)(player_t *player, int pos, bool up);
	void (*drawsummary)(board_t *board, int turn);
	void (*drawmove)(board_t *board, move_t *move, player_t *player);
#else
	void (*init)();
	void (*message)();
	char *(*question)();
	bool (*confirm)();
	command_t (*command)();
	void (*drawplayer)();
	void (*drawsummary)();
	void (*drawmove)();
#endif
	void (*givehelp)();
	void (*update)();
	void (*cleanup)();
} ;

static struct device tty_device = {
	tty_init,
	tty_message,
	tty_question,
	tty_confirm,
	tty_command,
	tty_drawplayer,
	tty_drawsummary,
	tty_drawmove,
	tty_givehelp,
	tty_update,
	tty_cleanup
} ;

static struct device *dev;

#ifdef _STDC_
void
user_init(devtype_t type, board_t *board, player_t *players[], int numplayers)
#else
void
user_init(type, board, players, numplayers)
devtype_t type;
board_t *board;
player_t *players[];
int numplayers;
#endif
{
	switch (type) {
	    case DEV_TTY:	dev = &tty_device; break;
	    default:		abort();
	}

	(dev->init)(board, players, numplayers);
	return;
}

#ifdef _STDC_
void
user_message(char *message)
#else
void
user_message(message)
char *message;
#endif
{
	(dev->message)(message);
	return;
}

#ifdef _STDC_
char *
user_question(char *message)
#else
char *
user_question(message)
char *message;
#endif
{
	return ((dev->question)(message));
}

#ifdef _STDC_
bool
user_confirm(char *message)
#else
bool
user_confirm(message)
char *message;
#endif
{
	return ((dev->confirm)(message));
}

#ifdef _STDC_
command_t
user_command(board_t *board, player_t *player, move_t *move)
#else
command_t
user_command(board, player, move)
board_t *board;
player_t *player;
move_t *move;
#endif
{
	return ((dev->command)(board, player, move));
}

#ifdef _STDC_
void
user_drawplayer(player_t *player, int pos, bool up)
#else
void
user_drawplayer(player, pos, up)
player_t *player;
int pos;
bool up;
#endif
{
	(dev->drawplayer)(player, pos, up);
	return;
}

#ifdef _STDC_
void
user_drawsummary(board_t *board, int turn)
#else
void
user_drawsummary(board, turn)
board_t *board;
int turn;
#endif
{
	(dev->drawsummary)(board, turn);
	return;
}

#ifdef _STDC_
void
user_drawmove(board_t *board, move_t *move, player_t *player)
#else
void
user_drawmove(board, move, player)
board_t *board;
move_t *move;
player_t *player;
#endif
{
	(dev->drawmove)(board, move, player);
	return;
}

void
user_update()
{
	(dev->update)();
	return;
}

void
user_cleanup()
{
	(dev->cleanup)();
	return;
}

void
user_givehelp()
{
	(dev->givehelp)();
	return;
}

#ifdef notdef

#ifdef _STDC_
bool
readmove(board_t *board, player_t *player, move_t *move)
#else
bool
readmove(board, player, move)
board_t *board;
player_t *player;
move_t *move;
#endif
{
	char buf[BSIZE];
	int x, y, i;
	char dir, word[BSIZE];

	for (;;) {
		printplayer(player, -1, stdout);
		printf("Enter move [ x y dir word ]: ");
		fgets(buf, BSIZE, stdin);
		if (sscanf(buf, "%d %d %c %s", &x, &y, &dir, word) != 4) {
			printf("Invalid command.\n");
			printboard(board, stdout);
			continue;
		}
		move->x = x;
		move->y = y;
		move->horiz = (dir == 'h') ? true : false;
		for (i = 0; i < strlen(word); i++) {
			if (!isalpha(word[i])) {
				printf("Bad word.\n");
				break;
			} else if (isupper(word[i])) {
				word[i] = tolower(word[i]);
			}
		}
		if (word[i])
			continue;

		move->word = strsav(word);
		move->length = strlen(move->word);
		for (i = 0; i < SIZE; i++)
			move->wild[i] = false;

		if (!isaword(word)) {
			printf("I don't think \"%s\" is a word.  Do you? ",
					word);
			fgets(buf, BSIZE, stdin);
			if ((buf[0] != 'y') && (buf[0] != 'Y'))
				continue;
		}
		trymove(move, board, player);

		if (move->points < 0) {
			printf("You can't do that.\n");
			continue;
		}

		return (true);
	}
}

#endif

