
/* RCS Info: $Revision: 1.2 $ on $Date: 89/03/15 11:16:37 $
 *           $Source: /yew3/faustus/src/scrabble/RCS/scrabble.h,v $
 * Copyright (c) 1989 Wayne A. Christopher, U. C. Berkeley CS Dept
 *	 faustus@renoir.berkeley.edu, ucbvax!faustus
 * Permission is granted to modify and re-distribute this code in any manner
 * as long as this notice is preserved.  All standard disclaimers apply.
 *
 */

#include "util.h"

#define AUTHOR		"Wayne Christopher"
#define ADDRESS		"faustus@yew.Berkeley.EDU"
#define VERSION		"1.0"

#define SIZE		15
#define WORK_SIZE	7
#define POOL_SIZE	100
#define ALL_BONUS	50
#define NUM_LETTERS	27	/* Plus wildcard. */
#define MAX_PLAYERS	4

#ifndef DICT_FILE
#define DICT_FILE	"/usr/dict/words"
#endif

#ifdef MSDOS
#define HASH_SIZE	1003
#else
#define HASH_SIZE	5003
#endif
#define MAX_LENGTH	15
#define WILD		'*'
#define ZIP		' '

typedef struct board_s board_t;
typedef struct player_s player_t;
typedef struct move_s move_t;
typedef struct dict_s dict_t;
typedef struct word_s word_t;
typedef enum bonus_e bonus_t;
typedef enum command_e command_t;
typedef enum devtype_e devtype_t;

enum bonus_e {
	NONE		= 0,
	DOUBLE_LETTER	= 1,
	TRIPLE_LETTER	= 2,
	DOUBLE_WORD	= 3,
	TRIPLE_WORD	= 4
} ;

enum command_e {
	NOTHING		= 0,
	MOVE		= 1,
	TRADEIN		= 2,
	SAVE		= 3,
	RESTORE		= 4,
	HELP		= 5,
	ADVICE		= 6,
	QUIT		= 7
} ;

enum devtype_e {
	DEV_TTY		= 0,
	DEV_X10		= 1,
	DEV_X11		= 2
} ;

struct board_s {
	char letters[SIZE][SIZE];
	bonus_t bonus[SIZE][SIZE];
	char pool[POOL_SIZE];
	int numleft;
	bool virgin;
} ;

struct player_s {
	char working[WORK_SIZE];
	int numworking;
	int score;
	bool machine;
	char *name;
} ;

struct move_s {
	char *word;
	bool wild[SIZE];
	int x, y;
	int length;
	bool horiz;
	int points;
} ;

/* The dictionary structure is a hash table, where the hash function is
 * calculated from the number of times each letter appears in the word.
 */

struct dict_s {
	word_t *buckets[MAX_LENGTH][HASH_SIZE];
	int size;
} ;

struct word_s {
	char *word;
	int length;
	word_t *next;
	word_t *next_set;
} ;

#define boardletter(board, x, y, hf, pos)			\
		((hf) ? (board)->letters[(x) + (pos)][(y)] :	\
		(board)->letters[(x)][(y) + (pos)])
#define boardbonus(board, x, y, hf, pos)			\
		((hf) ? (board)->bonus[(x) + (pos)][(y)] :	\
		(board)->bonus[(x)][(y) + (pos)])
#define something(c)	((c) != ZIP)
#define letterpoints(c)	((iswild(c) || ((c) == WILD)) ? 0 :	\
		letterpoint_values[(c) - 'a'])
#define iswild(c)	(isupper(c))
#define maketame(c)	((c) - 'A' + 'a')
#define makewild(c)	((c) - 'a' + 'A')

/* scrabble.c */

#ifdef _STDC_
extern int main(int ac, char **av);
#else
extern int main();
#endif
extern dict_t *dictionaries;
extern bool debug;
extern bool userpick;

/* board.c */

extern board_t *makeboard();
#ifdef _STDC_
extern void boardmove(board_t *board, move_t *move);
extern char pickletter(board_t *board);
#else
extern void boardmove();
extern char pickletter();
#endif
extern int letterpoint_values[];

/* extern void printboard(board_t *board, FILE *fp); */

/* move.c */

#ifdef _STDC_
extern void bestmove(board_t *board, player_t *player, move_t *best);
extern void trymove(move_t *move, board_t *board, player_t *player, bool check);
#else
extern void bestmove();
extern void trymove();
#endif

/* extern void printmove(int which, move_t *move, FILE *fp); */

/* dict.c */

#ifdef _STDC_
extern void readdict(char *file);
extern word_t *getpossibles(char *req, int numreq, char *opt, int numopt,
		int len);
extern bool isaword(char *poss);
extern void addword(char *word);
extern void remword(char *word);
extern void writedict(char *file);
#else
extern void readdict();
extern word_t *getpossibles();
extern bool isaword();
extern void addword();
extern void remword();
extern void writedict();
#endif

/* player.c */

#ifdef _STDC_
extern player_t *makeplayer(board_t *board, int num);
extern void playermove(board_t *board, player_t *player, move_t *move);
#else
extern player_t *makeplayer();
extern void playermove();
#endif

/* extern void printplayer(player_t *player, int num, FILE *fp); */

/* savegame.c */

#ifdef _STDC_
extern board_t *restoregame(FILE *fp, int *nump, int *whosup, int *turn);
extern player_t *restoreplayer(FILE *fp);
extern void savegame(FILE *fp, int nump, int whosup, int turn);
extern void saveplayer(FILE *fp);
#else
extern board_t *restoregame();
extern player_t *restoreplayer();
extern void savegame();
extern void saveplayer();
#endif

/* user.c */

#ifdef _STDC_
extern void user_init(devtype_t type, board_t *board, player_t *players[],
		int numplayers);
extern void user_message(char *message);
extern char *user_question(char *message);
extern bool user_confirm(char *message);
extern command_t user_command(board_t *board, player_t *player, move_t *move);
extern void user_drawplayer(player_t *player, int pos, bool up);
extern void user_drawsummary(board_t *board, int turn);
extern void user_drawmove(board_t *board, move_t *move, player_t *player);
#else
extern void user_init();
extern void user_message();
extern char *user_question();
extern bool user_confirm();
extern command_t user_command();
extern void user_drawplayer();
extern void user_drawsummary();
extern void user_drawmove();
#endif
extern void user_givehelp();
extern void user_update();
extern void user_cleanup();

/* extern bool readmove(board_t *board, player_t *player, move_t *move); */

/* tty.c */

#ifdef _STDC_
extern void tty_init(board_t *board, player_t *players[], int numplayers);
extern void tty_message(char *message);
extern char *tty_question(char *message);
extern bool tty_confirm(char *message);
extern command_t tty_command(board_t *board, player_t *player, move_t *mv);
extern void tty_drawplayer(player_t *player, int pos, bool up);
extern void tty_drawsummary(board_t *board, int turn);
extern void tty_drawmove(board_t *board, move_t *mv, player_t *player);
#else
extern void tty_init();
extern void tty_message();
extern char *tty_question();
extern bool tty_confirm();
extern command_t tty_command();
extern void tty_drawplayer();
extern void tty_drawsummary();
extern void tty_drawmove();
#endif
extern void tty_givehelp();
extern void tty_update();
extern void tty_cleanup();

#ifdef __hpux
#define srandom srand
#define random rand
#endif
