
/* RCS Info: $Revision: 1.1 $ on $Date: 89/03/15 11:17:10 $
 *           $Source: /yew3/faustus/src/scrabble/RCS/plural.c,v $
 * Copyright (c) 1989 Wayne A. Christopher, U. C. Berkeley CS Dept
 *	 faustus@renoir.berkeley.edu, ucbvax!faustus
 * Permission is granted to modify and re-distribute this code in any manner
 * as long as this notice is preserved.  All standard disclaimers apply.
 *
 * This program reads words from standard input and pluralizes them.
 */

#include <stdio.h>
#include <strings.h>

struct {
	char *end;
	char *new;
} endings[] = {
	{ "s",		"ses" },
	{ "x",		"xes" },
	{ "z",		"zes" },
	{ "ch",		"ches" },
	{ "sh",		"shes" },
	{ "ey",		"eys" },
	{ "y",		"ies" },
	{ "",		"s" }
} ;

#ifdef _STDC_
void
pluralize(char *word)
#else
void
pluralize(word)
char *word;
#endif
{
	int i, wl, sl;
	char *s, *t;

	for (i = 0; i < sizeof (endings) / sizeof (endings[0]); i++) {
		for (s = word, wl = 0; *s; s++, wl++)
			;
		for (t = endings[i].end, sl = 0; *t; t++, sl++)
			;
		if (sl > wl)
			continue;
		s -= sl;
		for (t = endings[i].end; *t; t++, s++)
			if (*s != *t)
				break;
		if (!*t) {
			s -= sl;
			for (t = endings[i].new; *t; t++, s++)
				*s = *t;
			*s = '\0';
			break;
		}
	}
}

main()
{
	char buf[512];

	while (fgets(buf, 512, stdin)) {
		buf[strlen(buf) - 1] = '\0';
		pluralize(buf);
		printf("%s\n", buf);
	}

	exit(0);
}

