
/* RCS Info: $Revision: 1.3 $ on $Date: 89/03/15 16:33:07 $
 *           $Source: /yew3/faustus/src/scrabble/RCS/player.c,v $
 * Copyright (c) 1989 Wayne A. Christopher, U. C. Berkeley CS Dept
 *	 faustus@renoir.berkeley.edu, ucbvax!faustus
 * Permission is granted to modify and re-distribute this code in any manner
 * as long as this notice is preserved.  All standard disclaimers apply.
 *
 */

#ifdef MSDOS
typedef char bool;
#endif
#include "scrabble.h"

#ifdef _STDC_
player_t *
makeplayer(board_t *board, int num)
#else
player_t *
makeplayer(board, num)
board_t *board;
int num;
#endif
{
	player_t *player = (player_t *) util_malloc(sizeof (player_t));
	int i;
	char buf[BSIZE], *s;

	if (userpick) {
		while (player->numworking < WORK_SIZE) {
			printf("Input %d letters for player %d: ", WORK_SIZE -
					player->numworking, num);
			fgets(buf, BSIZE, stdin);
			s = buf;
			while ((player->numworking < WORK_SIZE) &&
					(*s != '\n')) {
				if (isupper(*s))
					*s = tolower(*s);
				else if (*s == ' ')
					*s = WILD;
				player->working[player->numworking++] =
						*s++;
				/* So that the count goes down. */
				(void) pickletter(board);
			}
			if (*s != '\n')
				printf("Ignored extra letters\n");
		}
	} else {
		for (i = 0; i < WORK_SIZE; i++)
			player->working[i] = pickletter(board);
	}
	
	player->numworking = WORK_SIZE;
	player->score = 0;
	player->machine = true;

	return (player);
}

/* Note that this must be called before boardmove. */

#ifdef _STDC_
void
playermove(board_t *board, player_t *player, move_t *move)
#else
void
playermove(board, player, move)
board_t *board;
player_t *player;
move_t *move;
#endif
{
	int i, j, k;
	char c;
	char buf[BSIZE], *s;
	bool found;

	player->score += move->points;

	for (i = 0; i < move->length; i++)
		if (!something(boardletter(board, move->x, move->y,
				move->horiz, i))) {
			found = false;
			for (j = 0; j < player->numworking; j++)
				if (player->working[j] == move->word[i]) {
					for (k = j; k < player->numworking - 1;
							k++)
						player->working[k] =
							player->working[k + 1];
					player->numworking--;
					found = true;
					break;
				}
			if (!found)
				for (j = 0; j < player->numworking; j++)
					if (player->working[j] == WILD) {
						for (k = j; k < player->
								numworking - 1;
								k++)
							player->working[k] =
								player->
								working[k + 1];
						player->numworking--;
						break;
					}
		}

	if (userpick) {
		if (board->numleft) {
			sprintf(buf, "Input %d letters: ",
					min(WORK_SIZE - player->numworking,
					board->numleft));
			s = user_question(buf);
			while (*s && player->numworking < WORK_SIZE) {
				if (!board->numleft)
					break;
				player->working[player->numworking++] =
						isupper(*s) ? tolower(*s) : *s;
				s++;
				(void) pickletter(board);
			}
			if (*s)
				user_message("Ignoring extra letters.\n");
		}
	} else {
		while (player->numworking < WORK_SIZE) {
			c = pickletter(board);
			if (something(c))
				player->working[player->numworking++] = c;
			else
				break;
		}
	}

	return;
}

#ifdef notdef

#ifdef _STDC_
void
printplayer(player_t *player, int num, FILE *fp)
#else
void
printplayer(player, num, fp)
player_t *player;
int num;
FILE *fp;
#endif
{
	int i;

	if (num >= 0)
		fprintf(fp, "Player %d: score = %d\tletters =", num,
				player->score);
	else
		fprintf(fp, "Score = %d\tletters =", player->score);
	for (i = 0; i < player->numworking; i++)
		fprintf(fp, " %c", player->working[i]);
	fprintf(fp, "\n");

	return;
}

#endif

