
/* RCS Info: $Revision: 1.3 $ on $Date: 89/03/15 16:31:58 $
 *           $Source: /yew3/faustus/src/scrabble/RCS/board.c,v $
 * Copyright (c) 1989 Wayne A. Christopher, U. C. Berkeley CS Dept
 *	 faustus@renoir.berkeley.edu, ucbvax!faustus
 * Permission is granted to modify and re-distribute this code in any manner
 * as long as this notice is preserved.  All standard disclaimers apply.
 *
 */

#ifdef MSDOS
typedef char bool;
#include <stdlib.h>
#endif
#include "scrabble.h"

static char *bonus_map[] = {
	"T  d   T   d  T",
	" D   t   t   D ",
	"  D   d d   D  ",
	"d  D   d   D  d",
	"    D     D    ",
	" t   t   t   t ",
	"  d   d d   d  ",
	"T  d   D   d  T",
	"  d   d d   d  ",
	" t   t   t   t ",
	"    D     D    ",
	"d  D   d   D  d",
	"  D   d d   D  ",
	" D   t   t   D ",
	"T  d   T   d  T"
} ;

static int distrib[NUM_LETTERS] = {
	/* A  B  C  D  E  F  G  H  I  J  K  L  M */
	   9, 2, 2, 4,12, 2, 3, 2, 9, 1, 1, 4, 2,

	/* N  O  P  Q  R  S  T  U  V  W  X  Y  Z  * */
	   6, 8, 2, 1, 6, 4, 6, 4, 2, 2, 1, 2, 1, 2
} ;

int letterpoint_values[NUM_LETTERS] = {
	/* A  B  C  D  E  F  G  H  I  J  K  L  M */
	   1, 3, 3, 2, 1, 4, 2, 4, 1, 8, 5, 1, 3,

	/* N  O  P  Q  R  S  T  U  V  W  X  Y  Z  * */
	   1, 1, 3,10, 1, 1, 1, 1, 4, 4, 8, 4,10, 0
} ;

board_t *
makeboard()
{
	board_t *board = (board_t *) util_malloc(sizeof (board_t));
	int i, j, k;

	for (i = 0; i < SIZE; i++)
		for (j = 0; j < SIZE; j++) {
			board->letters[i][j] = ' ';
			switch (bonus_map[i][j]) {
			    case ' ': board->bonus[i][j] = NONE; break;
			    case 'd': board->bonus[i][j] = DOUBLE_LETTER; break;
			    case 't': board->bonus[i][j] = TRIPLE_LETTER; break;
			    case 'D': board->bonus[i][j] = DOUBLE_WORD; break;
			    case 'T': board->bonus[i][j] = TRIPLE_WORD; break;
			}
		}

	for (i = POOL_SIZE - 1; i >= 0; i--) {
#ifdef MSDOS
		j = rand() % (i + 1);
#else
		j = random() % (i + 1);
#endif				
		for (k = 0; j >= 0; j -= distrib[k++])
			;
		k--;
		distrib[k]--;
		if (k == NUM_LETTERS - 1)
			board->pool[i] = WILD;
		else
			board->pool[i] = 'a' + k;
	}

	board->numleft = POOL_SIZE;
	board->virgin = true;

	return (board);
}

#ifdef _STDC_
void
boardmove(board_t *board, move_t *move)
#else
void
boardmove(board, move)
board_t *board;
move_t *move;
#endif
{
	int i;

	if (move->horiz)
		for (i = 0; i < move->length; i++) {
			board->letters[move->x + i][move->y] = move->wild[i] ?
					makewild(move->word[i]) : move->word[i];
		}
	else
		for (i = 0; i < move->length; i++) {
			board->letters[move->x][move->y + i] = move->wild[i] ?
					makewild(move->word[i]) : move->word[i];
		}

	board->virgin = false;

	return;
}

#ifdef _STDC_
char
pickletter(board_t *board)
#else
char
pickletter(board)
board_t *board;
#endif
{
	if (board->numleft)
		return (board->pool[--board->numleft]);
	else
		return (ZIP);
}

#ifdef notdef

static char lbchar[] = " `\"(<";
static char rbchar[] = " '\")>";

#ifdef _STDC_
void
printboard(board_t *board, FILE *fp)
#else
void
printboard(board,fp)
board_t *board;
FILE *fp;
#endif
{
	int i, j;
	char c;

	fprintf(fp, "   ");
	for (j = 0; j < SIZE; j++)
		fprintf(fp, " %-2d", j);
	fprintf(fp, "\n");
	for (i = 0; i < SIZE; i++) {
		fprintf(fp, "%2d ", i);
		for (j = 0; j < SIZE; j++) {
			if (something(board->letters[j][i])) {
				if (iswild(board->letters[j][i]))
					c = tolower(board->letters[j][i]);
				else
					c = toupper(board->letters[j][i]);
			} else {
				c = '.';
			}
			fprintf(fp, "%c%c%c", lbchar[board->bonus[j][i]], c,
					rbchar[board->bonus[j][i]]);
		}
		fprintf(fp, " %-2d\n", i);
	}
	fprintf(fp, "   ");
	for (j = 0; j < SIZE; j++)
		fprintf(fp, " %-2d", j);
	fprintf(fp, "\n\tLetters left: %d\n", board->numleft);

	return;
}

#endif

