
# RCS Info: $Revision: 1.2 $ on $Date: 89/03/15 11:16:17 $
#           $Source: /yew3/faustus/src/scrabble/RCS/Makefile,v $
# Copyright (c) 1987 Wayne A. Christopher, U. C. Berkeley CAD Group
#
# Program Makefile
#
# This makefile has the standard options "clean", "require", and "install".
# Also available are "lint", "depend", "tags", "opt", "debug", and "prof".
# "opt" causes the program to be compiled optimized, "debug" with -g, and
# "prof" with -pg.  As an added bonus, the Makefile remembers the last of
# these options given.
#
# Heavily mutated to work with OpusMake, Turbo-C v1.5 (at least), and
# Bjorn Larsson's (...mcvax!enea!infovax!bl) PC-Curses package.
#
#   Erik Talvola
#   talvola@cory.berkeley.edu
#   ...!ucbvax!cory!talvola

what: all

#---- Tool specific stuff ----

PROGRAM = scrabble.exe

SRC	=		\
	board.c		\
	dict.c		\
	move.c		\
	player.c	\
	savegame.c	\
	scrabble.c	\
	tty.c		\
	user.c		\
	util.c 

OBJ	= board.obj dict.obj move.obj player.obj savegame.obj \
	scrabble.obj tty.obj user.obj util.obj 

HDR	=		\
	scrabble.h	\
	util.h

SUPPORT		=	plural

CC = tcc
MODEL = c
CFLAGS = -m$(MODEL) -I\turboc\include -G -O -Z -DMSDOS
LIBDIR = \turboc\lib

LIBS = $(LIBDIR)\$(MODEL)curses.lib
LDFLAGS = -L$(LIBDIR) -m$(MODEL)

#---- Generic stuff ----

# EXTDEFINES are things that come from a higher-level Makefile

all: date.h $(PROGRAM) $(SUPPORT).exe
	@echo "All done."

# the next rule isn't very good - before making scrabble.exe, delete
# plural.obj (and any others) if they exist.  I didn't bother writing
# a file to give to LINK, and the command line is too long to handle all
# the obj's directly.

$(PROGRAM): $(OBJ)
	$(CC) -e$(PROGRAM) $(LDFLAGS) *.obj $(LIBS)

$(SUPPORT).exe: $(SUPPORT).obj
	$(CC) -e$(SUPPORT) $(LDFLAGS) $(SUPPORT).obj $(LIBS)

