      SUBROUTINE RANDOM (R)
C
C     RANDOM NUMBER GENERATOR FOR 32 BIT MACHINES.
C
C     VARIABLE IX (IN COMMON) SHOULD CONTAIN THE 'SEED' VALUE ON THE
C     FIRST CALL TO THIS ROUTINE - THE SEED SHOULD BE AN 8 DIGIT
C     ODD INTEGER, ELSE GENERATOR INITIALIZED FROM TIME OF DAY.
C     IF THE VARIABLE R IS SET TO 0.0 ON INPUT, A NEW SEED IS
C     GENERATED FROM THE TIME OF DAY.
C
C     RANDOM RETURNS A REAL*4 VALUE BETWEEN 0.0 AND +1.0.
C
      INTEGER IR(4)
C
      COMMON /RANDSEED/ IX
C
C     IF R IS 0.0, INITIALIZE GENERATOR FROM TIME OF DAY:
C     IR(1), IR(2), IR(3) AND IR(4) CONTAIN THE HOUR, MINUTE,
C     SECOND AND 1/60 SECOND VALUES. THEN MAKE SURE IX IS POSITIVE,
C     AND ODD.
C
      IF (R .EQ. 0.0) THEN
         CALL itime (IR)
	 IR(4) = IR(1) + IR(2) + IR(3)
         IX = 12345678 + 60*(60*(60*IR(1)+IR(2))+IR(3)) + IR(4)
         IX = 2*(IABS(IX)/2) + 1
      END IF
C
      IX = IX * 54891
C
C     NEXT LINE GENERATES NUMBERS BETWEEN -1.0 AND +1.0.
C
C     R = FLOAT(IX) * 0.4656612E-9
C
C     NEXT LINE GENERATES NUMBERS BETWEEN 0.0 AND +1.0.
C
      R = 0.5 * (FLOAT(IX)*0.4656612E-9 + 1.0)
      RETURN
      END
