      SUBROUTINE PE550 (CURSOR, LCURSOR)
C
C     CURSOR CONTROL CHARACTERS FOR A PE550 TERMINAL.
C
      INTEGER ESC, Y
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), CDATA(22), LCDATA(22),
     1 BUFFER4
C
      LOGICAL CURRADDR
C
      DATA ESC/Z'1B'/, Y/Z'59'/
      DATA CDATA/
     1 Z'1B480000',Z'1B410000',Z'1B420000',Z'1B440000',Z'1B430000',
     2 Z'1B580000',Z'00000000',Z'1B4B0000',Z'00000000',Z'1B490000',
     3 Z'00000000',Z'00000000',Z'00000000',Z'00000000',Z'00000000',
     4 Z'00000000',Z'00000000',Z'00000000',Z'07000000',Z'09000000',
     5 Z'0D000000',Z'0A000000'/
      DATA LCDATA/2,2,2,2,2, 2,0,2,0,2, 0,0,0,0,0, 0,0,0,1,1, 1,1/
C
C     COMMAND      LEAD IN   KEY                ASCII   DECIMAL
C     -------      -------   ---                -----   -------
C
C     HOME           YES     H                   H         72
C     UP             YES     A                   A         65
C     DOWN           YES     B                   B         66
C     LEFT           YES     D                   D         68
C     RIGHT          YES     C                   C         67
C     ADDRESS        YES     X (OR Y)            X (OR Y)  88 (OR 89)
C     READ ADDRESS   ----------------NOT DEFINED-------------
C     CLEAR SCREEN   YES     K                   K         75 (+20 NUL)
C     CLEAR FOREGR   ----------------NOT DEFINED-------------
C     CLEAR TO EOL   YES     I                   I         73 (+20 NUL)
C     CLEAR TO EOS   ----------------NOT DEFINED-------------
C     CLEAR BACKSP   ----------------NOT DEFINED-------------
C     BCKGRND FLWS   ----------------NOT DEFINED-------------
C     FREGRND FLWS   ----------------NOT DEFINED-------------
C     DELETE LINE    ----------------NOT DEFINED-------------
C     INSERT LINE    ----------------NOT DEFINED-------------
C     KEYB LOCK      ----------------NOT DEFINED-------------
C     KEYB UNLOCK    ----------------NOT DEFINED-------------
C     BELL           NO      CONTROL-G           BEL       7
C     TAB            NO      TAB (CONTROL-I)     HT        9
C     CARRIAGE RET   NO      CR                  CR        14
C     LINE FEED      NO      LF                  LF        10
C
      DO 10 I=1,22
      CURSOR(1,I) = CDATA(I)
      LCURSOR(I) = LCDATA(I)
      DO 10 J=2,10
   10 CURSOR(J,I) = 0
      RETURN
C
C     ENTRY PECONV
C
C     PERFORM BUFFER CONVERSION FOR PE 550 TERMINAL.
C     THE BUFFER IS EXTENDED BY 20 NULL CHARACTERS FOR CLEAR SCREEN
C     AND CLEAR TO END-OF-LINE COMMANDS, AND CURSOR ADDRESSING IS
C     EXPANDED TO SEND FIRST THE X COORDINATE, THEN THE Y COORDINATE.
C
C     CURSOR   - INPUT BUFFER (6 INTEGER*4 WORDS).
C     ICOUNT   - NUMBER OF CHARACTERS DEFINED IN BUFFER.
C                PECONV ONLY INSPECTS (OR MODIFIES) 2 CHARACTER
C                COMMANDS.
C     CURRADDR - LOGICAL FLAG WHICH KEEPS TRACK OF WHETHER THE LAST
C                CURSOR COMMAND WAS CURSOR ADDRESSING - THIS VARIABLE
C                MUST BE SET FALSE BY THE CALLING PROGRAM BEFORE THE
C                FIRST CALL TO PECONV. THE CALLING PROGRAM MAY CHANGE
C                THIS VARIABLE TO INDICATE THAT THE LAST COMMAND
C                WAS NOT CURSOR ADDRESSING (SET TO .FALSE.), OR VICE
C                VERSA (SET .TRUE. TO INDICATE LAST COMMAND WAS
C                CURSOR ADDRESSING). THIS ROUTINE WILL ALSO SET/RESET
C                THE FLAG APPROPRIATELY.
C
      ENTRY PECONV (CURSOR, ICOUNT, CURRADDR)
C
      IF (ICOUNT .NE. 2) GO TO 100
      BUFFER4 = CURSOR(1,1)
      IF (CURRADDR) GO TO 300
      CALL ISETBUFFER1 (3, 0, BUFFER4)
      CALL ISETBUFFER1 (4, 0, BUFFER4)
      IF (BUFFER4 .EQ. CDATA(6)) THEN
         CURRADDR = .TRUE.
         RETURN
      END IF
      IF (BUFFER4.EQ.CDATA(8) .OR. BUFFER4.EQ.CDATA(10)) THEN
         ICOUNT = 22
         CURSOR(1,1) = BUFFER4
         CURSOR(2,1) = 0
         CURSOR(3,1) = 0
         CURSOR(4,1) = 0
         CURSOR(5,1) = 0
         CURSOR(6,1) = 0
      END IF
  100 CURRADDR = .FALSE.
      RETURN
C
C     HANDLE SCREEN ADDRESSING BY EXPANDING THE BUFFER.
C
C     BYTE    INPUT BUFFER CONTAINS        OUTPUT BUFFER CONTAINS
C       1           X COORD                       X COORD
C       2           Y COORD                       ESCAPE
C       3           -------                         Y
C       4           -------                       Y COORD
C
  300 CURRADDR = .FALSE.
      ICOUNT = 4
      CALL ISETBUFFER1 (4, IGETBUFFER1(2,BUFFER4), BUFFER4)
      CALL ISETBUFFER1 (2, ESC, BUFFER4)
      CALL ISETBUFFER1 (3, Y, BUFFER4)
      CURSOR(1,1) = BUFFER4
      RETURN
      END
