      PROGRAM PARTY
C
C     ****************************************************************
C     *              PARTY PROGRAM                                   *
C     ****************************************************************
C
C     THE BASIC CURSOR CONTROL CO-ORDINATES ARE THOSE SUITABLE FOR
C     A HAZELTINE TERMINAL. I.E. X-Y ORDER WHERE X IS THE COLUMN NUMBER
C     FROM 0 TO 79 AND Y IS THE ROW NUMBER FROM 0 TO 23.
C     TOP LEFT IS 0,0           TOP RIGHT IS 79,0
C     BOTTOM LEFT IS 0,23       BOTTOM RIGHT IS 79,23
C
C        0,0-----------> X
C          |
C          |
C          |
C          |
C          V
C          Y
C
C     CODED FROM IDEAS PRESENTED IN SCIENTIFIC AMERICAN COMPUTER
C     RECREATIONS COLUMN, BY A.K. DEWDNEY, ORIGINALLY DESIGNED BY
C     RICH GOLD AS "PARTY PLANNER".
C     MIKE PETERSON, DEPT OF CHEMISTRY, UNIV OF TORONTO, TORONTO, CANADA
C
      IMPLICIT INTEGER*4 (A-Z)
C
      CHARACTER TEXT*10, GUEST(8)*20, ZFORMAT*80, BLANK*1
C
      REAL*4 RAND, UNHAPPY, U, UBEST
C
      LOGICAL STEADY
C
C     CURSOR CONTROL COMMON BLOCK DEFINITIONS.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), DISPWORD, BELL(10)
C
      COMMON /CURCOM/ CURSOR, LCURSOR, ITERM, DISPWORD, JADD
      COMMON /PARAM/ RAND, GUESTXY(2,8), TMINX, TMINY, TMAXX, TMAXY,
     1 IDEAL(8,9), GUEST
C
      EQUIVALENCE (BELL(1),CURSOR(1,19)), (LBELL,LCURSOR(19))
C
      DATA BLANK/' '/
C     DATA LFCUT/'UT  '/, LFCVDU/'VDU '/
C
C     OPEN VDU AND ADJUST ITS FCB
C
C     OPEN (UNIT=LFCUT, OPENMODE='U')
C     OPEN (UNIT=LFCVDU, OPENMODE='U')
C     JADD = M:GETFCB(LFCVDU)
C     CALL SETFCB (JADD)
C
C     CHECK FOR TERMINAL TYPE ON INPUT LINE.
C
C     CALL X:TSCAN (1, I, DISP, TEXT)
      ITERM = -1
C     IF (I.NE.1 .OR. DISP(2).NE.2) GO TO 20
C     IF (TEXT(1:1) .EQ. '*') THEN
C        ITERM = 0
C     ELSE IF (TEXT(1:1).GE.'1' .AND. TEXT(1:1).LE.'6') THEN
C        READ (TEXT(1:1),10) ITERM
C  10    FORMAT (I1)
C     END IF
C     GO TO 50
C
   20 WRITE (6,30)
   30 FORMAT (/' Welcome to the Party Game.'/
     1 /' This is a game of social dynamics, where 8 party guests are'/
     2 ' confined to a 20x30 room, which also contains a refreshment'/
     3 ' table. You may control the evolution of the system of guests'/
     4 ' by specifying their ideal desired distances from each of the'
     5 /' other guests and from the table of goodies (for instance, a'/
     6 ' dieter may have a fairly large ideal distance to the table,'/
     7 ' while a food pig may want to be glued to the table). Also,'/
     8 ' the desired distance of guest A to guest B may be different'/
     9 ' from the desired distance of guest B to A. Alternatively, you'/
     A ' may allow the program to set up the controlling parameters'/
     B ' and just watch the progress of the party.')
C
   50 CALL TERMSET (ITERM, JADD, CURSOR, LCURSOR)
C
      RAND = 0.0
   90 TMINX = 0
      TMINY = 0
      TMAXX = 0
      TMAXY = 0
      do 95 i=1,8
      GUESTXY(1,i) = 0
   95 GUESTXY(2,i) = 0
      GUEST(1) = 'Arthur (artist)'
      GUEST(2) = 'Bernie (businessman)'
      GUEST(3) = 'Dennis (dentist)'
      GUEST(4) = 'Millie (model)'
      GUEST(5) = 'Penelope (princess)'
      GUEST(6) = 'Susan (stockbroker)'
      GUEST(7) = 'Viola (violinist)'
      GUEST(8) = 'Wally (weightlifter)'
      do 96 j=1,9
      do 96 i=1,8
   96 IDEAL(i,j) = 0
      CALL CLEAR
      CALL DISPROOM (1)
C
C     GET THE TABLE POSITION AND SIZE.
C
  100 TMINX = 0
      TMINY = 0
      TMAXX = 0
      TMAXY = 0
      CALL DISPLAY (0, 23, 'Table coordinate specification (use 0 or '//
     1 '<CR> to have the program choose)', .TRUE.)
C
      CALL DISPLAY (0, 22, 'Enter X (horizontal) coordinate of '//
     1 'upper left corner of table (1-30): ', .TRUE.)
      READ (5,120,END=8000,ERR=150) TMINX
  120 FORMAT (I10)
      IF (TMINX .EQ. 0) GO TO 160
      IF (TMINX.LE.0 .OR. TMINX.GT.30) GO TO 150
C
      CALL DISPLAY (0, 22, 'Enter Y (vertical) coordinate of '//
     1 'upper left corner of table (1-20): ', .TRUE.)
      READ (5,120,END=8000,ERR=150) TMINY
      IF (TMINY .EQ. 0) GO TO 170
      IF (TMINY.LE.0 .OR. TMINY.GT.20) GO TO 150
C
      CALL DISPLAY (2*TMINX-1, TMINY, 'T', .FALSE.)
      WRITE (ZFORMAT,130) TMINX
  130 FORMAT ('Enter X (horizontal) coordinate of ',
     1 'lower right corner of table (',I2,'-30): ')
      I = INDEX (ZFORMAT, ': ') + 1
      CALL DISPLAY (0, 22, ZFORMAT(1:I), .TRUE.)
      READ (5,120,END=8000,ERR=150) TMAXX
      IF (TMAXX .EQ. 0) GO TO 180
      IF (TMAXX.LT.TMINX .OR. TMAXX.GT.30) GO TO 150
C
      WRITE (ZFORMAT,140) TMINY
  140 FORMAT ('Enter Y (vertical) coordinate of ',
     1 'lower right corner of table (',I2,'-20): ')
      I = INDEX (ZFORMAT, ': ') + 1
      CALL DISPLAY (0, 22, ZFORMAT(1:I), .TRUE.)
      READ (5,120,END=8000,ERR=150) TMAXY
      IF (TMAXY .EQ. 0) GO TO 190
      IF (TMAXY.LT.TMINY .OR. TMAXY.GT.20) GO TO 150
      GO TO 200
C
C     INPUT ERROR OF SOME KIND - BEEP THE TWIT AND TRY AGAIN.
C
  150 CALL DISPLAY (0, 22, 'Illegal value specified - start again!',
     1 .TRUE.)
      CALL WRITCH (JADD, BELL, LBELL, ITERM, *9000, *9000)
      IF (TMINX.NE.0 .AND. TMINY.NE.0)
     1 CALL DISPLAY (2*TMINX-1, TMINY, ' ', .FALSE.)
      CALL DELAY (5)
      GO TO 100
C
C     CHOOSE SOME OR ALL TABLE POSITION PARAMETERS RANDOMLY.
C
  160 CALL RANDOM (RAND)
      TMINX = 3.0 + 17.0*RAND
C
  170 CALL RANDOM (RAND)
      TMINY = 3.0 + 9.0*RAND
C
  180 MAXL = MIN0 (12, 31-TMINX)
      CALL RANDOM (RAND)
      TMAXX = TMINX + MAXL*RAND
C
  190 MAXL = MIN0 (6, 21-TMINY)
      CALL RANDOM (RAND)
      TMAXY = TMINY + MAXL*RAND
C
C     DISPLAY ROOM WITH TABLE.
C
  200 CALL CLEAR
      CALL DISPROOM (1)
C
C     GET THE GUEST POSITIONS.
C
      CALL DISPLAY (0, 23, 'Guest coordinate specification (use 0 or '//
     1 '<CR> to have the program choose)', .TRUE.)
C
      DO 390 I=1,8
      L = INDEX (GUEST(I), ')')
C
  210 WRITE (ZFORMAT,220) GUEST(I)(1:L)
  220 FORMAT ('Enter X (horizontal) coordinate for ',A,
     1 ' (1-30): ')
      J = INDEX (ZFORMAT, ': ') + 1
      CALL DISPLAY (0, 22, ZFORMAT(1:J), .TRUE.)
      READ (5,120,END=8000,ERR=280) GUESTXY(1,I)
      IF (GUESTXY(1,I) .EQ. 0) GO TO 300
      IF (GUESTXY(1,I).LE.0 .OR. GUESTXY(1,I).GT.30) GO TO 280
C
      WRITE (ZFORMAT,240) GUEST(I)(1:L)
  240 FORMAT ('Enter Y (vertical) coordinate for ',A,
     1 ' (1-20): ')
      J = INDEX (ZFORMAT, ': ') + 1
      CALL DISPLAY (0, 22, ZFORMAT(1:J), .TRUE.)
      READ (5,120,END=8000,ERR=280) GUESTXY(2,I)
      IF (GUESTXY(2,I) .EQ. 0) GO TO 350
      IF (GUESTXY(2,I).LE.0 .OR. GUESTXY(2,I).GT.20) GO TO 280
C
C     MAKE SURE THE GUEST HASN'T STEPPED ON THE REFRESHMENT TABLE.
C
      IF (GUESTXY(1,I).GE.TMINX .AND. GUESTXY(1,I).LE.TMAXX .AND.
     1 GUESTXY(2,I).GE.TMINY .AND. GUESTXY(2,I).LE.TMAXY) THEN
         CALL DISPLAY (0, 22, 'Your guest has stepped on the '//
     1    'refreshment table (Yuck!!) - try again!', .TRUE.)
         CALL WRITCH (JADD, BELL, LBELL, ITERM, *9000, *9000)
         CALL DELAY (5)
         GO TO 210
      END IF
C
C     CHECK THAT THE GUEST HASN'T STEPPED ON SOMEONE ELSE.
C
      CALL CHECKXY (I, *390, *250)
  250 CALL DISPLAY (0, 22, 'Your guest has materialized on top of '//
     1 'another guest - try again!', .TRUE.)
      CALL WRITCH (JADD, BELL, LBELL, ITERM, *9000, *9000)
      CALL DELAY (5)
      GO TO 210
C
C     INPUT ERROR OF SOME KIND - BEEP THE TWIT AND TRY AGAIN.
C
  280 CALL DISPLAY (0, 22, 'Illegal value specified - try again!',
     1 .TRUE.)
      CALL WRITCH (JADD, BELL, LBELL, ITERM, *9000, *9000)
      CALL DELAY (5)
      GO TO 210
C
C     CHOOSE THE GUEST'S X AND Y COORDINATES RANDOMLY.
C
  300 NPASS = 0
C
  310 CALL RANDOM (RAND)
      GUESTXY(1,I) = 1.0 + 29.0*RAND
      CALL RANDOM (RAND)
      GUESTXY(2,I) = 1.0 + 19.0*RAND
      CALL CHECKXY (I, *390, *320)
  320 NPASS = NPASS + 1
      IF (NPASS .LE. 50) GO TO 310
      CALL DISPLAY (0, 22, 'Can not place guest randomly - '//
     1 'please use a smaller food table !!!', .TRUE.)
      CALL DELAY (5)
      GO TO 8000
C
C     CHOOSE THE GUEST'S Y COORDINATE RANDOMLY.
C
  350 NPASS = 0
C
  360 CALL RANDOM (RAND)
      GUESTXY(2,I) = 1.0 + 19.0*RAND
      CALL CHECKXY (I, *390, *370)
  370 NPASS = NPASS + 1
      IF (NPASS .LE. 50) GO TO 360
      CALL DISPLAY (0, 22, 'Can not place guest randomly - '//
     1 'please use a smaller food table !!!', .TRUE.)
      GO TO 8000
C
C     GOT SOME VALID COORDINATES - DISPLAY THE GUEST IN THE ROOM.
C
  390 CALL DISPLAY (2*GUESTXY(1,I)-1, GUESTXY(2,I), GUEST(I)(1:1),
     1 .FALSE.)
C
C     DISPLAY ROOM WITH TABLE AND GUESTS.
C
      CALL CLEAR
      CALL DISPROOM (2)
C
C     SET UP THE IDEAL DISTANCE MATRIX.
C
      CALL DISPLAY (0, 22, 'Would you like to enter the ideal '//
     1 'distance table yourself (Y or N) ? ', .TRUE.)
      READ (5,410,END=9000) TEXT
  410 FORMAT (A)
C
      CALL CLEAR
      CALL DISPLAY (0, 0, 'Ideal Distance of Guest i (row)'//
     1 ' to Guest j (column) and the table (T)', .FALSE.)
      DO 420 I=1,8
      CALL DISPLAY (22+5*I, 3, GUEST(I)(1:1), .FALSE.)
  420 CALL DISPLAY (0, 3+2*I, GUEST(I), .FALSE.)
      CALL DISPLAY (67, 3, 'T', .FALSE.)
C
      IF (TEXT.EQ.'Y' .OR. TEXT.EQ.'y') GO TO 500
C
C     GENERATE THE TABLE RANDOMLY.
C
  430 CALL DISPLAY (0, 21, ' ', .TRUE.)
      CALL DISPLAY (0, 22, ' ', .TRUE.)
C
      DO 450 I=1,8
      DO 450 J=1,9
      IF (IDEAL(I,J) .NE. 0) GO TO 450
      IF (I .NE. J) THEN
         CALL RANDOM (RAND)
         IDEAL(I,J) = -2.0 + 20.0*RAND
      END IF
      CALL DISPLAY (18+5*J, 3+2*I, ' ', .FALSE.)
      WRITE (6,440) IDEAL(I,J)
  440 FORMAT (I4,$)
  450 CONTINUE
      GO TO 600
C
C     GET THE TABLE FROM THE USER.
C
  500 CALL DISPLAY (0, 21, 'Enter a value between -1 and 50 and '//
     1 'press <CR>, where -1 means there is no', .TRUE.)
      CALL DISPLAY (0, 22, 'ideal distance, and 0 (or just <CR>) '//
     1 'asks for a random choice.', .TRUE.)
      CALL DISPLAY (0, 23, 'To fill in the rest of the table '//
     1 'randomly, enter any non-numeric character.', .TRUE.)
C
      DO 590 I=1,8
      DO 590 J=1,9
      IF (I .EQ. J) GO TO 580
      IX = 18 + 5*J
C
  510 CALL DISPLAY (IX, 3+2*I, '  :', .FALSE.)
      READ (5,120,END=8000,ERR=430) IDEAL(I,J)
C
      IF (IDEAL(I,J).LT.-1 .OR. IDEAL(I,J).GT.50) THEN
         CALL DISPLAY (0, 23, 'Illegal value specified - try again!',
     1    .TRUE.)
         CALL WRITCH (JADD, BELL, LBELL, ITERM, *9000, *9000)
         CALL DELAY (5)
         CALL DISPLAY (0, 23, 'To fill in the rest of the table '//
     1    'randomly, enter any non-numeric character.', .TRUE.)
         CALL DISPLAY (IX, 3+2*I, ' ', .FALSE.)
         WRITE (6,520) (BLANK,K=IX,78)
  520    FORMAT (80A1,$)
         IDEAL(I,J) = 0
         GO TO 510
      END IF
C
      IF (IDEAL(I,J) .EQ. 0) THEN
         CALL RANDOM (RAND)
         IDEAL(I,J) = -2.0 + 20.0*RAND
      END IF
C
  580 CALL DISPLAY (18+5*J, 3+2*I, ' ', .FALSE.)
  590 WRITE (6,440) IDEAL(I,J)
C
C     MOVE THE GUESTS AROUND.
C
  600 CALL DISPLAY (0, 23, 'Enter <CR> to continue: ', .TRUE.)
      READ (5,410,END=9000) TEXT
      CALL CLEAR
      CALL DISPROOM (2)
      CALL DISPLAY (0, 23, 'Enter number of iterations (1-99),'//
     1 ' <CR> for 1 step, or X to quit.', .TRUE.)
      ITER = 0
      NIT = 0
      NSTEADY = 0
C
  610 CALL DISPLAY (0, 22, ' ', .TRUE.)
      CALL DISPLAY (60, 22, 'Iteration:', .FALSE.)
      WRITE (6,620) ITER
  620 FORMAT (I5,$)
      IF (NIT .GT. 0) GO TO 640
C
      CALL DISPLAY (0, 22, 'Enter your choice:  ', .FALSE.)
      READ (5,410,END=9000) TEXT
      IF (TEXT.EQ.'X' .OR. TEXT.EQ.'x') GO TO 8000
      IF (TEXT.EQ.'Q' .OR. TEXT.EQ.'q') GO TO 8000
      READ (TEXT,120,END=9000,ERR=630) NIT
      IF (NIT.GE.0 .AND. NIT.LE.99) GO TO 640
C
C     INPUT ERROR OF SOME KIND - BEEP THE TWIT AND TRY AGAIN.
C
  630 CALL DISPLAY (0, 22, 'Illegal value specified - try again!',
     1 .TRUE.)
      CALL WRITCH (JADD, BELL, LBELL, ITERM, *9000, *9000)
      CALL DELAY (3)
      NIT = -1
      GO TO 610
C
  640 ITER = ITER + 1
      STEADY = .TRUE.
C
C     LOOP OVER EACH GUEST, FINDING THE BEST MOVE FOR EACH.
C
      DO 690 I=1,8
      XOLD = GUESTXY(1,I)
      YOLD = GUESTXY(2,I)
      UBEST = 1.0D30
C
      DO 680 XINC=-1,1
      GUESTXY(1,I) = XOLD + XINC
      DO 680 YINC=-1,1
      GUESTXY(2,I) = YOLD + YINC
      CALL CHECKXY (I, *650, *680)
  650 U = UNHAPPY (I)
      IF (U-UBEST) 670, 660, 680
C
C     GOT SAME UNHAPPINESS AS BEFORE - SPIN THE RANDOM NUMBER.
C
  660 CALL RANDOM (RAND)
      IF (RAND .GE. 0.50) GO TO 680
C
C     GOT A NEW LOW FOR UNHAPPINESS - KEEP TRACK OF THIS POSITION.
C
  670 XBEST = GUESTXY(1,I)
      YBEST = GUESTXY(2,I)
      UBEST = U
C
  680 CONTINUE
C
C     DISPLAY THE NEW POSITION FOR THIS GUEST.
C
      CALL DISPLAY (2*XOLD-1, YOLD, ' ', .FALSE.)
      GUESTXY(1,I) = XBEST
      GUESTXY(2,I) = YBEST
      CALL DISPLAY (2*GUESTXY(1,I)-1, GUESTXY(2,I), GUEST(I)(1:1),
     1 .FALSE.)
      IF (XOLD.NE.XBEST .OR. YOLD.NE.YBEST) STEADY = .FALSE.
C
  690 CONTINUE
C
      IF (STEADY) THEN
         NSTEADY = NSTEADY + 1
         IF (NSTEADY .GT. 5) GO TO 700
      ELSE
         NSTEADY = 0
      END IF
      NIT = NIT - 1
      IF (NIT .LE. 0) GO TO 610
      CALL DISPLAY (0, 22, ' ', .FALSE.)
      CALL DELAY (1)
      GO TO 610
C
C     THE PARTY HAS REACHED A STEADY STATE - MIGHT AS WELL QUIT.
C
  700 CALL DISPLAY (0, 22, 'The party has reached a very boring '//
     1 'steady state at iteration', .TRUE.)
      WRITE (6,620) ITER
      CALL DISPLAY (0, 23, 'We might as well call it quits!'//
     1 '     Enter <CR> to continue: ', .TRUE.)
      READ (5,410,END=9000) TEXT
C
C     PARTY'S OVER.
C
 8000 CALL DISPLAY (0, 22, 'The party is over -- come back soon !!!',
     1 .TRUE.)
      CALL DISPLAY (0, 23, ' ', .TRUE.)
      CALL DISPLAY (0, 23, 'Would you like to have another party now'//
     1 ' (Y or N) ? ', .TRUE.)
      READ (5,410,END=9000) TEXT
      IF (TEXT.EQ.'Y' .OR. TEXT.EQ.'y') GO TO 90
      STOP
C
 9000 STOP
      END
      SUBROUTINE CHECKXY (I, *, *)
C
C     SUBROUTINE TO CHECK IF THE COORDINATES OF GUEST I ARE
C     ACCEPTABLE.
C
C     THE ARGUMENT 'I' IS THE GUEST NUMBER TO BE CHECKED.
C     THE FIRST ALTERNATE RETURN IS TAKEN IF THE COORDINATES ARE OK,
C     AND THE SECOND ALTERNATE RETURN IS TAKEN IF THE COORDINATES
C     ARE NOT OK.
C
      IMPLICIT INTEGER*4 (A-Z)
C
      REAL*4 RAND
C
      CHARACTER GUEST(8)*20
C
      COMMON /PARAM/ RAND, GUESTXY(2,8), TMINX, TMINY, TMAXX, TMAXY,
     1 IDEAL(8,9), GUEST
C
C     MAKE SURE THE GUEST IS WITHIN THE ROOM.
C
      IF (GUESTXY(1,I).LE.0 .OR. GUESTXY(1,I).GT.30) RETURN 2
      IF (GUESTXY(2,I).LE.0 .OR. GUESTXY(2,I).GT.20) RETURN 2
C
C     MAKE SURE THE GUEST HASN'T STEPPED ON THE REFRESHMENT TABLE.
C
      IF (GUESTXY(1,I).GE.TMINX .AND. GUESTXY(1,I).LE.TMAXX .AND.
     1 GUESTXY(2,I).GE.TMINY .AND. GUESTXY(2,I).LE.TMAXY) RETURN 2
C
C     MAKE SURE THE GUEST HASN'T DEMOLISHED ANOTHER GUEST.
C
      DO 100 J=1,8
      IF (I .EQ. J) GO TO 100
      IF (GUESTXY(1,J).EQ.0 .OR. GUESTXY(2,J).EQ.0) GO TO 100
      IF (GUESTXY(1,I).EQ.GUESTXY(1,J) .AND.
     1 GUESTXY(2,I).EQ.GUESTXY(2,J)) RETURN 2
  100 CONTINUE
C
      RETURN 1
      END
      SUBROUTINE DISPROOM (ITYPE)
C
C     SUBROUTINE TO DISPLAY THE ROOM ON THE SCREEN.
C
C     THE ARGUMENT 'ITYPE' SPECIFIES THE DISPLAY TYPE:
C     1 - DISPLAY ROOM WITH COORDINATES GUIDE AND GUEST NAMES.
C     2 - DISPLAY ROOM WITH GUEST NAMES AND OCCUPATIONS.
C
      IMPLICIT INTEGER*4 (A-Z)
C
      REAL*4 RAND
C
      CHARACTER HORIZ*61, VERTIC*1, T*59, GUEST(8)*20
C
      COMMON /PARAM/ RAND, GUESTXY(2,8), TMINX, TMINY, TMAXX, TMAXY,
     1 IDEAL(8,9), GUEST
C
      DATA HORIZ/
     1 '+-----------------------------------------------------------+'/
      DATA VERTIC /'|'/
      DATA T/
     1 'TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT'/
C
      CALL DISPLAY (0, 0, HORIZ, .FALSE.)
      DO 100 I=1,20
      CALL DISPLAY (0, I, VERTIC, .FALSE.)
  100 CALL DISPLAY (60, I, VERTIC, .FALSE.)
      CALL DISPLAY (0, 21, HORIZ, .FALSE.)
C
C     DISPLAY COORDINATE SYSTEM FOR ITYPE 1.
C
      IF (ITYPE .EQ. 1) THEN
         CALL DISPLAY (63, 0, '   1        30', .FALSE.)
         CALL DISPLAY (63, 1, '  +----...---->', .FALSE.)
         CALL DISPLAY (63, 2, ' 1|          X', .FALSE.)
         CALL DISPLAY (63, 3, '  |', .FALSE.)
         CALL DISPLAY (63, 4, '  .', .FALSE.)
         CALL DISPLAY (63, 5, '  .', .FALSE.)
         CALL DISPLAY (63, 6, '  |', .FALSE.)
         CALL DISPLAY (63, 7, '20| Y', .FALSE.)
         CALL DISPLAY (63, 8, '  V', .FALSE.)
      END IF
C
C     DISPLAY THE TABLE IF IT HAS BEEN DEFINED.
C
      IF (TMINX .EQ. 0) GO TO 200
      LENGT = 2*(TMAXX-TMINX) + 1
      DO 150 I=TMINY,TMAXY
  150 CALL DISPLAY (2*TMINX-1, I, T(1:LENGT), .FALSE.)
C
C     DISPLAY ANY GUESTS WHOSE POSITIONS ARE KNOWN, AND THE GUEST LIST.
C
  200 IF (ITYPE .EQ. 1) THEN
         IY = 11
      ELSE
         IY = 1
      END IF
      CALL DISPLAY (63, IY-1, 'Party guest list:', .FALSE.)
C
      DO 250 I=1,8
      IF (GUESTXY(1,I).NE.0 .AND. GUESTXY(2,I).NE.0)
     1 CALL DISPLAY (2*GUESTXY(1,I)-1, GUESTXY(2,I), GUEST(I)(1:1),
     2 .FALSE.)
      IY = IY + 1
      J = INDEX (GUEST(I), ' ') - 1
      CALL DISPLAY (63, IY, GUEST(I)(1:1)//':', .FALSE.)
      CALL DISPLAY (66, IY, GUEST(I)(1:J), .FALSE.)
      IF (ITYPE .EQ. 2) THEN
         IY = IY + 1
         CALL DISPLAY (66, IY, GUEST(I)(J+2:), .FALSE.)
      END IF
  250 CONTINUE
C
      IY = IY + 2
      CALL DISPLAY (63, IY, 'T: Table', .FALSE.)
      RETURN
      END
      FUNCTION UNHAPPY (I)
C
C     FUNCTION TO CALCULATE THE UNHAPPINESS OF GUEST I.
C
C     THE ARGUMENT 'I' IS THE GUEST NUMBER WHOSE UNHAPPINESS IS
C     CALCULATED.
C
      IMPLICIT INTEGER*4 (A-Z)
C
      REAL*4 RAND, UNHAPPY, DISTANCE
C
      CHARACTER GUEST(8)*20
C
      COMMON /PARAM/ RAND, GUESTXY(2,8), TMINX, TMINY, TMAXX, TMAXY,
     1 IDEAL(8,9), GUEST
C
C     DEFINE DISTANCE FUNCTION (STATEMENT FUNCTION).
C
      DISTANCE (X1, Y1, X2, Y2) = SQRT (FLOAT(X1-X2)**2 +
     1  FLOAT(Y1-Y2)**2)
C
C     GET DISTANCE FROM ALL GUESTS, UNLESS THE IDEAL DISTANCE IS -1.
C
      UNHAPPY = 0.0
C
      DO 100 J=1,8
      IF (I.EQ.J .OR. IDEAL(I,J).EQ.-1) GO TO 100
      UNHAPPY = UNHAPPY + ABS (IDEAL(I,J) -
     1 DISTANCE(GUESTXY(1,I), GUESTXY(2,I), GUESTXY(1,J), GUESTXY(2,J)))
  100 CONTINUE
C
C     NOW ADD IN THE IDEAL DISTANCE TO THE TABLE.
C     FIRST CHECK IF THE GUEST IS ABOVE/BELOW OR LEFT/RIGHT OF THE
C     TABLE, ELSE TAKE THE DISTANCE TO THE NEAREST CORNER.
C
      IF (IDEAL(I,9) .EQ. -1) RETURN
      IF (GUESTXY(1,I).GE.TMINX .AND. GUESTXY(1,I).LE.TMAXX) THEN
         UNHAPPY = UNHAPPY + IABS(IDEAL(I,9) -
     1    MIN0(IABS(GUESTXY(2,I)-TMINY), IABS(GUESTXY(2,I)-TMAXY)))
         RETURN
      END IF
      IF (GUESTXY(2,I).GE.TMINY .AND. GUESTXY(2,I).LE.TMAXY) THEN
         UNHAPPY = UNHAPPY + IABS(IDEAL(I,9) -
     1    MIN0(IABS(GUESTXY(1,I)-TMINX), IABS(GUESTXY(1,I)-TMAXX)))
         RETURN
      END IF
      UNHAPPY = UNHAPPY + ABS(IDEAL(I,9) - AMIN1(
     1 DISTANCE (GUESTXY(1,I), GUESTXY(2,I), TMINX, TMINY),
     2 DISTANCE (GUESTXY(1,I), GUESTXY(2,I), TMAXX, TMINY),
     3 DISTANCE (GUESTXY(1,I), GUESTXY(2,I), TMINX, TMAXY),
     4 DISTANCE (GUESTXY(1,I), GUESTXY(2,I), TMAXX, TMAXY)))
      RETURN
      END
