      PROGRAM MINEFLD
C
C     DATA DESCRIPTION IS AS FOLLOWS:
C
C     A     -    BOARD POSITION TYPE INDICATOR
C                  1 = MINE
C                  2 = PLAYERS CURRENT POSITION
C                  4 = PLAYERS PREVIOUS POSITION
C                  5 = HOME POSITION
C                  6 = A ROCK
C                  7 = MINE DETONATED
C     CURSOR-    CURSOR CONTROL CODES FOR THE TERMINAL
C     LCURSOR-   CURSOR CONTROL CODE LENGTHS
C     RAND  -    RANDOM NUMBER
C     DISP  -    DISPLAY BUFFER
C     MESS  -    MESSAGE DISPLAY BUFFER
C     P & Q -    MOVE DIRECTION VECTORS
C
C     THE BASIC CURSOR CONTROL CO-ORDINATES ARE THOSE SUITABLE FOR
C     A HAZELTINE TERMINAL. I.E. X-Y ORDER WHERE X IS THE COLUMN NUMBER
C     FROM 0 TO 79 AND Y IS THE ROW NUMBER FROM 0 TO 23.
C     TOP LEFT IS 0,0           TOP RIGHT IS 79,0
C     BOTTOM LEFT IS 0,23       BOTTOM RIGHT IS 79,23
C
C        0,0----------> X
C          |
C          |
C          |
C          |
C          V
C          Y
C
C        THE PENULTIMATE LINE ON THE SCREEN IS USED FOR WARNINGS
C        THE LAST LINE ON THE SCREEN IS USED FOR INPUT PROMPT
C
C     VARIOUS TERMINAL AND TERMDEF SUPPORT ADDED BY MIKE PETERSON,
C     UNIVERSITY OF TORONTO CHEMISTRY DEPARTMENT.
C
      IMPLICIT INTEGER*4 (A-Z)
C
      INTEGER*4 A(20,35)
      INTEGER*4 CURSOR(10,22),BELL(10),CRET(10),LINF(10),CLRSCR(10),
     1 CURADD(10),HOME(10),CLRLIN(10),LCURSOR(22)
      INTEGER*4 DISPWORD,MESSWORD
      INTEGER*4 P(9),Q(9)
C
      REAL*4 RAND
C
      LOGICAL KILLED,LEGAL
C
C     MESSAGES AND GENERAL DISPLAY AREA
C
      INTEGER*4 MINFLD(13), SPACES(18)
      INTEGER*4 MESS1(5), MESS2(7), MESS3(7), MESS4(7)
      INTEGER*4 MESS5(9), MESS6(8), MESS7(12), MESS8(7)
      INTEGER*4 MESS9(11), MESS10(17), MESS11(14), MESS12(15)
      INTEGER*4 MESS13(10), MESS14(4)
C
      CHARACTER TEXT*10, zstring*2
      character*1 ans, blank4, yes, yeslower
      CHARACTER ZMINFLD*52, ZSPACES*68
      CHARACTER ZMESS1*20, ZMESS2*28, ZMESS3*28, ZMESS4*28
      CHARACTER ZMESS5*36, ZMESS6*32, ZMESS7*48, ZMESS8*28
      CHARACTER ZMESS9*44, ZMESS10*68, ZMESS11*56, ZMESS12*60
      CHARACTER ZMESS13*40, ZMESS14*20
C
      EQUIVALENCE (HOME(1),CURSOR(1,1)), (LHOME,LCURSOR(1))
      EQUIVALENCE (CURADD(1),CURSOR(1,6)), (LCURADD,LCURSOR(6))
      EQUIVALENCE (CLRSCR(1),CURSOR(1,8)), (LCLRSCR,LCURSOR(8))
      EQUIVALENCE (CLRLIN(1),CURSOR(1,10)), (LCLRLIN,LCURSOR(10))
      EQUIVALENCE (BELL(1),CURSOR(1,19)), (LBELL,LCURSOR(19))
      EQUIVALENCE (CRET(1),CURSOR(1,21)), (LCRET,LCURSOR(21))
      EQUIVALENCE (LINF(1),CURSOR(1,22)), (LLINF,LCURSOR(22))
C
      EQUIVALENCE (MINFLD(1),ZMINFLD), (SPACES(1),ZSPACES)
      EQUIVALENCE (MESS1(1),ZMESS1), (MESS2(1),ZMESS2)
      EQUIVALENCE (MESS3(1),ZMESS3), (MESS4(1),ZMESS4)
      EQUIVALENCE (MESS5(1),ZMESS5), (MESS6(1),ZMESS6)
      EQUIVALENCE (MESS7(1),ZMESS7), (MESS8(1),ZMESS8)
      EQUIVALENCE (MESS9(1),ZMESS9), (MESS10(1),ZMESS10)
      EQUIVALENCE (MESS11(1),ZMESS11), (MESS12(1),ZMESS12)
      EQUIVALENCE (MESS13(1),ZMESS13), (MESS14(1),ZMESS14)
C
      DATA ZMINFLD/'++++++++++++++++++++++++++++++++++++++++++++++++++++
     1'/
      DATA ZSPACES/'                                                    
     1                    '/
      DATA ZMESS1/' There are .. mines'/
      DATA ZMESS2/'There are no mines near you'/
      DATA ZMESS3/'There is 1 mine next to you'/
      DATA ZMESS4/'There are . mines around you'/
      DATA ZMESS5/'Move number .., which direction ? '/
      DATA ZMESS6/'Stay on the minefield, coward'/
      DATA ZMESS7/'Stop trying to climb rocks, they are too steep'/
      DATA ZMESS8/'BOOM       .....you are dead'/
      DATA ZMESS9/'Would you like to see where the mines are ?'/
      DATA ZMESS10/'Mine detector batteries exhausted, try navigating bl
     1indly.... Ha Ha'/
      DATA ZMESS11/'Well done. Would you like to see where the mines wer
     1e ?'/
      DATA ZMESS12/'The letter B is where you stood on a mine. Another g
     1ame ?'/
      DATA ZMESS13/'It took you .. moves. Another game ? '/
      DATA ZMESS14/'Another game ?'/
C
C     OTHER INITIALIZATION
C
      DATA P/-1,0,1,-1,0,1,-1, 0, 1/
      DATA Q/ 1,1,1, 0,0,0,-1,-1,-1/
      DATA YES/'Y'/, BLANK4/' '/, YESLOWER/'y'/
C     DATA LFCUT/'UT  '/, LFCVDU/'VDU '/
C
C     OPEN VDU AND ADJUST ITS FCB
C
C     OPEN (UNIT=LFCUT, OPENMODE='U')
C     OPEN (UNIT=LFCVDU, OPENMODE='U')
C     JADD = M:GETFCB(LFCVDU)
C     CALL SETFCB (JADD)
C
C     CHECK FOR TERMINAL TYPE ON INPUT LINE.
C
C     CALL X:TSCAN (1, I, DISP, TEXT)
      TERM = -1
C     IF (I.NE.1 .OR. DISP(2).NE.2) GO TO 20
C     IF (TEXT(1:1) .EQ. '*') THEN
C        TERM = 0
C     ELSE IF (TEXT(1:1).GE.'1' .AND. TEXT(1:1).LE.'6') THEN
C        READ (TEXT(1:1),10) TERM
C  10    FORMAT (I1)
C     END IF
C     GO TO 50
C
 20   call putline (0, ' ')
      call putline (0,
     1   'You are in square Y. Your objective is to cross '//
     2   'the minefield and reach')
      call putline (0,
     1   'square H in one piece. '//
     2   'A number of mines have been planted, but you will')
      call putline (0,
     3   'not be able to see them. There are also a few rocks '//
     4   'scattered about which you')
      call putline (0,
     4   'are not allowed to climb on '//
     5   '(they are too steep). Before each move a warning')
      call putline (0,
     6   'will be given of the number of mines immediately around '//
     7   'you but you will not')
      call putline (0,
     7   'be given the positions. If you '//
     8   'exceed 40 moves you will no longer be given')
      call putline (0,
     8   'the warning since your mine detector only has small '//
     9   'batteries, and they run')
      call putline (0,
     a   'out quite quickly.')
      call putline (0,
     B   'The directions you may move in are'//
     c   ' given by the following map, this map')
      call putline (0,
     c   'corresponds to the'//
     d   ' numeric keypad on the terminal with your position')
      call putline (0,
     e   'corresponding to the 5 key:')
      call putline (0,
     e   '         7 8 9')
      call putline (0,
     F   '         4 Y 6')
      call putline (0,
     F   '         1 2 3')
C
   50 CALL TERMSET (TERM, JADD, CURSOR, LCURSOR)
C
C     INITIALIZE DATA AREA
C
      RAND=0.0
 350  DO 370 X=1,25
      DO 360 Y=1,20
  360 A(Y,X)=0
 370  CONTINUE
      KILLED=.FALSE.
      LEGAL=.TRUE.
C
C     SET UP ROCKS
C
      CALL RANDOM (RAND)
      LIMIT=IFIX(RAND*50.0)+10
      DO 470 I=1,LIMIT
 420  CALL RANDOM (RAND)
      X=IFIX(24.0*RAND+1.4999)
      CALL RANDOM (RAND)
      Y=IFIX(19.0*RAND+1.4999)
      IF (A(Y,X) .EQ. 6) GO TO 420
      IF (X .EQ. 1 .AND. Y .EQ. 20) GO TO 420
      IF (X .EQ. 50 .AND. Y .EQ. 1) GO TO 420
      A(Y,X)=6
 470  CONTINUE
      MOVES=0
C
C     SET UP MINES
C
      CALL RANDOM (RAND)
      LIMIT=IFIX(RAND*50.0)+10
      DO 580 I=1,LIMIT
 520  CALL RANDOM (RAND)
      X=IFIX(24.0*RAND+1.4999)
      CALL RANDOM (RAND)
      Y=IFIX(19.0*RAND+1.4999)
      IF (A(Y,X) .EQ. 1) GO TO 520
      IF (X .EQ. 1 .AND. Y .EQ. 20) GO TO 520
      IF (X .EQ. 50 .AND. Y .EQ. 1) GO TO 520
      IF (A(Y,X) .EQ. 6) GO TO 520
      A(Y,X)=1
 580  CONTINUE
C
C     SET UP FIXED POSITIONS
C
      X=1
      Y=20
      XLAST=1
      YLAST=20
      A(20,1)=2
      A(1,25)=5
C
C     DISPLAY THE MINEFIELD
C
      CALL WRITCH (JADD,HOME,LHOME,TERM,*1880,*1880)
      CALL WRITCH (JADD,CLRSCR,LCLRSCR,TERM,*1880,*1880)
      CALL WRITCH (JADD,MINFLD,51,TERM,*1880,*1880)
      write (zstring,'(i2)') limit
      zmess1(12:13) = zstring
      CALL WRITCH (JADD,MESS1,19,TERM,*1880,*1880)
      DO 600 I=1,20
      CALL WRITCH (JADD,CRET,LCRET,TERM,*1880,*1880)
      CALL WRITCH (JADD,LINF,LLINF,TERM,*1880,*1880)
      CALL WRITCH (JADD,MINFLD,1,TERM,*1880,*1880)
      MESSWORD = 0
      CALL ISETBUFFER1 (1, 50, MESSWORD)
      CALL ISETBUFFER1 (2, I, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MINFLD,1,TERM,*1880,*1880)
 600  CONTINUE
      CALL WRITCH (JADD,CRET,LCRET,TERM,*1880,*1880)
      CALL WRITCH (JADD,LINF,LLINF,TERM,*1880,*1880)
      CALL WRITCH (JADD,MINFLD,51,TERM,*1880,*1880)
C
C     DISPLAY THE ROCKS
C
      DISPWORD = 0
      CALL ISETBUFFER1 (1, ICHAR('R'), DISPWORD)
      DO 610  I=1,20
      DO 605  J=1,25
      IF (A(I,J) .NE. 6) GO TO 605
      CALL ISETBUFFER1 (1, J*2-1, MESSWORD)
      CALL ISETBUFFER1 (2, I, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
 605  CONTINUE
 610  CONTINUE
      CALL ISETBUFFER1 (1, 1, MESSWORD)
      CALL ISETBUFFER1 (2, 20, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, ICHAR('Y'), DISPWORD)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, 49, MESSWORD)
      CALL ISETBUFFER1 (2, 1, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, ICHAR('H'), DISPWORD)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
C
C     COUNT THE NUMBER OF MINES AROUND HIM
C
 650  MINES=0
      DO 652  I=X-1,X+1
      IF (I.LE.0 .OR. I.GT.35) GO TO 652
      DO 651  J=Y-1,Y+1
      IF (J.LE.0 .OR. J.GT.20) GO TO 651
      IF (A(J,I) .EQ. 1) MINES=MINES+1
 651  CONTINUE
 652  CONTINUE
      IF (MOVES .GE. 40) GO TO 680
C
C     DISPLAY THE NUMBER OF MINES AROUND HIM, UNLESS LAST MOVE
C     WAS ILLEGAL
C
      IF (.NOT. LEGAL) GO TO 680
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 22, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      write (zstring,'(i1)') mines
      zmess4(11:11) = zstring(1:1)
      IF (MINES .GT. 0) GO TO 660
      CALL WRITCH (JADD,MESS2,28,TERM,*1880,*1880)
      GO TO 680
 660  IF (MINES .GT. 1) GO TO 670
      CALL WRITCH (JADD,MESS3,28,TERM,*1880,*1880)
      GO TO 680
 670  CALL WRITCH (JADD,MESS4,28,TERM,*1880,*1880)
C
C     DISPLAY HIS MOVE MESSAGE
C
 680  CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 23, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      IF (LCLRLIN .NE. 0) THEN
         CALL WRITCH (JADD,CLRLIN,LCLRLIN,TERM,*1880,*1880)
      ELSE
         CALL WRITCH (JADD,SPACES,72,TERM,*1880,*1880)
      END IF
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      write (zstring,'(i2)') moves+1
      zmess5(13:14) = zstring
      CALL WRITCH (JADD,MESS5,34,TERM,*1880,*1880)
      CALL READCH (JADD,NUM,ANS,*700,*1880)
      GO TO 710
  700 NUM = 5
C
C     ERASE PREVIOUS WARNING MESSAGE
C
  710 CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 22, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      IF (LCLRLIN .NE. 0) THEN
         CALL WRITCH (JADD,CLRLIN,LCLRLIN,TERM,*1880,*1880)
      ELSE
         CALL WRITCH (JADD,SPACES,72,TERM,*1880,*1880)
      END IF
      IF (NUM.LT.1 .OR. NUM.GT.9) NUM=5
      XLAST=X
      YLAST=Y
      X=X+P(NUM)
      Y=Y+Q(NUM)
C
C     CHECK FOR ILLEGAL DIRECTION
C
      IF (Y.GT.0 .AND. Y.LT.21 .AND. X.GT.0 .AND. X.LT.26)
     1    GO TO 1000
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 22, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS6,30,TERM,*1880,*1880)
      GO TO 1005
C
C     CHECK FOR ROCK CLIMBING
C
 1000 IF (A(Y,X) .NE. 6) GO TO 1140
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 22, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS7,46,TERM,*1880,*1880)
C
C     RESET POSITION IF ILLEGAL MOVE
C
 1005 Y=YLAST
      X=XLAST
      LEGAL=.FALSE.
      GO TO 650
C
C     MOVE IS O.K. WHAT HAPPENED ?
C
 1140 MOVES=MOVES+1
      LEGAL=.TRUE.
      A(YLAST,XLAST)=4
      IF (X .EQ. 25 .AND. Y .EQ.  1) GO TO 1810
      IF (A(Y,X) .NE. 1) GO TO 1250
C
C     HE BLEW IT ! ! !
C
      CALL ISETBUFFER1 (1, XLAST*2-1, MESSWORD)
      CALL ISETBUFFER1 (2, YLAST, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL ISETBUFFER1 (1, ICHAR('*'), DISPWORD)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, X*2-1, MESSWORD)
      CALL ISETBUFFER1 (2, Y, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL ISETBUFFER1 (1, ICHAR('B'), DISPWORD)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
      A(Y,X)=7
      KILLED=.TRUE.
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 22, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,BELL,LBELL,TERM,*1880,*1880)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS8,28,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 23, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      IF (LCLRLIN .NE. 0) THEN
         CALL WRITCH (JADD,CLRLIN,LCLRLIN,TERM,*1880,*1880)
      ELSE
         CALL WRITCH (JADD,SPACES,72,TERM,*1880,*1880)
      END IF
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS9,44,TERM,*1880,*1880)
      GO TO 1830
C
C     HE IS SAFE , BUT ARE HIS BATTERIES ?
C
 1250 A(Y,X)=2
      IF (MOVES .NE. 40) GO TO 1260
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 22, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS10,68,TERM,*1880,*1880)
 1260 CALL ISETBUFFER1 (1, XLAST*2-1, MESSWORD)
      CALL ISETBUFFER1 (2, YLAST, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL ISETBUFFER1 (1, ICHAR('*'), DISPWORD)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, X*2-1, MESSWORD)
      CALL ISETBUFFER1 (2, Y, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL ISETBUFFER1 (1, ICHAR('Y'), DISPWORD)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
      GO TO 650
C
C     HE MADE IT
C
 1810 CALL ISETBUFFER1 (1, XLAST*2-1, MESSWORD)
      CALL ISETBUFFER1 (2, YLAST, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL ISETBUFFER1 (1, ICHAR('*'), DISPWORD)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, 49, MESSWORD)
      CALL ISETBUFFER1 (2, 1, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL ISETBUFFER1 (1, ICHAR('Y'), DISPWORD)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 23, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      IF (LCLRLIN .NE. 0) THEN
         CALL WRITCH (JADD,CLRLIN,LCLRLIN,TERM,*1880,*1880)
      ELSE
         CALL WRITCH (JADD,SPACES,72,TERM,*1880,*1880)
      END IF
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS11,56,TERM,*1880,*1880)
C
C     DOES HE WANT TO SEE WHERE THE MINES ARE
C
 1830 ANS = BLANK4
      CALL READCH (JADD,NUM,ANS,*1880,*1880)
      IF (ANS.NE.YES .AND. ANS.NE.YESLOWER) GO TO 1850
      CALL ISETBUFFER1 (1, ICHAR('M'), DISPWORD)
      DO 1836 Y=1,20
      DO 1834 X=1,25
      IF (A(Y,X) .NE. 1) GO TO 1834
      CALL ISETBUFFER1 (1, X*2-1, MESSWORD)
      CALL ISETBUFFER1 (2, Y, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,DISPWORD,1,TERM,*1880,*1880)
 1834 CONTINUE
 1836 CONTINUE
      IF (.NOT. KILLED) GO TO 1860
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 23, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      IF (LCLRLIN .NE. 0) THEN
         CALL WRITCH (JADD,CLRLIN,LCLRLIN,TERM,*1880,*1880)
      ELSE
         CALL WRITCH (JADD,SPACES,72,TERM,*1880,*1880)
      END IF
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS12,58,TERM,*1880,*1880)
      GO TO 1870
 1850 IF (.NOT. KILLED) GO TO 1860
      CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 23, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      IF (LCLRLIN .NE. 0) THEN
         CALL WRITCH (JADD,CLRLIN,LCLRLIN,TERM,*1880,*1880)
      ELSE
         CALL WRITCH (JADD,SPACES,72,TERM,*1880,*1880)
      END IF
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      write (zstring,'(i2)') moves
      zmess13(13:14) = zstring
      CALL WRITCH (JADD,MESS13,37,TERM,*1880,*1880)
      GO TO 1870
 1860 CALL ISETBUFFER1 (1, 0, MESSWORD)
      CALL ISETBUFFER1 (2, 23, MESSWORD)
      CALL TRANSP (MESSWORD, TERM)
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      IF (LCLRLIN .NE. 0) THEN
         CALL WRITCH (JADD,CLRLIN,LCLRLIN,TERM,*1880,*1880)
      ELSE
         CALL WRITCH (JADD,SPACES,72,TERM,*1880,*1880)
      END IF
      CALL WRITCH (JADD,CURADD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESSWORD,LCURADD,TERM,*1880,*1880)
      CALL WRITCH (JADD,MESS14,15,TERM,*1880,*1880)
C
 1870 ANS = BLANK4
      CALL READCH (JADD,NUM,ANS,*1880,*1880)
      IF (ANS.EQ.YES .OR. ANS.EQ.YESLOWER) GO TO 350
 1880 STOP
      END
