C     ****************************************************************
C     *              KENO PROGRAM                                    *
C     ****************************************************************
C
C     THE BASIC CURSOR CONTROL CO-ORDINATES ARE THOSE SUITABLE FOR
C     A HAZELTINE TERMINAL. I.E. X-Y ORDER WHERE X IS THE COLUMN NUMBER
C     FROM 0 TO 79 AND Y IS THE ROW NUMBER FROM 0 TO 23.
C     TOP LEFT IS 0,0           TOP RIGHT IS 79,0
C     BOTTOM LEFT IS 0,23       BOTTOM RIGHT IS 79,23
C
C        0,0-----------> X
C          |
C          |
C          |
C          |
C          V
C          Y
C
C     PROGRAM MODIFICATIONS TO SUPPORT DIFFERENT TERMINAL TYPES DONE BY:
C     MIKE PETERSON, DEPT OF CHEMISTRY, UNIV OF TORONTO, TORONTO, CANADA
C
      PROGRAM KENO
C
      REAL ZRAND(5)
C
C     PICK(80)       KEEPS TRACK OF RANDOM SELECTIONS.
C     SELECTION(80)  KEEPS TRACK OF USER'S PICKS.
C     MULTIPLE       FOR LARGE BETS (MULTIPLES OF 5).
C
      LOGICAL PICK(80)
      LOGICAL SELECTION(80)
      LOGICAL MULTIPLE
C
      CHARACTER TEXT*10
      character zcaret, zexclam, zx
C
C     MESSAGES.
C
      INTEGER*4 CARET, EXCLAM, X
C
C     CURSOR CONTROL COMMON BLOCK DEFINITIONS.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), DISPWORD, CURADD(10),
     1 BELL(10)
C
      COMMON /CURCOM/ CURSOR, LCURSOR, ITERM, DISPWORD, JADD
C
      EQUIVALENCE (CURADD(1),CURSOR(1,6)), (LCURADD,LCURSOR(6))
      EQUIVALENCE (BELL(1),CURSOR(1,19)), (LBELL,LCURSOR(19))
      equivalence (zcaret,caret), (zexclam,exclam), (zx,x)
C
      DATA MAXZ/30/, MAXH/25/
      DATA CARET/'^   '/, EXCLAM/'!!!!'/, X/'X   '/
C     DATA LFCUT/'UT  '/, LFCVDU/'VDU '/
C
C     OPEN VDU AND ADJUST ITS FCB
C
C     OPEN (UNIT=LFCUT, OPENMODE='U')
C     OPEN (UNIT=LFCVDU, OPENMODE='U')
C     JADD = M:GETFCB(LFCVDU)
C     CALL SETFCB (JADD)
C
C     CHECK FOR TERMINAL TYPE ON INPUT LINE.
C
C     CALL X:TSCAN (1, I, DISP, TEXT)
      ITERM = -1
C     IF (I.NE.1 .OR. DISP(2).NE.2) GO TO 20
C     IF (TEXT(1:1) .EQ. '*') THEN
C        ITERM = 0
C     ELSE IF (TEXT(1:1).GE.'1' .AND. TEXT(1:1).LE.'6') THEN
C        READ (TEXT(1:1),10) ITERM
C  10    FORMAT (I1)
C     END IF
C
   20 CALL TERMSET (ITERM, JADD, CURSOR, LCURSOR)
C
C     INITIALIZE VARIABLES
C
      NBUCKS=25
      NULL=0
C
C     START
C
C     SPIN RANDOM NUMBER GENERATOR
      CALL SPIN (ZRAND)
C     CLEAR SCREEN
      CALL CLEAR
C     SET UP MATRIX ON SCREEN
      CALL SETUP
C     SHOW MONEY
      CALL PROMPTER (5,NBUCKS)
C
C     BEGIN REPEATABLE CYCLE
C
      do while (nbucks.gt.0)
C
      NWINNER = 0
      do 30 i=1,80
      pick(i)=.false.
30    selection(i)=.false.
C
C     GET INITIAL CONDITIONS FROM USER
C
      nbet = nbucks + 1
      do while (nbet.gt.nbucks)
C        CLEAR LINE
         CALL PROMPTER (2,0)
C        WHAT'S THE BET?
         CALL PROMPTER (6,0)
         READ (5,*) NBET
         IF (NBET.GT.NBUCKS) THEN
C           BLANK LINE
            CALL PROMPTER (2,0)
C           YOU BET TOO MUCH
            CALL PROMPTER (14,0)
            CALL DELAY (2)
         END IF
      END DO
C     ONLY WAY OUT EXCEPT BANKRUPTCY
      IF (NBET.LE.0) GO TO 900
C     RESET LARGE BET FLAG
      MULTIPLE=.FALSE.
      IF (NBET.GT.5) THEN
         MULTIPLE=.TRUE.
         MULTIPLIER=NBET/5
      END IF
      ncount = 16
      do while (ncount.gt.15)
C        BLANK SCREEN
         CALL PROMPTER (2,0)
C        HOW MANY DO YOU WANT?
         CALL PROMPTER (4,0)
         READ (5,*) NCOUNT
      END DO
      DO 5 N=1,NCOUNT
	 numb = 0
         do while (numb.le.0.or.numb.gt.80)
C           BLANK SCREEN
            CALL PROMPTER (2,0)
C           SELECT A NUMBER
            CALL PROMPTER (1,0)
            READ (5,*) NUMB
            IF (NUMB.GT.80.OR.NUMB.LT.1) THEN
            CALL PROMPTER (2,0)
            CALL PROMPTER (10,0)
            CALL DELAY (2)
            ELSE IF (SELECTION(NUMB)) THEN
C           CLEAR LINE
            CALL PROMPTER (2,0)
C           THAT'S BEEN CHOSEN
            CALL PROMPTER (11,0)
            CALL DELAY (2)
	    numb = 0
            END IF
         END DO
C        MARK IT SELECTED
         SELECTION(NUMB)=.TRUE.
         CALL PLOTTER (NUMB,NVERT,NHORIZ)
	 DISPWORD = 0
         CALL ISETBUFFER1 (1, NHORIZ, DISPWORD)
         CALL ISETBUFFER1 (2, NVERT, DISPWORD)
         CALL TRANSP (DISPWORD, ITERM)
         CALL WRITCH (JADD, CURADD, LCURADD, ITERM, *9000, *9000)
         CALL WRITCH (JADD, DISPWORD, LCURADD, ITERM, *9000, *9000)
         CALL WRITCH (JADD, CARET, 1, ITERM, *9000, *9000)
5        CONTINUE
C     CLEAR PROMPT LINE
      CALL PROMPTER (2,0)
C     GOOD LUCK
      CALL PROMPTER (7,0)
      CALL DELAY (1)
C     GENERATE AND PLOT 20 RANDOM NUMBERS
      DO 3 N=1,20
C        PICK AN UNUSED NUMBER
100      CALL SPIN  (ZRAND)
         NPLOT=ZRAND(1)*80.+1
         if (pick(nplot)) go to 100
C        INDICATE IT'S USED NOW
         PICK(NPLOT)=.TRUE.
         CALL PLOTTER (NPLOT,NVERT,NHORIZ)
	 DISPWORD = 0
         CALL ISETBUFFER1 (1, NHORIZ, DISPWORD)
         CALL ISETBUFFER1 (2, NVERT, DISPWORD)
         IF (SELECTION(NPLOT)) THEN
            CALL ISETBUFFER1 (1, NHORIZ-2, DISPWORD)
            CALL TRANSP (DISPWORD, ITERM)
            CALL WRITCH (JADD, CURADD, LCURADD, ITERM, *9000, *9000)
            CALL WRITCH (JADD, DISPWORD, LCURADD, ITERM, *9000, *9000)
            CALL WRITCH (JADD, EXCLAM, 4, ITERM, *9000, *9000)
            CALL WRITCH (JADD, BELL, LBELL, ITERM, *9000, *9000)
C           KEEP COUNT OF WINNERS
            NWINNER=NWINNER+1
         ELSE
            CALL TRANSP (DISPWORD, ITERM)
            CALL WRITCH (JADD, CURADD, LCURADD, ITERM, *9000, *9000)
            CALL WRITCH (JADD, DISPWORD, LCURADD, ITERM, *9000, *9000)
            CALL WRITCH (JADD, X, 1, ITERM, *9000, *9000)
         END IF
         CALL DELAY (1)
3        CONTINUE
C
C     CLEAR PROMPT LINE
      CALL PROMPTER (2,0)
      CALL PROMPTER (8,NWINNER)
      CALL DELAY (2)
      CALL PAYOFF(NCOUNT,NWINNER,NBET,NDOL)
C     TAKE CARE OF LARGE BETS
      IF (MULTIPLE) NDOL=NDOL*MULTIPLIER
C     CLEAR LINE AGAIN
      CALL PROMPTER (2,0)
C     SHOW WINNINGS
      CALL PROMPTER (9,NDOL)
      CALL DELAY (2)
      NBUCKS=NBUCKS-NBET+NDOL
      CALL PROMPTER (5,NBUCKS)
      CALL DELAY (2)
      CALL SUBCLEAR
C
      END DO
C
C     CLEAR PROMPT LINE
900   CALL PROMPTER (2,0)
      IF (NBUCKS.LE.0) THEN
C        COMMISERATE WITH THE TURKEY
         CALL PROMPTER (12,0)
      ELSE
C        GIVE HIM THE BUM'S RUSH
         CALL PROMPTER (13,0)
      END IF
      CALL DELAY (2)
C
 9000 STOP
      END
C
C     SUBROUTINE TO FIND PROPER PLACE TO POST FOR A GIVEN NUMBER
C
      SUBROUTINE PLOTTER(NN,NVERT,NHORIZ)
C
      NJ=NN-1
C     FIND TENS
      NVERT=NJ/10
C     FIND UNITS
      NHORIZ=NJ-10*NVERT
C     TRANSLATE TO LINE NUMBER
      NVERT=NVERT*2+3
C     TRANSLATE TO HORIZ POSITION
      NHORIZ=NHORIZ*6+10
      RETURN
      END
C
C     SUBROUTINE TO DISPLAY MATRIX ON SCREEN
C
      SUBROUTINE SETUP
C
C     CURSOR CONTROL COMMON BLOCK DEFINITIONS.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), DISPWORD, CURADD(10)
C
      COMMON /CURCOM/ CURSOR, LCURSOR, ITERM, DISPWORD, JADD
C
      EQUIVALENCE (CURADD(1),CURSOR(1,6)), (LCURADD,LCURSOR(6))
C
C     8 LINES, 10 NUMBERS PER LINE
      DO 1 N=1,8
         DO 2 NN=1,10
C           CALCULATE POSITION ACROSS
            NTAB=NN*6-4
C           CALCULATE ACTUAL DISPLAYED NUMB
            NACT=(N-1)*10+NN
C           VERTICAL COORDINATE
	    DISPWORD = 0
            CALL ISETBUFFER1 (2, 2*N, DISPWORD)
C           HORIZONTAL COORDINATE
            CALL ISETBUFFER1 (1, NTAB+7, DISPWORD)
            CALL TRANSP (DISPWORD, ITERM)
            CALL WRITCH (JADD, CURADD, LCURADD, ITERM, *9000, *9000)
            CALL WRITCH (JADD, DISPWORD, LCURADD, ITERM, *9000, *9000)
            WRITE (6,99) NACT
2        CONTINUE
1     CONTINUE
      RETURN
C
 9000 STOP
C
   99 FORMAT (I2,$)
      END
C
C     SUBROUTINE TO CLEAR ONLY THE NUMBER MARKS
C
      SUBROUTINE SUBCLEAR
C
C     CURSOR CONTROL COMMON BLOCK DEFINITIONS.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), DISPWORD, CURADD(10),
     1 CLRLIN(10)
C
      COMMON /CURCOM/ CURSOR, LCURSOR, ITERM, DISPWORD, JADD
C
      EQUIVALENCE (CURADD(1),CURSOR(1,6)), (LCURADD,LCURSOR(6))
      EQUIVALENCE (CLRLIN(1),CURSOR(1,10)), (LCLRLIN,LCURSOR(10))
C
      DO 1 N=1,8
         DISPWORD = 0
         NVERT=N*2+1
         CALL ISETBUFFER1 (2, NVERT, DISPWORD)
         CALL TRANSP (DISPWORD, ITERM)
         CALL WRITCH (JADD, CURADD, LCURADD, ITERM, *9000, *9000)
         CALL WRITCH (JADD, DISPWORD, LCURADD, ITERM, *9000, *9000)
         IF (LCLRLIN .NE. 0) THEN
            CALL WRITCH (JADD, CLRLIN, LCLRLIN, ITERM, *9000, *9000)
         ELSE
            WRITE (6,10)
         END IF
    1 CONTINUE
      RETURN
C
 9000 STOP
C
   10 FORMAT (70X)
      END
C
C     SUBROUTINE TO POST PROMPT MESSAGES
C
      SUBROUTINE PROMPTER(N,NDOLLARS)
C
C     CURSOR CONTROL COMMON BLOCK DEFINITIONS.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), DISPWORD, CURADD(10),
     1 CLRLIN(10)
C
      COMMON /CURCOM/ CURSOR, LCURSOR, ITERM, DISPWORD, JADD
C
      EQUIVALENCE (CURADD(1),CURSOR(1,6)), (LCURADD,LCURSOR(6))
      EQUIVALENCE (CLRLIN(1),CURSOR(1,10)), (LCLRLIN,LCURSOR(10))
C
      DISPWORD = 0
      CALL ISETBUFFER1 (1, 4, DISPWORD)
      CALL ISETBUFFER1 (2, 21, DISPWORD)
      CALL TRANSP (DISPWORD, ITERM)
      CALL WRITCH (JADD, CURADD, LCURADD, ITERM, *9000, *9000)
      CALL WRITCH (JADD, DISPWORD, LCURADD, ITERM, *9000, *9000)
C
C     1 = SELECT A NUMBER
      IF (N.EQ.1) THEN
         WRITE (6,10)
C     2 = BLANK PROMPT LINE
      ELSE IF (N.EQ.2) THEN
         IF (LCLRLIN .NE. 0) THEN
            CALL WRITCH (JADD, CLRLIN, LCLRLIN, ITERM, *9000, *9000)
         ELSE
            WRITE (6,11)
         END IF
C     3 = TOO MANY
      ELSE IF (N.EQ.3) THEN
         WRITE (6,12)
C     4 = HOW MANY DO YOU WANT?
      ELSE IF (N.EQ.4) THEN
         WRITE (6,13)
C     5 = PRINT DOLLARS
      ELSE IF (N.EQ.5) THEN
         CALL ISETBUFFER1 (1, 4, DISPWORD)
         CALL ISETBUFFER1 (2, 19, DISPWORD)
         CALL TRANSP (DISPWORD, ITERM)
         CALL WRITCH (JADD, CURADD, LCURADD, ITERM, *9000, *9000)
         CALL WRITCH (JADD, DISPWORD, LCURADD, ITERM, *9000, *9000)
         WRITE (6,14) NDOLLARS
C     6 = WHAT'S YOUR BET?
      ELSE IF (N.EQ.6) THEN
         WRITE (6,15)
C     7 = GOOD LUCK
      ELSE IF (N.EQ.7) THEN
         WRITE (6,16)
C     8 = YOU HAD N WINNERS
      ELSE IF (N.EQ.8) THEN
         WRITE (6,17) NDOLLARS
C     9 = YOUR WINNING
      ELSE IF (N.EQ.9) THEN
         WRITE (6,18) NDOLLARS
C     10 = NUMBER OUT OF RANGE
      ELSE IF (N.EQ.10) THEN
         WRITE (6,19)
C     11 = ALREADY PICKED
      ELSE IF (N.EQ.11) THEN
         WRITE (6,20)
C     12 = YOU'RE OUT OF MONEY
      ELSE IF (N.EQ.12) THEN
         WRITE (6,21)
C     13 = COME BACK SOON
      ELSE IF (N.EQ.13) THEN
         WRITE (6,22)
C     14 = YOU BET TOO MUCH
      ELSE IF (N.EQ.14) THEN
         WRITE (6,23)
      END IF
      RETURN
C
 9000 STOP
C
   10 FORMAT ('  Select a number: ',$)
   11 FORMAT (70X)
   12 FORMAT ('  Sorry, too many!  Try again.  ')
   13 FORMAT ('  How many numbers do you want? ',$)
   14 FORMAT ('  You have ',i6,' dollars')
   15 FORMAT ('  What is your bet? 1, 3, or 5 ',$)
   16 FORMAT ('  ***** GOOD LUCK! *****')
   17 FORMAT ('  You had ',i2,' winners')
   18 FORMAT ('  You won ',i5,' dollars')
   19 FORMAT ('  Number should be 1 to 80')
   20 FORMAT ('  That has been picked')
   21 FORMAT ('  Sorry, pal.  Come back tomorrow.')
   22 FORMAT ('  Come on back!  It was just getting fun!')
   23 FORMAT ('  HOWD''JA LIKE YER THUMBS BROKEN? ')
      END
C
C     SUBROUTINE TO COMPUTE PAYOFF
C
      SUBROUTINE PAYOFF(NPLAYED,NWON,NBET,NDOL)
C
      DIMENSION NPAY01(3,2)
      DIMENSION NPAY02(3,2)
      DIMENSION NPAY03(3,4)
      DIMENSION NPAY04(3,4)
      DIMENSION NPAY05(3,6)
      DIMENSION NPAY06(3,6)
      DIMENSION NPAY07(3,8)
      DIMENSION NPAY08(3,8)
      DIMENSION NPAY09(3,10)
      DIMENSION NPAY10(3,10)
      DIMENSION NPAY11(3,12)
      DIMENSION NPAY12(3,12)
      DIMENSION NPAY13(3,14)
      DIMENSION NPAY14(3,14)
      DIMENSION NPAY15(3,16)
C
C     BET  1
      DATA NPAY01 /    3,    9,   15,    0,    0,    0/
C     BET  2
      DATA NPAY02 /    0,    0,    0,   12,   36,   60/
C     BET  3
      DATA NPAY03 /    0,    0,    0,    1,    3,    5,
     *                42,  126,  210,    0,    0,    0/
C     BET  4
      DATA NPAY04 /    0,    0,    0,    1,    3,    5,
     *                 4,   12,   20,  112,  336,  560/
C     BET  5
      DATA NPAY05 /    0,    0,    0,    0,    0,    0,
     *                 2,    6,   10,   20,   60,  100,
     *               480, 1440, 2400,    0,    0,    0/
C     BET  6
      DATA NPAY06 /    0,    0,    0,    0,    0,    0,
     *                 1,    3,    5,    4,   12,   20,
     *                88,  264,  440, 1480, 4440, 7400/
C     BET  7
      DATA NPAY07 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    2,    6,   10,
     *                24,   72,  120,  360, 1080, 1800,
     *              5000,15000,25000,    0,    0,    0/
C     BET  8
      DATA NPAY08 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 9,   27,   45,   92,  276,  460,
     *              1480, 4440, 7400,18000,50000,50000/
C     BET  9
      DATA NPAY09 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 4,   12,   20,   44,  132,  220,
     *               300,  900, 1500, 4000,12000,20000,
     *             20000,50000,50000,    0,    0,    0/
C     BET 10
      DATA NPAY10 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 2,    6,   10,   20,   60,  100,
     *               132,  396,  660,  960, 2880, 4800,
     *              3800,11400,19000,25000,50000,50000/
C     BET 11
      DATA NPAY11 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 1,    3,    5,    8,   24,   40,
     *                72,  216,  360,  360, 1080, 1800,
     *              1800, 5400, 9000,12000,36000,50000,
     *             28000,50000,50000,    0,    0,    0/
C     BET 12
      DATA NPAY12 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    5,   15,   25,
     *                32,   96,  160,  240,  720, 1200,
     *               600, 1800, 3000, 1480, 4440, 7400,
     *              8000,24000,40000,36000,50000,50000/
C     BET 13
      DATA NPAY13 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    1,    3,    5,
     *                16,   48,   80,   80,  240,  400,
     *               720, 2160, 3600, 4000,12000,20000,
     *              8000,24000,40000,20000,50000,50000,
     *             36000,50000,50000,    0,    0,    0/
C     BET 14
      DATA NPAY14 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    1,    3,    5,
     *                10,   30,   50,   40,  120,  200,
     *               300,  900, 1500, 1000, 3000, 5000,
     *              3200, 9600,16000,16000,48000,50000,
     *             24000,50000,50000,40000,50000,50000/
C     BET 15
      DATA NPAY15 /    0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 0,    0,    0,    0,    0,    0,
     *                 8,   24,   40,   28,   84,  140,
     *               132,  396,  660,  300,  900, 1500,
     *              2600, 7800,13000, 8000,24000,40000,
     *             24000,50000,50000,32000,50000,50000,
     *             40000,50000,50000,    0,    0,    0/
C
C     KEEP AMOUNT BET
      NSAVE = NBET
C     LARGE BET COVER
      IF (NBET.GT.5) NBET = 5
C     ILLEGAL BETS
      IF (NBET.EQ.2.OR.NBET.EQ.4) NBET = 1
      IF (NBET.EQ.3) NBET = 2
      IF (NBET.EQ.5) NBET = 3
      IF (NWON.EQ.0) THEN
         NDOL = 0
      ELSE IF (NPLAYED.EQ. 1) THEN
         NDOL = NPAY01(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 2) THEN
         NDOL = NPAY02(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 3) THEN
         NDOL = NPAY03(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 4) THEN
         NDOL = NPAY04(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 5) THEN
         NDOL = NPAY05(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 6) THEN
         NDOL = NPAY06(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 7) THEN
         NDOL = NPAY07(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 8) THEN
         NDOL = NPAY08(NBET,NWON)
      ELSE IF (NPLAYED.EQ. 9) THEN
         NDOL = NPAY09(NBET,NWON)
      ELSE IF (NPLAYED.EQ.10) THEN
         NDOL = NPAY10(NBET,NWON)
      ELSE IF (NPLAYED.EQ.11) THEN
         NDOL = NPAY11(NBET,NWON)
      ELSE IF (NPLAYED.EQ.12) THEN
         NDOL = NPAY12(NBET,NWON)
      ELSE IF (NPLAYED.EQ.13) THEN
         NDOL = NPAY13(NBET,NWON)
      ELSE IF (NPLAYED.EQ.14) THEN
         NDOL = NPAY14(NBET,NWON)
      ELSE IF (NPLAYED.EQ.15) THEN
         NDOL = NPAY15(NBET,NWON)
      END IF
C     RESTORE ACTUAL BET
      NBET=NSAVE
      RETURN
      END
C
C     SUBROUTINE TO SPIN RANDOM NUMBER GENERATOR
C
      SUBROUTINE SPIN (ZRAND)
C
      INTEGER*4 PART(4)
C
      REAL*4 ZRAND(5)
C
C     GET TIME OF DAY
      call itime (part)
      part(4) = part(1) + part(2) + part(3)
C     MIX 'EM UP
      NUMBER = PART(1)*PART(2)+PART(3)+PART(4)
      DO 1 N=1,NUMBER
    1    CALL RANDNO(NUMBER,ZRAND)
      RETURN
      END
      SUBROUTINE RANDNO(ZSEED,ZRAND)
C*                                                                    *C
C*  RETURNS A UNIFORMLY DISTRIBUTED PSEUDORANDOM NUMBER IN THE RANGE  *C
C*  OF 0.0 TO 1.0 USING THE LINEAR CONGRUENTIAL METHOD.  REPEAT       *C
C*  PERIOD IS 1048576.                                                *C
C*   THE GENERATOR HAS AN UNIFORM DISTRIBUTION.
C*
C*
C*  REFERENCE OF RANDOM NUMBER GENERATOR IS 'PRINCIPLES OF
C*    OF FORTRAN 77 PROGRAMMING', BY JERROLD L. WAGENER,
C*    JOHN WILEY AND SONS, NEW YORK, 1980, PG. 177.
C*
      REAL*4 ZRAND(5)
C
      INTEGER ZSEED
C
      DO I=1,5
C     OBTAIN THE NEXT SEED.
         ZSEED= MOD ( ZSEED * 1029 + 221591 ,1048576 )
C     COMPUTE THE RANDOM NUMBER USING THE SEED.
         ZRAND(I)  = FLOAT (ZSEED) / 1048576.0
      ENDDO
      RETURN
      END
