      subroutine isetbuffer1 (i, ival, ibuf)
c
c     Set the i'th byte of 'ibuf', counting the left bytes as byte 1,
c     to 'ival'.
c
c     This routine only works for positive values of 'ival' and 'ibuf'.
c
      dimension ibyte(4)
c
      if (i.lt.1 .or. i.gt.4) then
	 write (6,*) 'Byte ', i, ' is invalid in isetbuffer1.'
	 stop
      endif
      if (ival.lt.0 .or. ival.gt.127) then
	 write (6,*) 'Ival ', i, ' is invalid in isetbuffer1.'
	 stop
      endif
c
c     Extract each byte.
c
      ibyte(1) = igetbuffer1 (1, ibuf)
      ibyte(2) = igetbuffer1 (2, ibuf)
      ibyte(3) = igetbuffer1 (3, ibuf)
      ibyte(4) = igetbuffer1 (4, ibuf)
c
c     Replace byte 'i'.
c
      ibyte(i) = ival
c
c     Put them back.
c
      ibuf = (((ibyte(1)*256+ibyte(2))*256)+ibyte(3))*256 + ibyte(4)
      return
      end
